/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	RBD
 *
 *	$Id: graphnbr.c,v 6.1 96/11/23 22:52:16 nevin Rel $
 *
 *	Function:	- get neighbours of a process
 *	Accepts:	- communicator
 *			- rank
 *			- size of neighbours array 
 *			- neighbours array (returned value)
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>

int
MPI_Graph_neighbors(comm, rank, maxnbrs, nbrs)

MPI_Comm		comm;
int			rank;
int			maxnbrs;
int			*nbrs;

{
	int		nnbrs;
	int		i;
	int		*p;

	lam_initerr();
	lam_setfunc(BLKMPIGRAPHNBR);
/*
 * Check the arguments.
 */
	if (comm == MPI_COMM_NULL) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPIGRAPHNBR, lam_mkerr(MPI_ERR_COMM, 0)));
	}

	if (LAM_IS_INTER(comm)) {
		return(lam_errfunc(comm,
			BLKMPIGRAPHNBR, lam_mkerr(MPI_ERR_COMM, 0)));
	}

	if (!LAM_IS_GRAPH(comm)) {
		return(lam_errfunc(comm, BLKMPIGRAPHNBR,
				lam_mkerr(MPI_ERR_TOPOLOGY, 0)));
	}

	if ((rank < 0) || (rank >= comm->c_group->g_nprocs)) {
		return(lam_errfunc(comm,
			BLKMPIGRAPHNBR, lam_mkerr(MPI_ERR_RANK, 0)));
	}

	if ((maxnbrs < 0) || ((maxnbrs > 0) && (nbrs == 0))) {
		return(lam_errfunc(comm,
			BLKMPIGRAPHNBR, lam_mkerr(MPI_ERR_ARG, 0)));
	}
/*
 * Fill the neighbours.
 */
	nnbrs = comm->c_topo_index[rank];
	p = comm->c_topo_edges;

	if (rank > 0) {
		i = comm->c_topo_index[rank - 1];
		nnbrs -= i;
		p += i; 
	}

	for (i = 0; (i < maxnbrs) && (i < nnbrs); ++i, ++p) {
		*nbrs++ = *p;
	}

	lam_resetfunc(BLKMPIGRAPHNBR);
	return(MPI_SUCCESS);
}
