/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	RBD/JRV
 *
 *	$Id: gatherv.c,v 6.1 96/11/23 22:51:52 nevin Rel $
 *
 *	Function:	- gather vectored buffers at root in process rank order
 *	Accepts:	- send buffer
 *			- send count
 *			- send datatype
 *			- recv buffer
 *			- recv counts
 *			- displacements
 *			- recv datatype
 *			- root
 *			- communicator
 *	Returns:	- MPI_SUCCESS or an MPI error code
 */

#include <app_mgmt.h>
#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>
#include <rpisys.h>

int
MPI_Gatherv(sbuf, scount, sdtype,
			rbuf, rcounts, disps, rdtype, root, comm)

void			*sbuf;
int			scount;
MPI_Datatype		sdtype;
void			*rbuf;
int			*rcounts;
int			*disps;
MPI_Datatype		rdtype;
int			root;
MPI_Comm		comm;

{
	int		i;			/* favourite index */
	int		rank;			/* my rank */
	int		size;			/* group size */
	int		err;			/* error code */
	char		*ptmp;			/* temp. buffer */
	MPI_Aint	extent;			/* datatype extent */
	MPI_Status	stat;			/* receive status */
	struct _gps	*p;			/* favourite pointer */

	lam_initerr();
	lam_setfunc(BLKMPIGATHERV);
/*
 * Check for invalid arguments.
 */
	if ((comm == MPI_COMM_NULL) || LAM_IS_INTER(comm)) {
		return(lam_errfunc(comm, BLKMPIGATHERV,
					lam_mkerr(MPI_ERR_COMM, 0)));
	}

	MPI_Comm_rank(comm, &rank);
	MPI_Comm_size(comm, &size);

	if ((root >= size) || (root < 0)) {
		return(lam_errfunc(comm, BLKMPIGATHERV,
					lam_mkerr(MPI_ERR_ROOT, 0)));
	}

	if ((sdtype == MPI_DATATYPE_NULL)
			|| (rank == root && rdtype == MPI_DATATYPE_NULL)) {
		return(lam_errfunc(comm, BLKMPIGATHERV,
					lam_mkerr(MPI_ERR_TYPE, 0)));
	}


	if ((rank == root) && (disps == 0)) {
		return(lam_errfunc(comm, BLKMPIGATHERV,
					lam_mkerr(MPI_ERR_ARG, 0)));
	}

	if ((scount < 0) || (rank == root && rcounts == 0)) {
		return(lam_errfunc(comm, BLKMPIGATHERV,
					lam_mkerr(MPI_ERR_COUNT, 0)));
	}

	LAM_TRACE(lam_tr_cffstart(BLKMPIGATHERV));
/*
 * Remember required parameters.
 */
	p = &(comm->c_group->g_procs[root]->p_gps);

	lam_setparam(BLKMPIGATHERV, root | (p->gps_grank << 16),
				(p->gps_node << 16) | p->gps_idx);
/*
 * Switch to collective communicator.
 */
	lam_mkcoll(comm);
/*
 * Everyone but root sends data and returns.
 */
	if (rank != root) {

		err = MPI_Send(sbuf, scount, sdtype,
					root, BLKMPIGATHERV, comm);
		lam_mkpt(comm);

		if (err != MPI_SUCCESS) {
			return(lam_errfunc(comm, BLKMPIGATHERV, err));
		}

		LAM_TRACE(lam_tr_cffend(BLKMPIGATHERV,
						root, comm, sdtype, scount));

		lam_resetfunc(BLKMPIGATHERV);
		return(MPI_SUCCESS);
	}
/*
 * I am the root, loop receiving data.
 */
	MPI_Type_extent(rdtype, &extent);

	for (i = 0; i < size; ++i) {

		ptmp = ((char *) rbuf) + (extent * disps[i]);
/*
 * simple optimization
 */
		if (i == rank) {
			err = lam_dtsndrcv(sbuf, scount, sdtype,
						ptmp, rcounts[i], rdtype,
						BLKMPIGATHERV, comm);
		} else {
			err = MPI_Recv(ptmp, rcounts[i], rdtype, i,
						BLKMPIGATHERV, comm, &stat);
		}

		if (err != MPI_SUCCESS) {
			lam_mkpt(comm);
			return(lam_errfunc(comm, BLKMPIGATHERV, err));
		}
	}

	lam_mkpt(comm);

	LAM_TRACE(lam_tr_cffend(BLKMPIGATHERV, root, comm, sdtype, scount));

	lam_resetfunc(BLKMPIGATHERV);
	return(MPI_SUCCESS);
}
