/*
 *	Ohio Trollius
 *	Copyright 1997 The Ohio State University
 *	NJN/RBD
 *
 *	$Id: waitany_f.c,v 6.1.1.1 97/03/24 14:58:45 nevin Exp Locker: nevin $
 *
 *	Function:	- MPI_Waitany F77 wrapper
 */

#include <lam_config.h>

#include <errno.h>
#include <stdlib.h>

#include <blktype.h>
#include <mpi.h>
#include <MPISYS.h>
#include <mpisys.h>

void
mpi_waitany_(c, rqs, idx, st, ierr)

int			*c, *rqs, *idx, *st, *ierr;

{
	MPI_Request	*reqs;
        MPI_Status      stat;
	int		i;

	if (*c > 0) {
		reqs = (MPI_Request *) malloc((*c) * sizeof(MPI_Request));
		if (reqs == 0) {
			lam_setfunc(BLKMPIWAITANY);
			*ierr = lam_errfunc(MPI_COMM_WORLD, BLKMPIWAITANY,
					lam_mkerr(MPI_ERR_OTHER, errno));
			return;
		}
	} else {
		reqs = 0;
	}

	for (i = 0; i <	*c; ++i) reqs[i] = GETHDL(rqs[i]);

	*ierr =	MPI_Waitany(*c,	reqs, idx, &stat);

	if (*ierr == MPI_SUCCESS) {
		lam_C2F_stat(&stat, st);
		st[6] =	-1;

		if (*idx >= 0) {
			if (reqs[*idx] == MPI_REQUEST_NULL) {
				lam_F_typefree(rqs[*idx]);
				rqs[*idx] = -1;
			}

			++(*idx);
		}
	}

	free((char *) reqs);
}
