/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	NJN
 *
 *	$Id: spawnmult_f.c,v 6.1.1.1 96/12/13 15:07:08 nevin Exp $
 *
 *	Function:	- MPI_Spawn_multiple F77 wrapper
 */

#include <lam_config.h>

#include <errno.h>
#include <stdlib.h>

#include <args.h>
#include <blktype.h>
#include <mpi.h>
#include <MPISYS.h>
#include <mpisys.h>
#include <typical.h>

/*
 * private functions
 */
static int		f2c_argvs();


void
mpi_spawn_multiple_(n, cmd, av, mps, infs, root, comm, icomm, ec, ierr, nc, na)

char			*cmd, *av;
int			*n, *mps, *infs, *root, *comm, *icomm, *ec, *ierr;
int			nc, na;

{
	MPI_Comm	intercomm;
	MPI_Info	*infos;
	char		***argvs = 0;
	char		**commands;
	int		*errs;
	int		i;
/*
 * check arguments
 */
	if (*n <= 0) {
		lam_setfunc(BLKMPISPAWNMULT);
		*ierr = lam_errfunc(GETHDL(*comm), BLKMPISPAWNMULT,
					lam_mkerr(MPI_ERR_ARG, 0));
		return;
	}
/*
 * Create info array.
 */
	if ((infos = (MPI_Info *) malloc(*n * sizeof(MPI_Info *))) == 0) {
		lam_setfunc(BLKMPISPAWNMULT);
		*ierr = lam_errfunc(GETHDL(*comm), BLKMPISPAWNMULT,
					lam_mkerr(MPI_ERR_SPAWN, errno));
		return;
	}

	for (i = 0; i < *n; i++) {
		infos[i] = GETHDL(infs[i]);
	}
/*
 * Check for special argument values.
 */
	if ((void *) ec == lam_F_errdontcare) {
		errs = MPI_ERRCODES_DONTCARE;
	} else {
		errs = ec;
	}

	if ((void *) av == lam_F_argvsnull) {
		argvs = MPI_ARGVS_NULL;
	} else {
/*
 * Convert F77 argument arrays to C argument vectors.
 */
		if (f2c_argvs(*n, av, na, &argvs)) {
			free((char *) infos);
			lam_setfunc(BLKMPISPAWNMULT);
			*ierr = lam_errfunc(GETHDL(*comm), BLKMPISPAWNMULT,
					lam_mkerr(MPI_ERR_SPAWN, errno));
			return;
		}
	}
/*
 * Convert F77 command strings to C array of commands.
 */
	if (lam_F2C_argv(cmd, nc, &commands)) {
		free((char *) infos);
		for (i = 0; i < *n; i++) {
			argvfree(argvs[i]);
		}
		lam_setfunc(BLKMPISPAWNMULT);
		*ierr = lam_errfunc(GETHDL(*comm), BLKMPISPAWNMULT,
					lam_mkerr(MPI_ERR_SPAWN, errno));
		return;
	}

	*ierr = MPI_Spawn_multiple(*n, commands, argvs, mps, infos,
				*root, GETHDL(*comm), &intercomm, errs);

	lam_F_maketype(icomm, ierr, (void *) intercomm);

	for (i = 0; i < *n; i++) {
		argvfree(argvs[i]);
	}
	argvfree(commands);
	free((char *) infos);
}

/*
 *	f2c_argvs
 *
 *	Function:	- creates array of C argument vector from an
 *			  F77 2-d array of strings
 *	Accepts:	- first dimension of 2-d array
 *			- F77 2-d array of strings
 *			- length of strings
 *			- array of C argument vectors (out)
 *	Returns:	- 0 or LAMERROR
 */
static int
f2c_argvs(dim, array, len, argvs)

int			dim;
char			*array;
int			len;
char			****argvs;

{
	int		argc;			/* argument vector count */
	char		***argvarr;		/* array of argument vectors */
	char		*cstr;			/* C string */
	char		*p;
	int		i, j;

	if ((argvarr = (char ***) malloc(dim * sizeof(char **))) == 0) {
		return(LAMERROR);
	}

	for (i = 0; i < dim; i++) {

		argc = 0;
		argvarr[i] = 0;
		p = array + len * i;

		while (1) {
			cstr = lam_F2C_string(p, len);

			if (cstr == 0) {
				for (j = 0; j <= i; j++) {
					argvfree(argvarr[j]);
				}
				return(LAMERROR);
			}

			if (*cstr == 0) break;

			if (argvadd(&argc, &argvarr[i], cstr)) {
				for (j = 0; j <= i; j++) {
					argvfree(argvarr[j]);
				}
				return(LAMERROR);
			}

			p += len * dim;
		}
	}

	*argvs = argvarr;
	return(0);
}
