/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio	State University
 *	NJN
 *
 *	$Id: accept_f.c,v 6.1 96/11/22 13:44:37 nevin Rel $
 *
 *	Function:	- MPI_Accept F77 wrapper
 */

#include <lam_config.h>

#include <errno.h>
#include <stdlib.h>

#include <blktype.h>
#include <mpi.h>
#include <MPISYS.h>
#include <mpisys.h>

void
mpi_accept_(port, info,	root, comm, icomm, ierr, n)

char			*port;
int			*info, *root, *comm, *icomm, *ierr;
int			n;

{
	MPI_Comm	intercomm;
	char		*port_name;

	port_name = lam_F2C_string(port, n);
	if (port_name == 0) {
		lam_setfunc(BLKMPIACCEPT);
		*ierr =	lam_errfunc(GETHDL(*comm), BLKMPIACCEPT,
					lam_mkerr(MPI_ERR_OTHER, errno));
		return;
	}

	*ierr =	MPI_Accept(port_name, GETHDL(*info),
				*root, GETHDL(*comm), &intercomm);
	
	lam_F_maketype(icomm, ierr, (void *) intercomm);
	free(port_name);
}
