/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	RBD
 *
 *	$Id: errset.c,v 6.1 96/11/23 22:51:46 nevin Rel $
 *
 *	Function:	- set error handler for communicator
 *	Accepts:	- communicator
 *			- error handler
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>

int
MPI_Errhandler_set(comm, errhdl)

MPI_Comm		comm;
MPI_Errhandler		errhdl;

{
	lam_initerr();
	lam_setfunc(BLKMPIERRSET);
/*
 * Check the arguments.
 */
	if (comm == MPI_COMM_NULL) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPIERRSET, lam_mkerr(MPI_ERR_COMM, 0)));
	}

	if (errhdl == MPI_ERRHANDLER_NULL) {
		return(lam_errfunc(comm,
			BLKMPIERRSET, lam_mkerr(MPI_ERR_ARG, 0)));
	}
/*
 * Set the communicator's error handler.
 */
	comm->c_errhdl = errhdl;
	++(errhdl->eh_refcount);

	lam_resetfunc(BLKMPIERRSET);
	return(MPI_SUCCESS);
}
