/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	RBD
 *
 *	$Id: cartdimget.c,v 6.1 96/11/23 22:51:10 nevin Rel $
 *
 *	Function:	- get # dimensions in cartesian topology
 *	Accepts:	- communicator
 *			- ptr # dimensions (returned value)
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>

int
MPI_Cartdim_get(comm, pndims)

MPI_Comm		comm;
int			*pndims;

{
	lam_initerr();
	lam_setfunc(BLKMPICARTDIMGET);
/*
 * Check the arguments.
 */
	if (comm == MPI_COMM_NULL) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPICARTDIMGET, lam_mkerr(MPI_ERR_COMM, 0)));
	}

	if (LAM_IS_INTER(comm)) {
		return(lam_errfunc(comm,
			BLKMPICARTDIMGET, lam_mkerr(MPI_ERR_COMM, 0)));
	}

	if (!LAM_IS_CART(comm)) {
		return(lam_errfunc(comm, BLKMPICARTDIMGET,
				lam_mkerr(MPI_ERR_TOPOLOGY, 0)));
	}

	if (pndims == 0) {
		return(lam_errfunc(comm,
			BLKMPICARTDIMGET, lam_mkerr(MPI_ERR_ARG, 0)));
	}

	*pndims = comm->c_topo_ndims;

	lam_resetfunc(BLKMPICARTDIMGET);
	return(MPI_SUCCESS);
}
