/*
 *	Ohio Trollius
 *	Copyright 1997 The Ohio State University
 *	NJN
 *
 *	$Id: shm.sol.h,v 6.1.1.2 97/03/24 12:04:23 nevin Exp $
 *
 *	Function:	- shared memory / TCP client-to-client interface header
 *			- Solaris using inter-process thread semaphores
 */

#ifndef _SHM_SOL_H
#define _SHM_SOL_H

#include <sys/ipc.h>
#include <sys/shm.h>
#include <sys/sem.h>
#include <synch.h>

#include <all_hash.h>
#include <all_list.h>
#include <mpisys.h>
#include <portable.h>
#include <t_types.h>

/*
 * constants
 */
#define CACHELINESIZE   16			/* max. size of a cache line */
#define C2CINITSIZE	0			/* initialization data size */
#define INITHASH	((int4) 32)		/* initial hash table size */
#define LAMSHMDELAY	10			/* poll loop delay (usecs) */
#define TCPSHORTMSGLEN 	16384			/* max. length short tcp msg */
#define SHMBLKSIZE 	16384			/* size of shm block */
#define SHMBUFSIZE 	(SHMBLKSIZE / 2)	/* size of shm buffer */
#define SHMSHORTMSGLEN \
		(SHMBUFSIZE - (sizeof(struct c2c_envl) + (2 * CACHELINESIZE)))
						/* max. length short shm msg */
/*
 * data structures
 *
 *
 * client-to-client specific process data
 */
struct c2c_proc {
	struct c2c_envl	cp_env;			/* incoming envelope */
	int		cp_write;		/* ok to try to write flag */
	int		cp_read;		/* ok to try to read flag */
	int		cp_sock;		/* socket descriptor */
	char		*cp_envbuf;		/* envelope buffer pointer */
	int		cp_nenvin;		/* # env. bytes left to read */
	char		*cp_msgbuf;		/* message buffer pointer */
	int		cp_nmsgin;		/* # msg. bytes left to read */
	int		cp_extra;		/* # bytes to go into sink */
	int		cp_shm;			/* id of shm block */
	int		cp_locked;		/* incoming is locked? */
	char		*cp_shmbuf;		/* shared memory buffer */
	char		*cp_shmout;		/* outgoing shm buffer */
	char		*cp_shmin;		/* incoming shm buffer */
	sema_t		*cp_irdlock;		/* input read lock */
	sema_t		*cp_iwtlock;		/* input write lock */
	sema_t		*cp_ordlock;		/* output read lock */
	sema_t		*cp_owtlock;		/* output write lock */
	MPI_Request	cp_wreq;		/* req. writing to process */
	MPI_Request	cp_rreq;		/* reading req. */
	MPI_Request	cp_mreq;		/* req. to test matching from */
	int		(*cp_readfn)();		/* read function */
	struct cbuf_msg *cp_bmsg;		/* buffering? */
	int		cp_nbfde;		/* # buffered envelopes */
};

/*
 * locking macros
 */
#define _shm_readlock(p)	_sol_lock((p)->cp_irdlock)
#define _shm_readtrylock(p)	_sol_trylock((p)->cp_irdlock)
#define _shm_readunlock(p)	sema_post((p)->cp_iwtlock)

#define _shm_writelock(p)	_sol_lock((p)->cp_owtlock)
#define _shm_writetrylock(p)	_sol_trylock((p)->cp_owtlock)
#define _shm_writeunlock(p)	sema_post((p)->cp_ordlock)

/*
 * prototypes of LAM MPI library client-to-client internal functions
 */
#ifndef __ARGS
#if __STDC__ || defined(c_plusplus) || defined(__cplusplus)
#define __ARGS(a)	a
#else
#define __ARGS(a)	()
#endif
#endif

#ifdef __cplusplus
extern "C" {
#endif

extern int	_sol_lock __ARGS((sema_t *));
extern int	_sol_trylock __ARGS((sema_t *));

#ifdef __cplusplus
}
#endif

#endif	/* _SHM_SOL_H */
