/*
 *	Ohio Trollius
 *	Copyright 1993 The Ohio State University
 *	RBD
 *
 *	$Log:	vctable.c,v $
 * Revision 6.1  96/11/23  19:58:22  nevin
 * Ohio Release
 * 
 * Revision 6.0  96/02/29  13:49:06  gdburns
 * Ohio Release
 * 
 * Revision 5.2  94/08/22  13:57:11  gdburns
 * Ohio Release
 * 
 * Revision 5.1  94/05/18  11:18:22  gdburns
 * Ohio Release
 * 
 * Revision 2.3.1.1  94/05/18  11:12:21  raja
 * Add _vcfree() to clear the V.C. table.
 * 
 * Revision 2.3  94/04/22  12:35:09  gdburns
 * Ohio Release
 * 
 * Revision 2.2  93/10/15  13:57:46  raja
 * pre-release to 2.3
 * 
 *	Function:	- manipulate the table of virtual circuits
 *
 *			- _vcinsert(): insert a new virtual circuit
 *			- _vcfind(): locate a virtual circuit entry
 *			- _vcdelete(): delete a virtual circuit entry
 */

#include <portable.h>
#include <net.h>
#include <terror.h>
#include <typical.h>
#include <vctable.h>

/*
 * external variables
 */
extern int		errno;

/*
 * local variables
 */
static int		f_init = 1;		/* initialization flag */
static struct vcdesc	vctable[VCMAX];		/* VC hash table */

/*
 *	_vcinsert
 *
 *	Function:	- insert a virtual circuit in the table
 *			- initialize the table if necessary
 *			- does not allow duplicate entries
 *	Accepts:	- node ID
 *			- event
 *			- type
 *			- VC path
 *	Returns:	- 0 or ERROR
 */
int
_vcinsert(node, event, type, path)

int4			node;
int4			event;
int4			type;
int4			path;

{
	int4		i, j;		/* favourite indices */
	struct vcdesc	*p;		/* favourite pointer */
/*
 * Initialize the table if first time function is called.
 */
	if (f_init) {
		f_init = 0;
		for (i = 0, p = vctable; i < VCMAX; ++i, ++p) {
			p->vc_node = NOTNODEID;
		}
	}

	if (node == NOTNODEID) {
		errno = EBADNODE;
		return(ERROR);
	}
/*
 * Locate an empty slot in the hash table.
 * Duplicate entries are not allowed.
 */
	i = _vchash(node, event, type);
	p = vctable + i;

	for (j = 0; j < VCMAX; ++j) {
		if (p->vc_node == NOTNODEID) {
/*
 * Found empty slot.
 */
			break;
		}
		else if ((p->vc_node == node) &&
			(p->vc_event == event) && (p->vc_type == type)) {
/*
 * Found duplicate entry.
 */
			errno = EINVAL;
			return(ERROR);
		}

		if (++i == VCMAX) {
			i = 0;
			p = vctable;
		} else {
			++p;
		}
	}
/*
 * If table is full, return an error.
 */
	if (j == VCMAX) {
		errno = EFULL;
		return(ERROR);
	}
/*
 * Fill the empty slot.
 */
	p->vc_node = node;
	p->vc_event = event;
	p->vc_type = type;
	p->vc_path = path;

	return(0);
}

/*
 *	_vcfind
 *
 *	Function:	- locate a virtual circuit in the table
 *	Accepts:	- node ID
 *			- event
 *			- type
 *	Returns:	- ptr to VC entry or NULL
 */
struct vcdesc *
_vcfind(node, event, type)

int4			node;
int4			event;
int4			type;

{
	int4		i, j;		/* favourite indices */
	struct vcdesc	*p;		/* favourite pointer */

	if (node == NOTNODEID) {
		errno = EBADNODE;
		return((struct vcdesc *) 0);
	}
/*
 * Locate the entry in the hash table.
 */
	i = _vchash(node, event, type);
	p = vctable + i;

	for (j = 0; j < VCMAX; ++j) {
		if ((p->vc_node == node) &&
			(p->vc_event == event) && (p->vc_type == type)) {
/*
 * The entry is found.
 */
			return(p);
		}

		if (++i == VCMAX) {
			i = 0;
			p = vctable;
		} else {
			++p;
		}
	}
/*
 * The entry does not exist.
 */
	errno = EINVAL;
	return((struct vcdesc *) 0);
}

/*
 *	_vcdelete
 *
 *	Function:	- delete a virtual circuit from the table
 *	Accepts:	- node ID
 *			- event
 *			- type
 *	Returns:	- 0 or ERROR
 */
int
_vcdelete(node, event, type)

int4			node;
int4			event;
int4			type;

{
	struct vcdesc	*p;		/* favourite pointer */
/*
 * Locate the correct VC entry in the table
 */
	p = _vcfind(node, event, type);
	if (p == 0) {
		return(ERROR);
	}
/*
 * Erase the entry.
 */
	p->vc_node = NOTNODEID;

	return(0);
}

/*
 *	_vcfree
 *
 *	Function:	- free all virtual circuits
 */
void
_vcfree()

{
	int4		i;		/* favourite index */
	struct vcdesc	*p;		/* favourite pointer */
/*
 * Free all V.C. entries.
 */
	f_init = 1;

	for (i = 0, p = vctable; i < VCMAX; ++i, ++p) {
		p->vc_node = NOTNODEID;
		close(p->vc_path);
	}

}
