/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	RBD
 *
 *	$Id: microsleep.c,v 6.1 96/11/17 20:40:49 nevin Exp $
 * 
 *	Function:	- higher precision sleep (microseconds)
 *			- uses select() timeout value
 *			- does not restart if interrupted
 */

#include <lam_config.h>

#include <errno.h>
#include <sys/types.h>
#include <sys/time.h>

#if NEED_SYS_SELECT_H
#include <sys/select.h>
#endif

int
microsleep(usec)

unsigned int		usec;

{
	struct timeval	timeout;

	timeout.tv_sec = usec / 1000000;
	timeout.tv_usec = usec % 1000000;

	while ((select(0, (fd_set *) 0, (fd_set *) 0,
			(fd_set *) 0, &timeout) < 0) && (errno == EINTR));

	return(0);
}
