/*
 *	Ohio Trollius
 *	Copyright 1997 The Ohio State University
 *	RBD
 *
 *	$Id: getworkdir.c,v 6.1.1.1 97/02/24 12:23:40 nevin Exp $
 * 
 *	Function:	- get the user's current working directory
 *			- dynamically allocated space
 *			- use old getwd() for efficiency if possible
 *			- hopefully our MAX is bigger than everybody's MAX
 *			  (someday a _real_ standard will emerge!)
 *	Returns:	- working directory or NULL
 */

#include <stdlib.h>

#include "lam.h"

#define PATHSIZE	2048


char *
getworkdir()

{
	char		*cwd;		/* working directory name */
/*
 * Allocate a hopefully large enough buffer;
 */
	if ((cwd = malloc((unsigned) PATHSIZE)) == 0) {
		return((char *) 0);
	}
/*
 * Get the working directory.  Work around SunOS bug.
 */
#if HAVE_GETCWD && !defined(SUNOS)
	if (getcwd(cwd, PATHSIZE)) {
#else
	if (getwd(cwd)) {
#endif
		return(cwd);
	} else {
		free(cwd);
		return((char *) 0);
	}
}
