/*
   PXKMenuItem.m

   Copyright (C) 1996 Free Software Foundation, Inc.

   Author: Ovidiu Predescu <ovidiu@net-community.com>
   Date: May 1997
   
   This file is part of the GNUstep GUI X/DPS Library.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "config.h"
#include <AppKit/NSImage.h>
#include <AppKit/NSColor.h>
#include <AppKit/NSGraphics.h>
#include <AppKit/NSFont.h>

#include <gnustep/xdps/PXKMenuItem.h>
#include <gnustep/xdps/PXKDPSContext.h>
#include <gnustep/xdps/PXKDrawingFunctions.h>

static NSCell* additionalCell = nil;

@implementation PXKMenuItem

+ (void)initialize
{
  additionalCell = [NSCell new];
}

- (void)drawInteriorWithFrame:(NSRect)cellFrame
                       inView:(NSView*)view
               backgroundGray:(float)backgroundGray
{
  NSFont* font = [self font];
  BOOL isEnabled = [self isEnabled];
  NSString* keyEquiv;
  NSRect rect;

  [additionalCell setStringValue:[self title]];
  [additionalCell setAlignment:NSLeftTextAlignment];
  [additionalCell setFont:font];
  [additionalCell setEnabled:isEnabled];
  [additionalCell setType:NSTextCellType];
  [additionalCell drawInteriorWithFrame:cellFrame inView:view];

  rect.size.width = ADDITIONAL_WIDTH;
  rect.size.height = cellFrame.size.height;
  rect.origin.x = cellFrame.origin.x + cellFrame.size.width
		      - rect.size.width;
  rect.origin.y = cellFrame.origin.y;

  if (hasSubmenu) {
    NSImage* image = (backgroundGray == NSWhite
			      ? [NSImage imageNamed:@"common_RightH"]
			      : [NSImage imageNamed:@"common_Right"]);
    [additionalCell setImage:image];
    [additionalCell setType:NSImageCellType];
    [additionalCell drawInteriorWithFrame:rect inView:view];
  }
  else if ((keyEquiv = [self userKeyEquivalent])) {
    [additionalCell setStringValue:keyEquiv];
    [additionalCell setAlignment:NSRightTextAlignment];
    [additionalCell setFont:font];
    [additionalCell setEnabled:isEnabled];
    [additionalCell setType:NSTextCellType];
    [additionalCell drawInteriorWithFrame:rect inView:view];
  }
}

- (void)drawWithFrame:(NSRect)cellFrame
               inView:(NSView *)controlView
{
  float backgroundGray = NSLightGray;

  PSgsave();

  if ([self isHighlighted] && [self isEnabled])
    backgroundGray = NSWhite;

  /* Clear the cell frame */
  PSsetgray (backgroundGray);
  PSrectfill (cellFrame.origin.x, cellFrame.origin.y,
              cellFrame.size.width, cellFrame.size.height);

  NSDrawButton (cellFrame, cellFrame);
  cellFrame.origin.x += 1;
  cellFrame.origin.y += 2;
  cellFrame.size.width -= 3;
  cellFrame.size.height -= 3;

  [self drawInteriorWithFrame:cellFrame
                       inView:controlView
               backgroundGray:backgroundGray];
  PSgrestore();
}

@end
