/* 
   FakeAdaptor.h

   Copyright (C) 1996 Free Software Foundation, Inc.

   Author: Mircea Oancea <mircea@jupiter.elcom.pub.ro>
   Date: 1996

   This file is part of the GNUstep Database Library.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.
   If not, write to the Free Software Foundation,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef __FakeAdaptor_h__
#define __FakeAdaptor_h__

#include <Foundation/NSObject.h>

@class NSString;
@class NSDictionary;
@class NSMutableArray;
@class EOModel;

@class FakeAdaptorContext;
@class FakeAdaptorChannel;

@interface FakeAdaptor : NSObject
{
    NSString* 		name;
    NSDictionary*	connectionDictionary;
    EOModel*		model;
    NSMutableArray*	contexts;
}
- initWithName:(NSString*)aName;
- (NSString *)name;
- (void)contextDidInit:aCtx;
- (void)contextWillDealloc:aCtx;

- (void)setConnectionDictionary:(NSDictionary*)aDictionary;
- (NSDictionary*)connectionDictionary;
- (BOOL)hasValidConnectionDictionary;

- (void)setModel:(EOModel*)aModel;
- (EOModel*)model;

- (FakeAdaptorContext*)createAdaptorContext;

- (Class)expressionClass;
- (BOOL)isValidQualifierType:(NSString*)aTypeName;
- formatAttribute:(EOAttribute*)attribute;
- formatValue:value forAttribute:(EOAttribute*)attribute;

- (void)reportError:(NSString*)anError;
@end /* FakeAdaptor */

@interface FakeAdaptorContext : NSObject
{
    FakeAdaptor*	adaptor;
    NSMutableArray*	channels;
    int			nestLevel;
    int			countSuccess;
    int			countFailure;
}

- initWithAdaptor:(EOAdaptor*)adaptor;
- (FakeAdaptor*)adaptor;

- (void)channelDidInit:aCtx;
- (void)channelWillDealloc:aCtx;

- (FakeAdaptorChannel*)createAdaptorChannel;

- (BOOL)hasOpenChannels;
- (BOOL)hasBusyChannels;

- (BOOL)beginTransaction;
- (BOOL)commitTransaction;
- (BOOL)rollbackTransaction;

- (void)transactionDidBegin;
- (void)transactionDidCommit;
- (void)transactionDidRollback;

- (BOOL)canNestTransactions;
- (unsigned)transactionNestingLevel; 

/* Test Flow control */

- setSuccessCount:(int)yn;
- setFailCount:(int)yn;

@end /* FakeAdaptorContext */

@interface FakeAdaptorChannel : NSObject
{
    FakeAdaptorContext*	context;
    BOOL		isFetchInProgress;
    BOOL		isOpen;
    int			countSuccess;
    int			countFailure;
}
- initWithAdaptorContext:(FakeAdaptorContext*)adaptorContext;
- (FakeAdaptorContext*)adaptorContext;

- (BOOL)isOpen;
- (BOOL)openChannel;
- (void)closeChannel;

- (BOOL)insertRow:(NSDictionary*)aRow forEntity:(EOEntity*)anEntity;
- (BOOL)updateRow:(NSDictionary*)aRow 
  describedByQualifier:(EOQualifier*)aQualifier; 
- (BOOL)deleteRowsDescribedByQualifier:(EOQualifier*)aQualifier;
- (BOOL)selectAttributes:(NSArray*)attributes
  describedByQualifier:(EOQualifier*)aQualifier
  fetchOrder:(NSArray*)aFetchOrder
  lock:(BOOL)aLockFlag;

- (NSArray*)describeResults;

- (NSMutableDictionary*)fetchAttributes:(NSArray*)attributes 
  withZone:(NSZone*)zone;
- (BOOL)isFetchInProgress;
- (void)cancelFetch;

- (BOOL)evaluateExpression:(NSString*)anExpression;

/* Test Flow control */

- setSuccessCount:(int)yn;
- setFailCount:(int)yn;

@end /* FakeAdaptorChannel */

#endif /* __FakeAdaptor_h__ */
