AC_SUBST(MAKE)dnl
AC_SUBST(OBJC_RUNTIME)dnl
AC_SUBST(OBJC_RUNTIME_FLAG)dnl
AC_SUBST(FOUNDATION_LIBRARY)dnl
AC_SUBST(BUNDLE_LDPROG)dnl
AC_SUBST(BUNDLE_CFLAGS)dnl
AC_SUBST(BUNDLE_LDFLAGS)dnl
AC_SUBST(HOST)dnl
AC_SUBST(HOST_CPU)dnl
AC_SUBST(HOST_VENDOR)dnl
AC_SUBST(HOST_OS)dnl
dnl
dnl
AC_DEFUN(AC_LANG_OBJECTIVE_C,
[AC_REQUIRE([AC_PROG_CC])dnl
define([AC_LANG], [AC_LANG_OBJECTIVE_C])dnl
ac_ext=m
# CFLAGS is not in ac_cpp because -g, -O, etc. are not valid cpp options.
ac_cpp='$CPP $OBJC_RUNTIME_FLAG'
ac_compile='${CC-cc} -c $OBJC_RUNTIME_FLAG $CFLAGS conftest.$ac_ext 1>&AC_FD_CC 2>&AC_FD_CC'
ac_link='${CC-cc} -o conftest $OBJC_RUNTIME_FLAG $CFLAGS $LDFLAGS conftest.$ac_ext $LIBS $OBJC_LIBS 1>&AC_FD_CC 2>&AC_FD_CC'
])dnl
dnl
dnl
AC_DEFUN(AC_FIND_FOUNDATION,
[AC_REQUIRE([AC_PROG_CC])dnl
AC_REQUIRE([AC_C_CROSS])dnl
AC_MSG_CHECKING(for the Foundation library)
AC_CACHE_VAL(ac_cv_foundation_library,
[if test "$FOUNDATION" = ""; then
AC_TRY_CPP(
#include <foundation/NSObject.h>
, ac_cv_foundation_library=foundation)
AC_LANG_SAVE[]dnl
AC_LANG_OBJECTIVE_C[]
AC_TRY_COMPILE(
#import <Foundation/NSObject.h>
#import <synch.h>
,
, ac_cv_foundation_library=Sun)
AC_TRY_COMPILE(
#include <Foundation/preface.h>
,
, ac_cv_foundation_library="gnustep-base")
AC_TRY_COMPILE(
#include <Foundation/exceptions/FoundationException.h>
,
, ac_cv_foundation_library="$ac_cv_foundation_library libFoundation")
AC_LANG_RESTORE[]dnl
else
    ac_cv_foundation_library=$FOUNDATION
fi
])dnl
libs_found=`echo ${ac_cv_foundation_library} | awk '{print NF}' -`
if test $libs_found -gt 1; then
    echo "" 1>&2
    AC_MSG_ERROR([More than one Foundation library installed on your system. In the FOUNDATION variable you must specify exactly one of the following libraries: ${ac_cv_foundation_library}])
fi
FOUNDATION_LIBRARY=`echo ${ac_cv_foundation_library} | awk '{print $1}'`
case "$FOUNDATION_LIBRARY" in
    foundation)
	OBJC_RUNTIME=next
	FND_LIBS="-lFoundation_s";

	if test "$prefix" = "NONE"; then
	    CFLAGS="-I`eval \"echo $ac_default_prefix\"`/include/next $CFLAGS"
	else
	    CFLAGS="-I`eval \"echo $prefix\"`/include/next $CFLAGS"
	fi

	AC_DEFINE(NeXT_foundation_LIBRARY);;
    Sun)
	OBJC_RUNTIME=sun;
	FND_LIBS="-lFoundation";

	if test "$prefix" = "NONE"; then
	    CFLAGS="-I`eval \"echo $ac_default_prefix\"`/include/next $CFLAGS"
	else
	    CFLAGS="-I`eval \"echo $prefix\"`/include/next $CFLAGS"
	fi

	AC_DEFINE(Sun_Foundation_LIBRARY);;
    gnustep-base)
	FND_LIBS="-lgnustep-base"
	AC_DEFINE(GNUSTEP_BASE_LIBRARY);;
    libFoundation)
	if test "$FOUNDATION_LIB" = ""; then
	    FOUNDATION_LIB=Foundation
	fi
	FND_LIBS="-l${FOUNDATION_LIB}"
	AC_DEFINE(LIB_FOUNDATION_LIBRARY);;
    *)
	AC_MSG_ERROR(Unknown $FOUNDATION_LIBRARY library!);;
esac
AC_MSG_RESULT(${ac_cv_foundation_library})
if test "${FOUNDATION_LIBRARY}" != "libFoundation"; then
    AC_CHECK_FOUNDATION_EXTENSIONS
fi
AC_DETERMINE_RUNTIME
])dnl
dnl
dnl
AC_DEFUN(AC_CHECK_FOUNDATION_EXTENSIONS,
[AC_REQUIRE([AC_PROG_CC])dnl
AC_REQUIRE([AC_C_CROSS])dnl
AC_MSG_CHECKING(for the Foundation extensions library)
AC_CACHE_VAL(ac_cv_foundation_extensions,
[AC_LANG_SAVE[]dnl
AC_LANG_OBJECTIVE_C[]
AC_TRY_COMPILE(
#include <extensions/objc-runtime.h>
#include <Foundation/NSObject.h>
,
#if LIB_FOUNDATION_VERSION
error
#endif
, ac_cv_foundation_extensions=yes, ac_cv_foundation_extensions=no)
AC_LANG_RESTORE[]
])dnl
if test ${ac_cv_foundation_extensions} = no; then
    AC_MSG_ERROR([
    Please specify the path to your Foundation extensions library using the
CFLAGS variable in the configure command line. If you don't have it installed
on your system, please compile it before trying to compile this package.])
else
    if test "$FOUNDATION_EXT_LIB" = ""; then
	FOUNDATION_EXT_LIB="-lFoundationExt"
    fi
    FND_LIBS="$FOUNDATION_EXT_LIB $FND_LIBS"
fi
AC_MSG_RESULT(${ac_cv_foundation_extensions})
])dnl
dnl
dnl
AC_DEFUN(AC_DETERMINE_RUNTIME,
[AC_REQUIRE([AC_PROG_CC])dnl
AC_REQUIRE([AC_C_CROSS])dnl
AC_MSG_CHECKING(for the Objective-C runtime)
AC_CACHE_VAL(ac_cv_objc_runtime,
[if test "$OBJC_RUNTIME" = ""; then
AC_LANG_SAVE[]dnl
AC_LANG_OBJECTIVE_C[]
AC_TRY_LINK([#include <objc/Object.h>],
[extern id objc_lookUpClass(char*);
id class = objc_lookUpClass("Object");
id obj = [class alloc];
puts([obj name]);
], ac_cv_objc_runtime=NeXT, ac_cv_objc_runtime=unknown)
if test $ac_cv_objc_runtime = unknown; then
  # Save the LIBS variable
  HOLD_LIBS=$LIBS
  LIBS="$FND_LIBS -lobjc $LIBS"
  AC_TRY_LINK([#include <objc/Object.h>],
  [extern id objc_lookup_class(char*);
  id class = objc_lookup_class("Object");
  id obj = [class alloc];
  puts([obj name]);
  ], ac_cv_objc_runtime=GNU, ac_cv_objc_runtime=unknown)
  # Restore the LIBS variable
  LIBS=$HOLD_LIBS
fi
AC_LANG_RESTORE[]
else
    ac_cv_objc_runtime=$OBJC_RUNTIME
fi
])dnl
if test "`echo ${ac_cv_objc_runtime} | tr a-z A-Z`" = "GNU"; then
    OBJC_RUNTIME=GNU
    OBJC_RUNTIME_FLAG=-fgnu-runtime
    ac_cv_objc_runtime=GNU
    LIBS="$FND_LIBS -lobjc $LIBS"
    AC_DEFINE(GNU_RUNTIME)
elif test "`echo ${ac_cv_objc_runtime} | tr a-z A-Z`" = "NEXT"; then
    OBJC_RUNTIME=NeXT
    OBJC_RUNTIME_FLAG=-fnext-runtime
    ac_cv_objc_runtime=NeXT
    AC_DEFINE(NeXT_RUNTIME)
else
    echo
    rm -f conftest* confdefs* core core.* *.core
    AC_MSG_ERROR([
    Cannot determine the Objective-C runtime! Probably you
have to specify some additional libraries needed to link an ObjC program,
so please take a look in the config,log file to see what was the reason
the test program has not been built and try again.])
fi
AC_MSG_RESULT(${ac_cv_objc_runtime})
])dnl
LIBS="$FND_LIBS $LIBS"
dnl
dnl
dnl Macros that check for different databases
dnl
dnl Sybase
dnl
AC_SUBST(SYBASE_DATABASE)dnl
AC_SUBST(SYBASE_CFLAGS)dnl
AC_SUBST(SYBASE_LDFLAGS)dnl
dnl
dnl
AC_DEFUN(AC_CHECK_SYBASE,
[AC_ARG_WITH(sybase, [
--with-sybase
    Build the Sybase SQL Server adaptor.
],
[if test $withval = yes; then
    SYBASE_DATABASE=yes
else
    SYBASE_DATABASE=no
fi
],
[SYBASE_DATABASE=no
])
AC_SUBST(SYBASE_DATABASE)
if test $SYBASE_DATABASE = yes; then
    AC_DEFINE(SYBASE_DATABASE)
    if test "$SYBASE_CFLAGS" = ""; then
	SYBASE_CFLAGS="-I/usr/sybase/include"
    fi
    if test "$SYBASE_LDFLAGS" = ""; then
	SYBASE_LDFLAGS="-L/usr/sybase/lib -lsybdb"
    fi
fi
])dnl
dnl
dnl Microsoft SQLServer
dnl
AC_SUBST(SQLSERVER_DATABASE)dnl
AC_SUBST(SQLSERVER_CFLAGS)dnl
AC_SUBST(SQLSERVER_LDFLAGS)dnl
dnl
dnl
AC_DEFUN(AC_CHECK_SQLSERVER,
[AC_ARG_WITH(sqlserver, [
--with-sqlserver
    Build the Microsoft SQL Server adaptor.
],
[if test $withval = yes; then
    SQLSERVER_DATABASE=yes
else
    SQLSERVER_DATABASE=no
fi
],
[SQLSERVER_DATABASE=no
])
AC_SUBST(SQLSERVER_DATABASE)
if test $SQLSERVER_DATABASE = yes; then
    AC_DEFINE(SQLSERVER_DATABASE)
    if test "$SQLSERVER_CFLAGS" = ""; then
	SQLSERVER_CFLAGS="-I/usr/sqlserver/include"
    fi
    if test "$SQLSERVER_LDFLAGS" = ""; then
	SQLSERVER_LDFLAGS="-L/usr/sqlserver/lib -lsybdb"
    fi
fi
])dnl
dnl
dnl
dnl Postgres95
dnl
AC_SUBST(POSTGRES95_DATABASE)dnl
AC_SUBST(POSTGRES95_CFLAGS)dnl
AC_SUBST(POSTGRES95_LDFLAGS)dnl
dnl
dnl
AC_DEFUN(AC_CHECK_POSTGRES95,
[AC_ARG_WITH(postgres95, [--with-postgres95
    Build the Postgres95 adaptor.
],
[if test $withval = yes; then
    POSTGRES95_DATABASE=yes
else
    POSTGRES95_DATABASE=no
fi
],
[POSTGRES95_DATABASE=no
])
AC_SUBST(POSTGRES95_DATABASE)
if test $POSTGRES95_DATABASE = yes; then
    AC_DEFINE(POSTGRES95_DATABASE)
    if test "$POSTGRES95_CFLAGS" = ""; then
	POSTGRES95_CFLAGS="-I/usr/local/postgres95/include"
    fi
    if test "$POSTGRES95_LDFLAGS" = ""; then
	POSTGRES95_LDFLAGS="-L/usr/local/postgres95/lib -lpq"
    fi
fi
])dnl
dnl
dnl
