// $Id: Cxx.cc,v 1.93 1998/10/09 13:45:04 cvs_christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "Cxx.hh"
#include <strstream>
#include "Configuration.hh"
//#include "File_type.hh"

Cxx::Cxx(Tag *tp) 
	:top(tp)
{}

void Cxx::CreateSupportFiles()
{  if (Configuration.has_radiogroups)
   {  File support_h(0,File_SUPPORT_HH);
      WriteHeader(support_h);
      File support_c(0,File_SUPPORT_CC); 
      WriteHeader(support_c);
      
      support_h << 
   "#include <string>\n"
   "#include <map>\n"
   "#include <glib.h>\n"
   "\n"
   "GSList *glademm_get_RadioGroup(const string &name);\n"
   "void glademm_set_RadioGroup(const string &name, GSList *val);\n";
   
      support_c <<
   "#include \"glademm_support.hh\"\n"
   "\n"
   "static map<const string,GSList *> glademm_radiogroups;\n"
   "\n"
   "GSList *glademm_get_RadioGroup(const string &name)\n"
   "{  map<const string,GSList *>::iterator i=glademm_radiogroups.find(name);\n"
   "   if (i==glademm_radiogroups.end()) return 0;\n"
   "   return (*i).second;\n"
   "}\n"
   "\n"
   "void glademm_set_RadioGroup(const string &name, GSList *val)\n"
   "{  glademm_radiogroups[name]=val;\n"
   "}\n";
     
     if (Configuration.no_autoconf)
     {  makefile << "\\\n\tglademm_support.o ";
     }
     else 
     {ostrstream o;
      
      makefile_am << "\\\n\t" << support_c.FileName();
      o << "\\\n\t" << support_h.FileName() << (char)0;
      o.flush();
      makefile_am.remember(o.str());
      o.freeze(0);
     }
      WriteFooter(support_h);
      support_h.close();
      WriteFooter(support_c);
      support_c.close();
   }
}

void Cxx::WriteTags()
{  if (Configuration.debug) top->debug();
   Tag::iterator i=top->begin(),ende=top->end();
   while (i!=ende && *i!="widget") 
   {  if ((*i).begin()==(*i).end())
      {  cerr<<"no <widget> found\n";
         return;
      }
      ende=(*i).end();
      i=(*i).begin();
   }
   if (!Configuration.bare_bones)
   {  main.open(0,File_MAIN_CC); WriteHeader(main);
      makefile.open(0,File_MAKEFILE); WriteHeader(makefile);
      if (!Configuration.no_autoconf)
      {  autogen.open(0,File_AUTOGEN_SH); WriteHeader(autogen);
         makefile_am.open(0,File_MAKEFILE_AM); WriteHeader(makefile_am);
         configure_in.open(0,File_CONFIGURE_IN); WriteHeader(configure_in);
      }
   }

   // 2do: perhaps do this to the parent tag
   for(;i!=ende && *i=="widget";++i) 
   {  Widget w(&*i);
      ApplyPreferences(w);
//      if (Configuration.debug) w.debug();
      WriteTree(w);
   }
   
   CreateSupportFiles();

   if (!Configuration.bare_bones)
   {  WriteFooter(configure_in); configure_in.close();
      WriteFooter(makefile); makefile.close();
      if (!Configuration.no_autoconf)
      {  WriteFooter(makefile_am); makefile_am.close();
         WriteFooter(autogen); autogen.close();
         WriteFooter(main); main.close();
      }
   }
}

void Cxx::ApplyPreferences(Widget &w)
{  if (Configuration.all_pointer) w.mark(CXX_POINTER);
   if (w.Class()=="GtkRadioButton") 
      Configuration.has_radiogroups=true;
   if (!Writer(w).IsBasic())
   {  if (!w.hasChildren()) 
         cerr << "Container " << w.Name() << " with no children\n";
      w.markCompound();
      for (Widget::iterator i=w.begin();i!=w.end();++i)
         ApplyPreferences((class Widget &)(const class Widget &)*i);
   }
}

void Cxx::WriteTree(const Widget &w)
{  gh.open(&w,File_FOO_GLADE_HH); WriteHeader(gh);
   gc.open(&w,File_FOO_GLADE_CC); WriteHeader(gc);
   if (!Configuration.bare_bones) 
   { h.open(&w,File_FOO_HH); WriteHeader(h);
     c.open(&w,File_FOO_CC); WriteHeader(c);
   
      char buf[1024]; 
      ostrstream o(buf,sizeof buf);
      
      main.include(h.FileName(),true);
      if (w.isPointer())
      {  o << "   " << h.TypeName(w.Name()) << " *" << h.InstanceName(w.Name())
           << " = new " << h.TypeName(w.Name()) << "();\n";
         o << "   // FIXME: delete this pointer after main.run()\n";
      }   
      else 
         o << "   " << h.TypeName(w.Name()) << " " << h.InstanceName(w.Name()) 
           << ";\n";
      o.flush();
      buf[o.tellp()]=0;
      main.remember(buf);

      if (!Configuration.no_autoconf)
      {  makefile_am << "\\\n\t" << gc.FileName() << " " << c.FileName();
         o.seekp(0,ios::beg);
         o << "\\\n\t" << h.FileName() << " " << gh.FileName();
         o.flush();
         buf[o.tellp()]=0;
         makefile_am.remember(buf);
      }
      else
      {  makefile << "\\\n\t" << gc.FileName(File_UNKNOWN,File_NODIR|File_OBJECT) 
      		  << " " << c.FileName(File_UNKNOWN,File_NODIR|File_OBJECT) << " ";
      }
   }
   
   
   {  int dummy=1;
      DefineRequirements(w,dummy);
      if (dummy!=1) 
      {  gh << "#  define " << gh.RequireName(w.Name()) << " " << dummy++ << "\n";
         gh << "#  define " << gh.RequireName("") << " " << dummy++ << "\n\n";
      }
   }
   if (!Configuration.bare_bones) 
   {  WriteHeader2(h);
      c.include(h.FileName(),true);
      gc.include(h.FileName(),true);
   }
   gc.include(gc.FileName(File_FOO_HH),true);
   
   PrintWidget(w);
   
   if (gh.hasRequirements())
   {  gh << "#  define "<<GLADEMM_REQUIRED<<" " << gh.RequireName("") << "\n";
      gh << "#  include \"" << gh.FileName(File_FOO_HH) << "\"\n";
      gh << "#  undef "<<GLADEMM_REQUIRED<<"\n";
      
      if (!Configuration.bare_bones)
      {  h << "#     if "<<GLADEMM_REQUIRED<<"=="<<gh.RequireName("") << "\n";
         h << "// put your own definitions/includes here\n";
         h << "#     endif /* "<< gh.RequireName("")<<" */\n";
      }
   }
   
   if (!Configuration.bare_bones)
   {  WriteFooter(c); c.close();
      WriteFooter(h); h.close();
   }
   WriteFooter(gc); gc.close();
   WriteFooter(gh); gh.close();
}

void Cxx::Declare_GH(const Widget &w)
{  if (!w.isCompound()) Writer(w).DeclareNeeded(gh);
   gh << "\t";
   Writer(w).Declare(gh);
   gh << "\n";
}

void Cxx::Construct_GC(const Widget &w,bool is_member,bool *first)
{  Writer wr2(w);
   if (wr2.NeedConstruct(is_member))
   {  if (!*first) gc << ", ";
      wr2.Construct(gc,is_member);
      *first=false;
   }
}

void Cxx::PrintWidget(const Widget &w)
{  Writer wr(w);

   // resolve children
   TestSubwidgetsAndDo(wr,w,&PrintWidget);
   
   // ********************** foo_glade.hh ******************************
   // resolve requirements
   wr.Include(gh);
   
   if (!wr.IsCompound()) return; // seems to be more correct
   bool has_pointer=TestSubwidgetsForPointer(wr,w);
   
   // 2do: resolve file requirements
   
   gh << "class " << gh.TypeName(w.Name(),true);
   if (wr.IsDerived())
   {  gh << " : public ";
      wr.Derive(gh);
   }
   gh << "\n";
   gh << "{ protected:\n";
   wr.DeclareNeeded(gh);
   TestSubwidgetsAndDo(wr,w,&Declare_GH);
   gh << "public:\n";
   gh << "\t" << gh.TypeName(w.Name(),true) << "();\n";
   if (has_pointer)
      gh << "\t~" << gh.TypeName(w.Name(),true) << "();\n";
   gh << "};\n\n";
   if (gh.hasRequirements() && w.isCompound())
   {  gh << "#  define "<<GLADEMM_REQUIRED<<" " << gh.RequireName(w.Name()) << "\n";
      gh << "#  include \"" << gh.FileName(File_FOO_HH) << "\"\n";
      gh << "#  undef "<<GLADEMM_REQUIRED<<"\n\n";
   }
   
  if (!Configuration.bare_bones)
  {// ********************** foo.hh *************************************
   if (gh.hasRequirements())
      h << "#     if "<<GLADEMM_REQUIRED<<"=="<<gh.RequireName(w.Name()) << "\n";
   h << "class " << gh.TypeName(w.Name(),false) << " : public "
     << gh.TypeName(w.Name(),true) << "\n";
   h << "{\n";
   if (Configuration.sample_code)
   {  TestSubwidgetsAndDo(wr,w,&SampleCodePrivate_H);
      wr.SampleCode(h,WriterType::PrivateMember,"");
   }
   TestSubwidgetsAndDo(wr,w,&DeclareSignalHandler_Hsub);
   DeclareSignalHandler_H(w);
   h << "public:\n"
   	"\t" << gh.TypeName(w.Name(),false) << "();\n";
   if (Configuration.sample_code)
   {  h << "\t~" << gh.TypeName(w.Name(),false) << "();\n";
      TestSubwidgetsAndDo(wr,w,&SampleCodePublic_H);
      wr.SampleCode(h,WriterType::PublicMember,"");
   }
   h << "};\n";
   if (gh.hasRequirements())
      h << "#     endif /* "<< gh.RequireName(w.Name())<<" */\n";
   h << "\n";
  }
  
   // ********************** foo_glade.cc ******************************
   gc << gh.TypeName(w.Name(),true) << "::" <<gh.TypeName(w.Name(),true)
   	<< "()\n";
   {  bool we_need_ctor=wr.NeedConstruct(false);
      bool child_needs_ctor=TestSubwidgetsForCtor(wr,w,true);
      
      if (we_need_ctor || child_needs_ctor)
      {  gc << "\t: ";
         
         bool first=true;
         if (we_need_ctor) Construct_GC(w,false,&first);
         if (child_needs_ctor) 
            TestSubwidgetsAndDo(wr,w,&Construct_GC,true,&first);
         gc << "\n";
      }
   }
   gc << "{\n";
   if (has_pointer) TestSubwidgetsAndDo(wr,w,&InitPointer_GC);
   gc << "\t";
   TestSubwidgetsAndDo(wr,w,&CustomizeSub_GC);
   wr.Customize(gc,"",false);
   gc << "\n}\n";
   
   // ------- destructor -----------------
   if (has_pointer)
   {  gc << gh.TypeName(w.Name(),true) << "::~" <<gh.TypeName(w.Name(),true)
         << "()\n";
      gc << "{";
      TestSubwidgetsAndDo(wr,w,&DestroyPointer_GC);
      gc << "}\n";
   }
   gc << "\n";

  if (!Configuration.bare_bones)
  {// ********************** foo.cc *************************************
   c << gh.TypeName(w.Name(),false) << "::" << gh.TypeName(w.Name(),false)
     << "()";
   if (Configuration.sample_code)
   {  SampleCodeMembCtion_C(w,true);
      TestSubwidgetsAndDo(wr,w,&SampleCodeMembCtion_Csub);
   }
   c << "\n{\n";
   TestSubwidgetsAndDo(wr,w,&ConnectSignal_Csub);
   ConnectSignal_C(w);
   if (Configuration.sample_code)
   {  TestSubwidgetsAndDo(wr,w,&SampleCodeCtor_C);
      wr.SampleCode(c,WriterType::Constructor,"");
   }
   c << "}\n\n";

   if (Configuration.sample_code)
   {  c << gh.TypeName(w.Name(),false) << "::~" << gh.TypeName(w.Name(),false)
        << "()\n"
        << "{\n";
      TestSubwidgetsAndDo(wr,w,&SampleCodeDtor_C);
      wr.SampleCode(c,WriterType::Destructor,"");
      c << "}\n\n";
   }

   TestSubwidgetsAndDo(wr,w,&DefineSignalHandler_C,gh.TypeName(w.Name(),false));
   DefineSignalHandler_C(w,gh.TypeName(w.Name(),false));
   if (Configuration.sample_code)
   {  TestSubwidgetsAndDo(wr,w,&SampleCodeDefinition_C,gh.TypeName(w.Name(),false));
      wr.SampleCode(c,WriterType::Definition,gh.TypeName(w.Name(),false));
   }
  }
}

void Cxx::InitPointer_GC(const Widget &w)
{  if (!w.isPointer()) return;
   Writer(w).ConstructPointer(gc);
}

void Cxx::DestroyPointer_GC(const Widget &w)
{  if (!w.isPointer()) return;
   Writer(w).DestructPointer(gc);
}

void Cxx::CustomizeSub_GC(const Widget &w)
{  string instance(gc.InstanceName((w).Name()));
   instance+=w.isPointer()?"->":".";
   Writer(w).Customize(gc,instance,true);
   // 2do: perhaps recurse (on variable nesting depths) ...
} 

// this should go to Cxx_TestSubw.cc (and act like that)
void Cxx::DefineRequirements(const Widget &w,int &value)
{  for (Widget::const_iterator i=w.begin();i!=w.end();i++)
   {  // FIXME: should check for compound!
      if ((*i).begin()!=(*i).end() && !((*i).isCompound()))
      {  cerr << "!Container " << (*i).Name() << " with children\n"
                 "Requirements omitted (untested)\n";
//         DefineRequirements(*i,value);
      }
      if ((*i).isCompound()) 
      {  DefineRequirements(*i,value);
         gh.markRequirements();
         h.markRequirements();
         gh << "#  define " << gh.RequireName((*i).Name()) << " " << value << "\n";
         value++;
      }
   }
}

void Cxx::WriteHeader(File &f)
{  switch(f.type())
   {  case File_FOO_HH:
         WriteCreation(f);
   	 f << "//\n// newer (non customized) versions of this file go to ";
   	 f << FileName(f.widgetName(),f.type(),File_GLADE|File_NODIR) << "\n";
   	 f << "\n"
   	          "// you might replace\n"
   	          "//    class "<< f.TypeName("foo",false) << " : public ";
   	 f << f.TypeName("foo",true) << " { ... };\n";
   	 f << "// by\n"
   	          "//    typedef "<<f.TypeName("foo",true)<< " "
   	       << f.TypeName("foo",false) << ";\n";
   	 f << "// if you didn't make any modifications to the widget\n";
   	 f << "\n";
   	 // we don't know about requirements yet, see WriteHeader2()
   	 break;
      case File_FOO_GLADE_HH:
         WriteCreation(f);
      	 f << "//\n// DO NOT EDIT THIS FILE !\n";
      	 f << "// Please modify the corresponding derived classes in ";
      	 f << FileName(f.widgetName(),File_FOO_HH) << " and"
      	   << FileName(f.widgetName(),File_FOO_CC) << "\n";
      	 f << "\n#ifndef "<<FileDefine(f.widgetName(),f.type())<<"\n";
      	 f << "#  define "<<FileDefine(f.widgetName(),f.type())<<"\n\n";
      	 break;
      case File_FOO_GLADE_CC:
         WriteCreation(f);
      	 f << "//\n// DO NOT EDIT THIS FILE !\n";
      	 f << "// Please modify the corresponding derived classes in ";
      	 f << FileName(f.widgetName(),File_FOO_CC) << "\n\n";
         break;
      case File_SUPPORT_CC:
      case File_SUPPORT_HH:
         WriteCreation(f);
      	 f << "//\n"
	      "// some glademm convenience functions\n"
	      "//\n"
	      "// DO NOT EDIT THIS FILE !\n\n";
         break;
      case File_FOO_CC:
         WriteCreation(f);
   	 f << "//\n// newer (non customized) versions of this file go to ";
   	 f << FileName(f.widgetName(),f.type(),File_GLADE|File_NODIR) << "\n";
   	 f << "\n";
   	 f << "// This file is for your program, I won't touch it again!\n\n";
      	 if (Configuration.sample_code)
      	 {  f.include("iostream",false);
      	    f << "\n";
      	 }
   	 break;
      case File_MAIN_CC:
         WriteCreation(f);
   	 f << "//\n// newer (non customized) versions of this file go to ";
   	 f << FileName(f.widgetName(),f.type(),File_GLADE|File_NODIR) << "\n";
   	 f << "\n";
   	 f << "// This file is for your program, I won't touch it again!\n\n";
   	 f.include("gtk--/main.h");
   	 f << "\n";
   	 break;
      case File_MAKEFILE:
         WriteCreation(f);
   	 f << "#\n# newer (non customized) versions of this file go to ";
   	 f << FileName(f.widgetName(),f.type(),File_GLADE|File_NODIR) << "\n";
   	 if (Configuration.no_autoconf)
   	 {  f << "\n"
                 "CXXFLAGS=$(CFLAGS) `gtkmm-config --cflags`\n"
                 "LIBS=`echo $$LIBS` `gtkmm-config --libs`\n"
                 "\n"
                 "# calculate dependancies\n"
                 "\n"
                 "all: dep_all\n"
                 "\n"
                 "ifeq (.depend,$(wildcard .depend))\n"
                 "include .depend\n"
                 "dep_all: " << Configuration.main_filename << "\n"
                 "else\n"
                 "dep_all: .depend\n"
                 "\tmake all\n"
                 "endif\n"
                 "\n"
                 ".depend depend dep:\n"
                 "\tfor i in *.cc ; do $(CXX) $(CXXFLAGS) -M $$i; done > .depend\n"
                 "\n" << Configuration.main_filename << ": ";
   	 }
   	 else
   	 {  f << "# this file will overwrite itself !\n"
   	 	 "\n"
   	 	 "all:\n"
   	 	 "\t./autogen.sh\n";
   	 }
         break;
      case File_MAKEFILE_AM:
         WriteCreation(f);
   	 f << "#\n# newer (non customized) versions of this file go to ";
   	 f << FileName(f.widgetName(),f.type(),File_GLADE|File_NODIR) << "\n";
   	 f << "bin_PROGRAMS = "<< Configuration.main_filename << "\n\n";
         f << AMName(Configuration.main_filename) << "_SOURCES = \\\n";
         f << "\t" << FileName("",File_MAIN_CC,File_NODIR);
         {  char buf[1024]; 
            ostrstream o(buf,sizeof buf);
            
   	    o << "noinst_HEADERS = ";
            o.flush();
            buf[o.tellp()]=0;
            f.remember(buf);
         }
         break;
      case File_CONFIGURE_IN:
         WriteCreation(f);
   	 f << "#\n# newer (non customized) versions of this file go to ";
   	 f << FileName(f.widgetName(),f.type(),File_GLADE|File_NODIR) << "\n";
   	 f <<	"\n"
		"AC_INIT("<< Configuration.main_filename <<".cc)\n"
		"\n"
		"AM_INIT_AUTOMAKE("<< Configuration.main_filename <<", 0.0)\n"
		"\n"
		"AC_PROG_CC\n"
		"\n"
		"AM_PATH_GTK(1.0.0,\n"
		"	[AC_SUBST(GTK_LIBS)\n"
		"	 AC_SUBST(GTK_CFLAGS)],\n"
		"        AC_MSG_ERROR(Cannot find GTK: Is gtk-config in path?))\n"
		"\n"
		"AC_PROG_CXX\n"
		"\n"
		"AC_LANG_CPLUSPLUS\n"
		"\n"
		"AM_PATH_GTKMM(0.9.5,,\n"
		"        AC_MSG_ERROR(Cannot find GTK--: Please install Version 0.9.7+))\n"
		"\n"
		"AC_OUTPUT(Makefile)\n";
         break;
      case File_AUTOGEN_SH:
      	 f << "#!/bin/sh\n";
         WriteCreation(f);
   	 f << "#\n# newer (non customized) versions of this file go to ";
   	 f << FileName(f.widgetName(),f.type(),File_GLADE|File_NODIR) << "\n";
   	 f << 	"\n"
   	        "if test ! -f install-sh ; then touch install-sh ; fi\n"
   	        "\n"
		"MAKE=`which gnumake`\n"
		"if test ! -x \"$MAKE\" ; then MAKE=`which gmake` ; fi\n"
		"if test ! -x \"$MAKE\" ; then MAKE=`which make` ; fi\n"
		"HAVE_GNU_MAKE=`$MAKE --version|grep -c \"Free Software Foundation\"`\n"
		"\n"
		"if test \"$HAVE_GNU_MAKE\" != \"1\"; then \n"
		"echo !!!! Warning: not tested with non Gnu-Make $MAKE\n"
		"else\n"
		"echo Found GNU Make at $MAKE ... good.\n"
		"fi\n"
		"\n"
		"echo This script runs configure and make...\n"
		"echo You did remember necessary arguments for configure, right?\n"
		"\n"
		"if test ! -x `which aclocal`  \n"
		"then echo you need autoconfig and automake to generate the Makefile\n"
		"fi\n"
		"if test ! -x `which automake`  \n"
		"then echo you need automake to generate the Makefile\n"
		"fi\n"
		"aclocal\n"
		"automake\n"
		"autoconf\n"
		"./configure $*\n"
		"$MAKE\n";
         break;
      default:
      case File_UNKNOWN:
         f << "<unknown file type>\n";
         break;
   }	
}

void Cxx::WriteHeader2(File &f) 
// now we know about requirements;
{  switch(f.type())
   {  case File_FOO_HH:
   	 f << "#ifndef "<<FileDefine(f.widgetName(),f.type())<<"\n";
   	 if (f.hasRequirements())
   	 {  f << "#  ifndef "<<FileDefine(f.widgetName(),File_FOO_GLADE_HH)<<"\n";
   	    f << "#    include \"" << FileName(f.widgetName(),File_FOO_GLADE_HH,File_NODIR)<<"\"\n";
   	    f << "     // Since there are class-interdependancies " <<
   	    	FileName(f.widgetName(),File_FOO_GLADE_HH,File_NODIR) <<
   	    	 "\n     // will include this file class by class.\n"
   	    	 "     // So we simply exit here.\n";
   	    f << "#    define "<<FileDefine(f.widgetName(),f.type())<<"\n";
   	    f << "#  else\n\n";
   	 }
   	 else
   	 {  f << "#  include \"" << FileName(f.widgetName(),File_FOO_GLADE_HH,File_NODIR)<<"\"\n";
   	    f << "#  define "<<FileDefine(f.widgetName(),f.type())<<"\n";
   	 }
   	 break;
      default:
         break;
   }	
}

void Cxx::WriteFooter(File &f)
{  switch(f.type())
   {  case File_FOO_HH:
   	 if (f.hasRequirements()) f << "#  endif\n";
   	 f << "#endif\n";
   	 break;
      case File_FOO_GLADE_HH:
   	 f << "#endif\n";
   	 break;
      case File_MAIN_CC:
         f << "\n"
              "int main(int argc, char **argv)\n"
              "{  Gtk_Main m(&argc, &argv);\n"
              "\n";
      	 f.write_remembered();
      	 f << "\n"
      	      "   m.run();\n"
      	      "   return 0;\n"
      	      "}\n";
         break;
      case File_MAKEFILE_AM:
         f << "\n\n";
      	 f.write_remembered();
      	 f << "\n\n";
      	 f << "CXXFLAGS = $(GTK_CFLAGS) $(GTKMM_CFLAGS)\n\n";
      	 f << AMName(Configuration.main_filename) << "_LDADD = $(GTKMM_LIBS) $(GTK_LIBS)\n";
         break;
      case File_MAKEFILE:
         if (Configuration.no_autoconf)
            f << "\n\t$(CXX) $(LFLAGS) -o " << Configuration.main_filename << " $^ $(LIBS)\n"
	         "\n"
	         "clean:\n"
	         "\trm -f .depend " << Configuration.main_filename << " *.o *~\n";
	 break;
      default:
         break;
   }
}

/* <Signal>
     <name>clicked</name>
     <handler>on_okbutton_clicked</handler>
   </Signal> */                                           
void Cxx::ConnectSignal_C(const Widget &w,const string instance)
{  for (Widget::const_iterator i=w.get_Signals();i!=w.end();++i)
   {  const string signal=(*i).getString("name","");
      const string handlername=(*i).getString("handler","unknown");
      c << "   connect_to_method(" << instance
        << c.CName(signal) << ", this, &" << c.CName(handlername)
        << ");\n";
   }
}

void Cxx::ConnectSignal_Csub(const Widget &w)
{  string instance=c.InstanceName(w.Name());
   instance+=w.isPointer()?"->":".";
   ConnectSignal_C(w,instance);
}

void Cxx::DefineSignalHandler_C(const Widget &w,const string name_space)
{  if (w.isCompound() && name_space!=gh.TypeName(w.Name(),false)) 
      return; // don't output signals as part of containing widget
   for (Widget::const_iterator i=w.get_Signals();i!=w.end();++i)
   {  const string signal=(*i).getString("name","");
      const string handlername=(*i).getString("handler","unknown");
      string rettype;
      const string args=Writer(w).CallbackArgs(signal,rettype);
      c << rettype << " " << name_space
      		<< "::" << c.CName(handlername) << "(" << args << ")\n";
      c << "{\n";
      if (Configuration.sample_code) 
         c << "\tcout << \"" << name_space
         	<< "::" << c.CName(handlername) << " called\\n\";\n";
      if (rettype!="void") 
         c << "\treturn 0;\n";
      c << "}\n\n";
   }
}

void Cxx::DeclareSignalHandler_H(const Widget &w)
{  for (Widget::const_iterator i=w.get_Signals();i!=w.end();++i)
   {  const string signal=(*i).getString("name","");
      const string handlername=(*i).getString("handler","unknown");
      string rettype;
      const string args=Writer(w).CallbackArgs(signal,rettype);
      h << "\t" << rettype << " " << c.CName(handlername) << "(" << args << ");\n";
   }
}

void Cxx::DeclareSignalHandler_Hsub(const Widget &w)
{  if (w.isCompound()) 
      return; // don't output signals as part of containing widget
   DeclareSignalHandler_H(w);
}

void Cxx::SampleCodeDefinition_C(const Widget &w,const string name_space)
{  Writer(w).SampleCode(c,WriterType::ContainingDefinition,name_space);
}

void Cxx::SampleCodeMembCtion_Csub(const Widget &w)
{  SampleCodeMembCtion_C(w);
}

void Cxx::SampleCodeMembCtion_C(const Widget &w,bool init)
{  static string separator(" ERROR ");
   if (init) 
   {  separator=" : ";
      if (Writer(w).SampleCode(c,WriterType::MemberConstruction,separator))
         separator=", ";
   }
   else 
      if (Writer(w).SampleCode(c,WriterType::ContainingMemberConstruction,
      								separator))
         separator=", ";
}

void Cxx::SampleCodeCtor_C(const Widget &w)
{  Writer(w).SampleCode(c,WriterType::ContainingConstructor,"");
}

void Cxx::SampleCodeDtor_C(const Widget &w)
{  Writer(w).SampleCode(c,WriterType::ContainingDestructor,"");
}

void Cxx::SampleCodePrivate_H(const Widget &w)
{  Writer(w).SampleCode(h,WriterType::ContainingPrivateMember,"");
}

void Cxx::SampleCodePublic_H(const Widget &w)
{  Writer(w).SampleCode(h,WriterType::ContainingPublicMember,"");
}

#include <time.h>
#include <pwd.h>
#define _GNU_SOURCE // needed for debian & glibc2 ???
#define __USE_GNU // needed for redhat
#include <sys/utsname.h>
#include <unistd.h>

#define GLADEMM_NAME PACKAGE " V" VERSION

void Cxx::WriteCreation(File &f)
{  time_t t=time(0);
   struct tm *tm=localtime(&t);
   const char *comment=(f.type()>=File_NUM_CXX_FILES)?"#":"//";
   f << comment << " generated ";
   f << tm->tm_year+1900 << "/" << tm->tm_mon+1 << "/" << tm->tm_mday;
   f << " "<< tm->tm_hour << ":";
   char oldfill=f.fill('0');
   int oldwidth=f.width(2);
   f << tm->tm_min << ":" << tm->tm_sec << " " << tzname[tm->tm_isdst];
   f.fill(oldfill); f.width(oldwidth);
   struct passwd *pwd=getpwuid(getuid());
   struct utsname uts;
   if (uname(&uts)) 
   {  strcpy(uts.nodename,"(unknown)"); 
      strcpy(uts.domainname,"(unknown)");
   }
   f << " by " << (pwd?pwd->pw_name:"(unknown)") << "@"
     << uts.nodename << "." << uts.domainname << "\n";
   f << comment << " using "GLADEMM_NAME"\n";
}

