
/*  Gtk+ User Interface Builder
 *  Copyright (C) 1998  Damon Chaplin
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <gtk/gtk.h>
#include "../gb.h"
#include "../glade_menu_editor.h"

/* Include the 21x21 icon pixmap for this widget, to be used in the palette */
#include "../graphics/menubar.xpm"

/*
 * This is the GbWidget struct for this widget (see ../gbwidget.h).
 * It is initialized in the init() function at the end of this file
 */
static GbWidget gbwidget;

static void gb_menu_bar_on_edit_menu (GtkWidget *button,
				      gpointer data);
static void gb_menu_bar_on_edit_menu_activate (GtkWidget *menuitem,
					       GtkWidget *menubar);
static void gb_menu_bar_edit_menu (GtkWidget *menubar);
static void gb_menu_bar_on_editor_ok (GtkWidget *button,
				      GtkWidget *menubar);
static void gb_menu_bar_on_editor_apply (GtkWidget *button,
					 GtkWidget *menubar);


/******
 * NOTE: To use these functions you need to uncomment them AND add a pointer
 * to the function in the GbWidget struct at the end of this file.
 ******/

/*
 * Creates a new GtkWidget of class GtkMenuBar, performing any specialized
 * initialization needed for the widget to work correctly in this environment.
 * If a dialog box is used to initialize the widget, return NULL from this
 * function, and call data->callback with your new widget when it is done.
 * If the widget needs a special destroy handler, add a signal here.
 */
/*
   GtkWidget*
   gb_menu_bar_new(GbWidgetNewData *data)
   {

   }
 */



/*
 * Creates the components needed to edit the extra properties of this widget.
 */
static void
gb_menu_bar_create_properties(GtkWidget *widget, GbWidgetCreateArgData *data)
{
  GtkWidget *property_table, *button;
  gint property_table_row;

  /* Add a button for editing the menubar. */
  property_table = property_get_table_position (&property_table_row);
  button = gtk_button_new_with_label (_("Edit Menus..."));
  gtk_widget_show (button);
  gtk_signal_connect (GTK_OBJECT (button), "clicked",
		      GTK_SIGNAL_FUNC (gb_menu_bar_on_edit_menu), NULL);
  gtk_table_attach (GTK_TABLE (property_table), button, 0, 3,
		    property_table_row, property_table_row + 1,
		    GTK_FILL, GTK_FILL, 10, 10);
}


static void
gb_menu_bar_on_edit_menu (GtkWidget *button,
			  gpointer data)
{
  GtkWidget *menubar;
  menubar = property_get_widget ();
  g_return_if_fail (GTK_IS_MENU_BAR (menubar));
  gb_menu_bar_edit_menu (menubar);
}

static void
gb_menu_bar_edit_menu (GtkWidget *menubar)
{
  GladeMenuEditor *menued;

  menued = GLADE_MENU_EDITOR (glade_menu_editor_new ());
  project_add_window (GTK_WIDGET (menued));
  glade_menu_editor_set_menu (menued, GTK_MENU_SHELL (menubar));
  gtk_signal_connect (GTK_OBJECT (menued->ok_button), "clicked",
		      GTK_SIGNAL_FUNC (gb_menu_bar_on_editor_ok),
		      menubar);
  gtk_signal_connect (GTK_OBJECT (menued->apply_button), "clicked",
		      GTK_SIGNAL_FUNC (gb_menu_bar_on_editor_apply),
		      menubar);
  gtk_signal_connect_object (GTK_OBJECT (menued->cancel_button), "clicked",
			     GTK_SIGNAL_FUNC (gtk_widget_destroy),
			     GTK_OBJECT (menued));
  gtk_widget_show (GTK_WIDGET (menued));
}

static void
gb_menu_bar_on_editor_ok (GtkWidget *button,
			  GtkWidget *menubar)
{
  GladeMenuEditor *menued;

  menued = GLADE_MENU_EDITOR (gtk_widget_get_toplevel (button));
  glade_menu_editor_update_menu (menued, GTK_MENU_SHELL (menubar));
  project_remove_window (GTK_WIDGET (menued));
  gtk_widget_destroy (GTK_WIDGET (menued));
}

static void
gb_menu_bar_on_editor_apply (GtkWidget *button,
			     GtkWidget *menubar)
{
  GladeMenuEditor *menued;

  menued = GLADE_MENU_EDITOR (gtk_widget_get_toplevel (button));
  glade_menu_editor_update_menu (menued, GTK_MENU_SHELL (menubar));
}

/*
 * Gets the properties of the widget. This is used for both displaying the
 * properties in the property editor, and also for saving the properties.
 */
/*
   static void
   gb_menu_bar_get_properties(GtkWidget *widget, GbWidgetGetArgData *data)
   {

   }
 */



/*
 * Sets the properties of the widget. This is used for both applying the
 * properties changed in the property editor, and also for loading.
 */
/*
   static void
   gb_menu_bar_set_properties(GtkWidget *widget, GbWidgetSetArgData *data)
   {

   }
 */



/*
 * Adds menu items to a context menu which is just about to appear!
 * Add commands to aid in editing a GtkMenuBar, with signals pointing to
 * other functions in this file.
 */
static void
gb_menu_bar_create_popup_menu(GtkWidget *widget, GbWidgetCreateMenuData *data)
{
  GtkWidget *menuitem;

  menuitem = gtk_menu_item_new_with_label (_("Edit Menu"));
  gtk_widget_show (menuitem);
  gtk_menu_append (GTK_MENU (data->menu), menuitem);
  gtk_signal_connect (GTK_OBJECT (menuitem), "activate",
		      GTK_SIGNAL_FUNC (gb_menu_bar_on_edit_menu_activate),
		      widget);
}


static void
gb_menu_bar_on_edit_menu_activate (GtkWidget *menuitem,
				   GtkWidget *menubar)
{
  gb_menu_bar_edit_menu (menubar);
}


/*
 * Writes the source code needed to create this widget.
 * You have to output everything necessary to create the widget here, though
 * there are some convenience functions to help.
 */
static void
gb_menu_bar_write_source (GtkWidget * widget, GbWidgetWriteSourceData * data)
{
  if (data->create_widget)
    {
      source_add (data, "  %s = gtk_menu_bar_new ();\n", data->wname);
    }

  gb_widget_write_standard_source (widget, data);
}



/*
 * Initializes the GbWidget structure.
 * I've placed this at the end of the file so we don't have to include
 * declarations of all the functions.
 */
GbWidget *
gb_menu_bar_init ()
{
  /* Initialise the GTK type */
  gtk_menu_bar_get_type ();

  /* Initialize the GbWidget structure */
  gb_widget_init_struct (&gbwidget);

  /* Fill in the pixmap struct & tooltip */
  gbwidget.pixmap_struct = menubar_xpm;
  gbwidget.tooltip = _("Menu Bar");

  /* Fill in any functions that this GbWidget has */
   gbwidget.gb_widget_create_properties = gb_menu_bar_create_properties;
   gbwidget.gb_widget_create_popup_menu = gb_menu_bar_create_popup_menu;
/*
   gbwidget.gb_widget_new               = gb_menu_bar_new;
   gbwidget.gb_widget_get_properties    = gb_menu_bar_get_properties;
   gbwidget.gb_widget_set_properties    = gb_menu_bar_set_properties;
 */
  gbwidget.gb_widget_write_source = gb_menu_bar_write_source;

  return &gbwidget;
}
