{
Copyright (C) 1998-99 Free Software Foundation, Inc.

Author: Frank Heckenbach <frank@pascal.gnu.de>

BP compatible printer unit

This library is free software; you can redistribute it and/or modify
it under the terms of the GNU Library General Public License as published by
the Free Software Foundation, version 2.

This library is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
License for more details.

You should have received a copy of the GNU Library General Public License
along with this library; see the file COPYING.LIB.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
MA 02111-1307, USA.
}

{$if __GPC_RELEASE__ < 19981206}
{$error This unit requires GPC release 19981206 or newer}
{$endif}

unit Printer;

interface

{$ifdef __OS_DOS__}

uses GPC;

{ Dos-like systems: writing to a printer device }

var
  { The file name to write printer output into }
  PrinterDeviceName : ^String = @'lpt1';

{$else}

{ Unix-like systems: printing via a printer program }

uses GPC, Pipe;

const
  EPrinterRead = 610; { printer can only be opened for writing }

var
  { The file name of the printer program. If it contains a '/', it will be
    taken as a complete path, otherwise the flie name will be searched in
    PathEnvVar. }
  PrinterCommand : ^String = @'lpr';

  { Optional command line Parameters for the printer program. Ignored when nil. }
  PrinterArguments : ^TPStrings = nil;

{$endif}

{ Text file opened to default printer }
var
  Lst : Text;

{ Assign a file to the printer. Lst will be assigned to the default
  printer at program start, but other files can be assigned to other
  printers, after changing the variables above. }
procedure AssignPrinter (var f : AnyFile);

implementation

{$I-}

{$ifdef __OS_DOS__}

procedure AssignPrinter (var f : AnyFile);
begin
  Assign (f, PrinterDeviceName^)
end;

{$else}

procedure OpenPrinter (var PrivateData; Mode : TOpenMode);
begin
  if not (Mode in [foRewrite, foAppend]) then IOError (EPrinterRead)
end;

{ Be very lazy: don't open the pipe until data are written to it -- not
  as soon as the file is opened because that happens already in the
  initialization of this unit (BP compatibility) }
function WritePrinter (var PrivateData; const Buffer; Size : SizeType) : SizeType;
var
  f : AnyFile absolute PrivateData;
  CharBuf : array [1 .. Size] of Char absolute Buffer;
begin
  WritePrinter := 0;
  Pipe (f, null, null, PrinterCommand^, PrinterArguments^, Environment); { this also makes sure this function won't be called again for this file }
  Write (f, CharBuf);
  if InOutRes = 0 then WritePrinter := Size
end;

procedure AssignPrinter (var f : AnyFile);
begin
  AssignTFDD (f, OpenPrinter, (*@@fjf258*)TReadFunc(nil), WritePrinter, TFlushProc(nil),TCloseProc(nil),TDoneProc(nil), @f)
end;

{$endif}

to begin do
begin
  AssignPrinter (Lst);
  if IOResult = 0 then Rewrite (Lst)
end;

to end do
  Close (Lst);

end.
