/*************************************************************************

                                  karpski.h
                               Brian Costello

               Defines, structure/typedefs and then prototypes

***************************************************************************/

#ifndef KARPSKI_H_PROCESSED
#define KARPSKI_H_PROCESSED
/*

****************************************

DEFINES

****************************************

*/

#undef LOCAL_DOMAIN
#define LOCAL_DOMAIN ".we.mediaone.net"		/* @@ */

#undef SCAN_SOUND_BROKEN			/* Define ONLY on linux with 
						 * a working /dev/audio!!!!! */
#ifdef SCAN_SOUND_BROKEN
#define SCAN_SOUND_INTERVAL 60			/* Once a minute */
#else
#undef SCAN_SOUND_INTERVAL
#endif

#define MAX_PACKET_COUNT	40
#define UPDATE_BR_FREQ		6	/* Update bytes read every 1/n times */
#define UPDATE_PROTO_FREQ	60	/* Once every 60 seconds about */
#define SAVE_WARNING		1	/* Warn if you need to save is 1, 0=off */
#define KEEP_SORTED		0	/* Define if you want to keep your columns sorted */
#define DRAW_INTERVAL		1000	/* # of ms to wait before updating the screen */
#define POST_NSLOOKUP_SLEEP	10000

/* No more user def vars left */

#define NUM_MAIN_CLIST_COLS 6
#undef MALLOC_TRACE

#ifdef MALLOC_TRACE
 #define MALLOC(a, b) malloc_new(a, b)
 #define STRDUP(a, b) strdup_new(a, b)
 #define FREE(a, b) free_new(a, b)
#else
 #define MALLOC(a, b) malloc(a)
 #define STRDUP(a, b) strdup(a)
 #define FREE(a, b) free(a)
#endif

/*

****************************************

TYPEDEFS

****************************************

*/

/* One arp record */

typedef struct s_arp_rec
{
   char hw_addr[23];			/* MAC address */
   char machine_addr[16];		/* IP or other address */
   char machine_name[64];		/* DNS resolution */
   char vend_str[64];			/* The NIC's vendor */
   char role[64];			/* Possible role (router, printer) */
   char alias[64];			/* Other name for this station */
   char methodstr[30];			/* The acquisition method */
   struct sockaddr_in sin;		/* The internet address of this record */
   int nconns;				/* The number of connections */
   int ndgrams;				/* Num datagrams */
   long nbytes;				/* Total number of bytes read / written */
   int row;				/* The row number that it is on */
   u_char watching;
   int num_diff_addrs;			/* For use in router detection */
   int needs_update;			/* Does this record need to be redisplayed? 
   					 * 1=new record, 2=data changed	*/
   t_connect_rec *first_connect;
   GtkWidget *watchwindow;
   GtkWidget *watchtextbox;
   struct s_arp_rec *next;
} t_arp_rec;


typedef struct s_karpski_stats
{
   int nhosts;
   int nwarnings;
   int nconnections;
   int ndatagrams;
   int nseconds;
   int noverflows;
   long nbytesread;
} t_karpski_stats;

/*

****************************************

PROTOTYPES

****************************************

*/

void printpkt(GtkWidget **text, packet_parse *, char *);
char *print_addr(char *, int, char);
void switch_watch();
void start_capturing(GtkWidget *);
void stop_capturing(GtkWidget *);
void karpski_quit();
void mutex_enter(pthread_mutex_t);
void mutex_exit(pthread_mutex_t);
int get_ar_rowno(t_arp_rec *, GtkCList *);
t_arp_rec *find_arp_rec(char *, char *, t_arp_rec **, int *, int *);
void print_this_ar(t_arp_rec *, int);
void dump_protolist(GtkWidget *, int fd, int screen);
#ifdef MALLOC_TRACE
 void *malloc_new(long, char *);
 void free_new(void *, char *);
 char *strdup_new(char *, char *);
#endif
#endif
