#include <config.h>

/*
 *   gtop - gnome system monitor
 *   Copyright (C) 1997,98 Radek Doulk
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "procview.h"
#include "memusage.h"
#include "fsusage.h"
#include "sysview.h"
#include "properties.h"
#include "session.h"

#include "tb_timer.xpm"
#include "tb_timer_stopped.xpm"

#include <gnome.h>

GtkWidget *window;
GtkWidget *notebook;
GtkNotebookPage *offPage;
GList *page_list = NULL;

void (*gtop_time_cb)(GtkWidget *w, gpointer gp) = NULL;

gint tb_ss = -1;

static gint start_page = 0;
static gint os_x, os_y, os_w, os_h;

static void gtop_msg_send (GtkNotebook *n, GtkNotebookPage *p, GTopPageSignal s);

static int
delete_event_handler (GtkWidget *widget)
{
	/* printf ("gtop: delete_event\n"); */

	gnome_config_set_int ("gtop/main/page",
			      gtk_notebook_current_page (GTK_NOTEBOOK (notebook)));

	gtop_msg_send (GTK_NOTEBOOK (notebook), NULL, GTOP_PAGE_CFG_SAVE);
	gtop_msg_send (GTK_NOTEBOOK (notebook), offPage, GTOP_PAGE_LEAVE);

	gnome_config_sync ();

	page_list = NULL;

        gtk_widget_destroy (window);
        gtk_main_quit ();

        return TRUE;
}

void
about_cb (GtkWidget *widget, void *data)
{
	GtkWidget *about;
	const gchar *authors[] = {
		"Radek Doulik (doulik@karlin.mff.cuni.cz)",
		"Martin Baulig (martin@home-of-linux.org)",
		NULL
	};
	
	about = gnome_about_new ( _("GTop"), VERSION,
				  /* copyright notice */
				  _("(C) 1998 the Free Software Foundation"),
				  authors,
				  /* another comments */
				  _("The GNOME System Monitor program"),
				  NULL);
	gtk_widget_show (about);
	
	return;
}

static void
gtop_msg_send (GtkNotebook *n, GtkNotebookPage *p, GTopPageSignal s)
{
	GList *c = page_list;
	GList *np = n->children;	

	while (c) {
		if (c->data)
			((void (*) (GtkNotebook *, GtkNotebookPage *, GTopPageSignal))
			 c->data) (n, (p) ? p : np->data, s);
		c = c->next;
		np = np->next;
	}
}

void
switch_page_handler (GtkNotebook *notebook, GtkNotebookPage *page, gpointer gp)
{
	GList *c = page_list;

	/* printf ("switch page handler\n"); */

	if (page == offPage)
		return;

	/* send LEAVE to all pages */
	if (offPage) {
		gtop_msg_send (notebook, offPage, GTOP_PAGE_LEAVE);
		/* while (c) {
			if (c->data)
				((void (*) (GtkNotebook *, GtkNotebookPage *,
					    GTopPageSignal))
				 c->data) (notebook, offPage, GTOP_PAGE_LEAVE);
			c = c->next;
		} */
		c = page_list;
	}

	/* send ENTER to all pages */
	gtop_msg_send (notebook, page, GTOP_PAGE_ENTER);
	/* while (c) {
		if (c->data)
			((void (*) (GtkNotebook *, GtkNotebookPage *, GTopPageSignal))
			 c->data) (notebook, page, GTOP_PAGE_ENTER);
		c = c->next;
	} */

	offPage = page;
}

static void
gtop_time_handler (GtkWidget *w, gpointer gp)
{
	if (gtop_time_cb)
		(*gtop_time_cb) (w, gp);
}

/* menu system */

GnomeUIInfo helpMenu [] = {
	GNOMEUIINFO_HELP("gtop"),
	{GNOME_APP_UI_ITEM, N_("About..."), NULL, about_cb, NULL, NULL,
	 GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_ABOUT, 0, 0, NULL},
	GNOMEUIINFO_END
};
  
GnomeUIInfo systemMenu [] = {
#if 0
	GNOMEUIINFO_ITEM (N_("item 1"), NULL, NULL, NULL),
	GNOMEUIINFO_ITEM (N_("item 2"), NULL, NULL, NULL),
	GNOMEUIINFO_ITEM (N_("item 3"), NULL, NULL, NULL),
#endif
	GNOMEUIINFO_END
};

GnomeUIInfo fileMenu [] = {
	{GNOME_APP_UI_ITEM, N_("Properties..."), NULL, gtop_show_properties,
	 NULL, NULL, GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_PROP, 0, 0, NULL},
	GNOMEUIINFO_SEPARATOR,
	{GNOME_APP_UI_ITEM, N_("Exit"), NULL, delete_event_handler, NULL, NULL,
	 GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_EXIT, 'q', 0, NULL},
	GNOMEUIINFO_END
};

GnomeUIInfo mainmenu [] = {
	GNOMEUIINFO_SUBTREE (N_("File"), fileMenu),
	GNOMEUIINFO_SUBTREE (N_("View"), procViewMenu),
	GNOMEUIINFO_SUBTREE (N_("Memory"), memUsageMenu),
	GNOMEUIINFO_SUBTREE (N_("Filesystems"), fsUsageMenu),
	GNOMEUIINFO_SUBTREE (N_("System"), systemMenu),
	GNOMEUIINFO_SUBTREE (N_("Help"), helpMenu),
	GNOMEUIINFO_END
};

GnomeUIInfo tbar[] = {
  {GNOME_APP_UI_ITEM, N_("Start/Stop"), N_("Start / Stop sampling"), gtop_time_handler,
   NULL, NULL,
   GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_PIXMAP_TIMER, 0, 0, NULL},
  GNOMEUIINFO_SEPARATOR,
  {GNOME_APP_UI_ITEM, N_("Properties"), N_("Set gtop properties"),
   gtop_show_properties, NULL, NULL,
   GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_PIXMAP_PROPERTIES, 0, 0, NULL},
  GNOMEUIINFO_END
};

void
gnome_app_menu_traverse (void (*fn) (GtkWidget *), GnomeApp *app, gint first, gint last)
{
	GList *l;

	if (last == -1)
		last = first;

	l = g_list_nth (GTK_MENU_SHELL
			(GNOME_APP (window)->menubar)->children,
			first);

	for (; first <= last && l; first++, l = l->next)
		(*fn) (GTK_WIDGET (l->data));
}

void
createMainWindow (char *argv0)
{
	window = gnome_app_new (argv0, _("GNOME System Monitor"));
	gtk_widget_set_name (GTK_WIDGET (window), "GTop");
	gtk_window_set_wmclass (GTK_WINDOW (window), "gtop", "gtop");
	
	gnome_app_create_menus (GNOME_APP(window), mainmenu);

	/* Short hack to get correct menu when starting with
	 * memusage view. */

	switch (start_page) {
	case 2: /* Fsusage */
		gnome_app_menu_hide (GNOME_APP(window),
				     GTOP_MENU_VIEW, GTOP_MENU_MEMUSAGE);
		gnome_app_menu_hide (GNOME_APP(window),
				     GTOP_MENU_SYSTEM, -1);
		break;
	case 1: /* Memusage */
		gnome_app_menu_hide (GNOME_APP(window),
				     GTOP_MENU_VIEW, -1);
		gnome_app_menu_hide (GNOME_APP(window),
				     GTOP_MENU_FSUSAGE, GTOP_MENU_SYSTEM);
		break;
	default: /* Process List */
		gnome_app_menu_hide (GNOME_APP(window),
				     GTOP_MENU_MEMUSAGE, GTOP_MENU_SYSTEM);
		break;
	}

	gnome_app_create_toolbar (GNOME_APP(window), tbar);
	gtk_toolbar_set_style (GTK_TOOLBAR (GNOME_APP(window)->toolbar),
			       GTK_TOOLBAR_ICONS);

	if (restarted) {
		gtk_widget_set_uposition (window, os_x, os_y);
		gtk_widget_set_usize     (window, os_w, os_h);
	} else {
		gtk_widget_set_usize(GTK_WIDGET(window), 780, 480);
	}

	gtk_window_set_policy (GTK_WINDOW (window), TRUE, TRUE, FALSE);
	
	gtk_signal_connect (GTK_OBJECT (window), "delete_event",
			    GTK_SIGNAL_FUNC (delete_event_handler), NULL);
        
	notebook = gtk_notebook_new ();
	gnome_app_set_contents(GNOME_APP (window), notebook);

	gtk_notebook_set_tab_pos (GTK_NOTEBOOK (notebook), GTK_POS_TOP);
	gtk_signal_connect (GTK_OBJECT (notebook), "switch_page",
			    GTK_SIGNAL_FUNC (switch_page_handler), NULL);

	gtk_widget_show (notebook);
}

#define ADD(x) page_list = g_list_append (page_list, add ## x ## View ())

#define ADD_PROPERTIES(x) gtop_properties_hook = g_list_append (gtop_properties_hook, & ## x ## PropertiesHook)
        
int
main (int argc, char *argv[])
{
        GnomeClient *client;

	argp_program_version = VERSION;

	bindtextdomain (PACKAGE, GNOMELOCALEDIR);
	textdomain (PACKAGE);

	gnome_init ("gtop", &parser, argc, argv, 0, NULL);
	
	/* session management init */
        client = gnome_master_client ();

        gtk_signal_connect (GTK_OBJECT (client), "save_yourself",
                            GTK_SIGNAL_FUNC (save_state), NULL);

	if (GNOME_CLIENT_CONNECTED (client)) {
		/* Get the client, that may hold the configuration for this
		 * program.  This client may be NULL.  That meens, that this
		 * client has not been restarted.  I.e. 'gnome_cloned_client'
		 * is only non NULL, if this application was called with the
		 * '--sm-client-id' or the '-sm-cloned-id' command line option,
		 * but this is something, the gnome libraries and the session
		 * manager take care for you.
		 */
		
		GnomeClient *cloned= gnome_cloned_client ();

		if (cloned) {
			/* If cloned is non NULL, we have been restarted. */
			restarted= 1;
			
			/* We restore information that was stored once before.
			 * Note, that we use the cloned client here, because
			 * it may be that we are a clone of another client,
			 * which has another client id than we have.
			 */

			gnome_config_push_prefix
				(gnome_client_get_config_prefix (cloned));
	  
			os_x = gnome_config_get_int ("Geometry/x");
			os_y = gnome_config_get_int ("Geometry/y");
			os_w = gnome_config_get_int ("Geometry/w");
			os_h = gnome_config_get_int ("Geometry/h");
			
			gnome_config_pop_prefix ();
		}

		/* We could even use 'gnome_client_get_config_prefix' is cloned
		 * is NULL.  In this case, we would get "/gnome-hello-4-SM/" as
		 * config prefix.  This is usefull, if the gnome-hello-4-SM
		 * config file holds some default values for our application.
		 */
	}

	if (just_exit) return 0;

	start_page = gnome_config_get_int ("gtop/main/page=0");

	/* prepare gtop environment */
	createMainWindow (argv [0]);

	/* Add properties (notebook pages). */
#if 0
	ADD_PROPERTIES (ProcView);
#endif
	ADD_PROPERTIES (SummaryColors);
	ADD_PROPERTIES (MemUsage);
	ADD_PROPERTIES (FsUsage);

	/* Read properties. */
	gtop_init_properties ();

	/* add gtop modules (notebook pages) */
	ADD (Processes);
	ADD (MemUsage);
	ADD (FsUsage);

	/* now, show window and send enter on cur_page */
        gtk_widget_show (GTK_WIDGET (window));

	offPage = NULL;
	gtk_notebook_set_page (GTK_NOTEBOOK (notebook), start_page);

	switch_page_handler (GTK_NOTEBOOK (notebook),
			     GTK_NOTEBOOK (notebook)->cur_page, NULL);

	/* enter gtk main */
        gtk_main ();
        
        return 0;
}
