/*
 * vi:ts=4:sw=4:
 *
 * Project : "  "
 * Copyright 1997. All Rights Reserved.
 * 
 * $RCSfile: m_config.h,v $
 *
 * $Revision: 1.0 $
 * 
 * $Author:  martin $ 
 * 
 * $Locker:  $
 * 
 * $State: Exp $
 * 
 * 
 * COPYRIGHT
 * =========
 * 
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 *
 * OVERVIEW
 * ========
 *
 * See the readme file for detailed information on how these sources work
 *
 */
 
#ifndef __GENERAL_CONFIG_H__
#define __GENERAL_CONFIG_H__
  
#include <stdio.h>
#include <stdlib.h>
#include <string.h> 
#include <time.h>

#ifndef PATH_MAX
#define PATH_MAX 1024
#endif
  
#define MAX_VARS 50

#define NO_CONFIG     -2
#define NO_HOMEDIR    -1 
#define CONFIG_OK      0
#define ERROR_WRITING  1

#define DEFAULT_INT    0
#define DEFAULT_FLOAT  0.00
#define DEFAULT_STRING "none"

#define DEFAULT_CONFIG ".config"

//>------- define some behavioural #defines for future use

#define DEF_DESTRUCTWRITE 1 // write file when the destructor is called
#define DEF_NOTEXISTWRITE 2 // write a file when there is no file found when constructing

struct conf_entry
{
 int nr_entries;

 char *var_name;
 char *var_types;
 void *var_array [MAX_VARS];
 
 struct conf_entry *next;
};

 
struct group_entry
{
 char  *group_name;

 struct conf_entry *var_top;
 struct conf_entry *var_current;

 struct group_entry *next;
};


class ConfigClass
{

  public:
  
    ConfigClass (char *);
    ConfigClass (char *,char *);
    ~ConfigClass ();
    
    void insert_group          (char *);                   // group 
    void insert_entry          (char *,char *,...);        // name,var_string,vars 
    void insert_entry_to_group (char *,char *,char *,...); // name,group,var_string,vars
    
    int  read_config (void);
    int  write_config (void);
    
    void set_defaults (int,float,char *);
    
    //>------ parser callback functions
    
    void create_group (char *);
    void create_var   (char *);

    void add_integer  (int);
    void add_float    (float);
    void add_string   (char *);
   
  private:
  
    ConfigClass *parent;
    
    int   default_int;
    float default_float;
    char *default_string;
  
    char *program_name;
    char *file_name;
    FILE *file_pointer;
    
    struct group_entry *group_top; 
    struct group_entry *group_current;
    
    int write_entries (FILE *,struct conf_entry *); 
    
    struct group_entry *find_group (char *);
    struct conf_entry  *find_entry (char *);    
};

#endif // __GENERAL_CONFIG_H__



