// QWeb - An SGML Web Browser
// Copyright (C) 1997  Sean Vyain
// svyain@mail.tds.net
// smvyain@softart.com
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#ifndef _TableRenderer_h_
#define _TableRenderer_h_

#include <qarray.h>
#include <qlist.h>
#include "SgmlRenderer.h"
#include "VerticalRenderer.h"

//: The Cell class allows a VerticalRenderer to be embedded within a table renderer.
//. The Cell class adds a few table-specific pieces of data to the vertical
//. renderer class, to help compute the table layout.
//. <DL>
//. <DT>rowspan<DD>This tells how many rows a cell spans.  The default is 1.
//. <DT>colspan<DD>This tells how many columns a cell spans.  The default is 1.
//. <DT>row<DD>This is the row that the cell belongs in.
//. <DT>col<DD>This is the column that the cell belongs in.  The column is computed
//. taking into account the row spans and column spans of other cells in
//. the table.
//. </DL>
struct Cell : public VerticalRenderer {
    uint rowspan;
    uint colspan;
    uint row;
    uint col;
        
    Cell( Canvas*     canvas,
          SgmlParser* parser,
          int         clipWidth=0,
          QObject*    parent=0,
          const char* name=0 );
    ~Cell();

    void repaint( QPainter& p, const Rect& r );
};

typedef QList<Cell> Row;

//: The TableRenderer class handles the geomertry management for a group of rows of cells.
class TableRenderer : public SgmlRenderer {
    Q_OBJECT
    QList<Row>  _rows;
    Cell*       _cell;
    uint        _cellDepth;
    int         _cellPadding;
    bool        _isEmpty;
public:
    TableRenderer( Canvas*     canvas,
                   SgmlParser* parser,
                   int         clipWidth=0,
                   QObject*    parent=0,
                   const char* name=0 );
    ~TableRenderer();

    //. Recompute the layout of the entire table.  This is the autolayout
    //. algorithm described in RFC1942.
    bool redraw();

    void repaint( QPainter& p, const Rect& r );

    bool findAnchor( const QString& name, int& x, int& y );
public slots:
    //. Forward the content to the open cell, if any.
    void content( QString text );

    //. Close off any open cells.
    void endOfData();

    //. If the end tag is for the current open cell, close it.  Otherwiser,
    //. forward the end tag to the cell.
    void endTag();

    //. Process a start tag from the SgmlParser.  For TableRow elements,
    //. close off any existin gcell or row, and create a new row.  For
    //. TableData elements close off any open cell and create a new one.
    //. For other types of start tags, forward them to the open cell.
    void startTag();
};

#endif
