// QWeb - An SGML Web Browser
// Copyright (C) 1997  Sean Vyain
// svyain@mail.tds.net
// smvyain@softart.com
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#include <qstack.h>
#include "SgmlElement.h"

//=============================================================================
// Public methods.
//-----------------------------------------------------------------------------
SgmlElement::SgmlElement( QString    name,
                          bool       stag,
                          bool       etag,
                          QStrIList& incl,
                          QStrIList& excl,
                          SgmlNode*  root )
        : _name( name.copy() ),
          _stagRequired( stag ),
          _etagRequired( etag ),
	  _isEmpty( root->left()->type() == SgmlNode::Empty )
{
//    printf( "root type = %d, empty = %d\n", root->type(), SgmlNode::Empty );
//    printf( "root left = %p, root right = %p\n", root->left(), root->right() );
//    printf( "left type = %d, right type = %d\n", root->left()->type(), root->right()->type() );
    
    // Create the content model DFA from the SgmlNode parse tree.
    QStrList                  strlist;
    QStack<ContentModelState> stack;
    ContentModelState*        state;
    ContentModelState*        state2;
    ContentModelState*        state3;
    SgmlNode*                 n;
    SgmlNode*                 m;
    char*                     s;
	
    // Copy inclusion and exclusion lists.
    for ( s = incl.first(); s; s = incl.next() ) {
        _include.append( s );
    }
	
    for ( s = excl.first(); s; s = excl.next() ) {
        _exclude.append( s );
    }
	
    // Create the initial state.
//	printf( "SgmlElement::SgmlElement(%s) -- creating start state\n", name );
    state = new ContentModelState;
    for ( n = root->firstpos().first(); n; n = root->firstpos().next() ) {
//		printf( "SgmlElement::SgmlElement(%s) -- n->element = '%s'\n", name, n->element() );
        state->addId( n );
    }
    _model.addState( state );
    stack.push( state );
	
    while ( !stack.isEmpty() ) {
        state = stack.pop();
        state->mark();
		
//		printf( "SgmlElement::SgmlElement(%s) -- creating next state\n", name );
        strlist.clear();
        for ( n = state->id().first(); n; n = state->id().next() ) {
//			printf( "SgmlElement::SgmlElement(%s) -- n->element = '%s'\n", name, n->element() );
            if ( ( n->element() ) && ( strlist.find( n->element() ) == -1 ) ) {
//				printf( "SgmlElement::SgmlElement(%s) -- adding '%s' to strlist\n", name, n->element() );
                strlist.append( n->element() );
            }
        }
		
        for ( s = strlist.first(); s; s = strlist.next() ) {
//			printf( "SgmlElement::SgmlElement(%s) -- s = '%s'\n", name, s );
            state2 = new ContentModelState;
            for ( n = state->id().first(); n; n = state->id().next() ) {
                if ( n->element() == s ) {
                    for ( m = n->followpos().first(); m; m = n->followpos().next() ) {
//						printf( "SgmlElement::SgmlElement(%s) -- m->element = '%s'\n", name, m->element() );
                        state2->addId( m );
                    }
                }
            }
		
            if ( state2->id().count() > 0 ) {
                if ( !( state3 = _model.find( state2 ) ) ) {
                    _model.addState( state2 );
                    stack.push( state2 );
                } else {
                    delete state2;
                    state2 = state3;
                }
                state->addTransition( s, state2 );
            } else {
                delete state2;
            }
        }
    }
}

SgmlElement::~SgmlElement()
{
    while ( _attrs.first() ) {
	delete _attrs.first();
	_attrs.remove();
    }
}

bool SgmlElement::excluded( QString name )
{
    if ( _exclude.find( name ) == -1 ) {
        return FALSE;
    } else {
        return TRUE;
    }
}

bool SgmlElement::included( QString name )
{
    if ( _include.find( name ) == -1 ) {
        return FALSE;
    } else {
        return TRUE;
    }
}
