// QWeb - An SGML Web Browser
// Copyright (C) 1997  Sean Vyain
// svyain@mail.tds.net
// smvyain@softart.com
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#ifndef _Canvas_h_
#define _Canvas_h_

#include <qlist.h>
#include <qwidget.h>
#include "Browser.h"
#include "Renderer.h"
#include "Request.h"

class Clip;
class QScrollBar;
class Url;

struct MouseZone : public Rect {
    Renderer* renderer;
    QString   url;

    MouseZone( Renderer* r, const QString& _url ) : renderer( r ), url( _url.copy() ) {}
};

class Canvas : public QWidget {
    Q_OBJECT
    QScrollBar* _vsb;
    QScrollBar* _hsb;
    Clip*       _clip;
    struct Child {
        Renderer* renderer;
        QWidget*  widget;
        Child( Renderer* _renderer, QWidget* _widget ) : renderer( _renderer ), widget( _widget ) {}
    };
    QList<Child>     _children;
    QList<MouseZone> _mouseZones;
    QList<Request>   _requests;
    Browser*         _browser;
    Renderer*        _renderer;
    int              _updateTimerId;
    int              _downloadTimerId;

    void moveWidgets();

    void moveWidget( QObject* r, QWidget* w );

    void moveMouseZones();

    void moveMouseZone( MouseZone* mouseZone );

    void scrollUp();

    void scrollDown();

    void scrollLeft();

    void scrollRight();

    void scrollPrior();

    void scrollNext();
private slots:
    //. Scroll the child renderer horizontally to match the new scrollbar
    //. position.
    void hsbMoved( int pos );

    //. Scroll the child renderer vertically to match the new scrollbar
    //. position.
    void vsbMoved( int pos );
protected:
    //. Resize the clip window, and give our child renderer a new preferred
    //. width.
    void resizeEvent( QResizeEvent* e );

    void timerEvent( QTimerEvent* e );

    void keyPressEvent( QKeyEvent* e );
public:
    Canvas( Browser* browser, const char* name=0 );

    ~Canvas();

    void mouseRelease( QMouseEvent* e );

    Renderer* renderer() { return _renderer; }

    QScrollBar* hsb() { return _hsb; }

    QScrollBar* vsb() { return _vsb; }
    
    QWidget* clip();

    const QList<MouseZone>& mouseZones() { return _mouseZones; }

    void registerWidget( Renderer* renderer, QWidget* widget );

    void registerMouseZone( Renderer* renderer, const QString& url );

    void setTitle( const QString& title );

    void setBaseUrl( const Url& url );

    void clear();

    void registerRequest( Request* r );
    
    void requestDone( Request* req );

    bool reload() { return _browser->reload(); }
public slots:
    void startOfData( Request* request, QString mediaType, QString mediaSubtype, int totalSize );

    void childSizeChanged();

    void redraw();

    const Url& baseUrl();

    void openUrl( const Url& url );

    void stop();

    void status( QString msg );
};

#endif
