/* Output from p2c 1.21alpha-07.Dec.93, the Pascal-to-C translator */
/* From input file "lyrics.pas" */


#include "cfuncs.h"


#define LYRICS_G
#include "lyrics.h"


#ifndef GLOBALS_H
#include "globals.h"
#endif

#ifndef STRINGS_H

#endif

#ifndef MTXLINE_H
#include "mtxline.h"
#endif

#ifndef STATUS_H
#include "status.h"
#endif

#ifndef FILES_H
#include "files.h"
#endif


/* Symbols used in strings of melismatype */

#define beam_melisma    '['
#define inhibit_beam_melisma  '<'
#define slur_melisma    '('
#define inhibit_slur_melisma  '{'


typedef char melismatype[256];

typedef enum {
  nolyr, haslyr
} haslyrtype;
typedef enum {
  normal, aux
} auxtype;
typedef enum {
  asbefore, newassign
} assigntype;
typedef enum {
  virgin, active
} inittype;

typedef struct lyrinfotype {
  short lyr_adjust;
  melismatype melisma;
} lyrinfotype;

typedef enum {
  none_given, global_lyrics, local_lyrics
} lyrlinetype;

typedef struct lyrtagtype {
  lyrlinetype lyrsource;
  haslyrtype has_lyrics;
  auxtype auxiliary;
  assigntype new_assign;
  inittype initialized;
  short linecount;
  char tags[256];
} lyrtagtype;


#define lyr_adjust_undef  (-12345)
#define interstave      24


static boolean lyrmodealter[maxstaves], oldlyrmodealter[maxstaves];
static lyrtagtype tag[maxvoices], oldtag[maxvoices];
static lyrinfotype lyrinfo[maxvoices];


void lyricsParagraph(void)
{
  char first[256], w[256];
  short i, l, line;
  short nother = 0;
  char other_[10][256];
  char STR1[256], STR3[256];
  short FORLIM;
  char STR4[256];
  char STR5[256];

  if (!dolyrics)
    return;
  NextWord(w, P[0], blank, dummy);
  l = strlen(w);
  line_no = orig_line_no[0];
  if (w[l-1] != '}')
    strcat(w, "}");
  GetNextWord(first, w, dummy, '}');
  while (*w != '\0') {
    if (w[0] == '=')
      predelete(w, 1);
    if (w[0] != '{')
      sprintf(w, "{%s", strcpy(STR1, w));
    nother++;
    GetNextWord(other_[nother-1], w, dummy, '}');
  }
  if (verbose > 0) {
    printf("---- Paragraph %d starting at line %d has lyrics headed %s",
	   paragraph_no, line_no, first);
    for (i = 0; i <= nother - 1; i++)
      printf("=%s", other_[i]);
    putchar('\n');
  }
  sprintf(STR5, "%c Paragraph %s line %s bar %s",
	  comment, toString(STR1, paragraph_no), toString(STR3, line_no),
	  toString(STR4, bar_no));
  tex3(STR5);
  sprintf(STR3, "\\setlyrics%s{%%", first);
  tex3(STR3);
  FORLIM = para_len;
  for (line = 2; line <= FORLIM; line++) {
    lyrTranslate(P[line-1]);
    line_no = orig_line_no[line-1];
    if (strlen(P[line-1]) > max_lyrics_line_length && pmx_preamble_done)
      error("Lyrics line too long", print);
    if (pmx_preamble_done) {
      if (line == 2) {
	sprintf(STR3, "\\\\\\:%s", P[line-1]);
	put(STR3, putspace);
      } else {
	sprintf(STR3, "\\\\\\ %s", P[line-1]);
	put(STR3, putspace);
      }
    } else
      put(P[line-1], putspace);
    if (line < para_len) {
      if (pmx_preamble_done)
	putLine(" %\\");
      else
	putLine(" %");
    } else if (pmx_preamble_done)
      putLine("}\\");
    else
      putLine("}");
  }
  for (i = 0; i <= nother - 1; i++) {
    sprintf(STR1, "\\copylyrics%s%s", first, other_[i]);
    tex3(STR1);
  }
}


static char *songraise(char *Result, short voice)
{
  char s[256];
  lyrtagtype *WITH;
  lyrinfotype *WITH1;
  char STR1[256], STR3[256];

  WITH = &tag[voice-1];
  WITH1 = &lyrinfo[voice-1];
  if (WITH->initialized == virgin && WITH1->lyr_adjust == 0)
    return strcpy(Result, "");
  else {
    if (WITH->auxiliary == aux)
      strcpy(s, "aux");
    else
      *s = '\0';
    sprintf(Result, "\\%ssetsongraise%s{%s\\internote}",
	    s, toString(STR1, PMXinstr(voiceStave(voice))),
	    toString(STR3, WITH1->lyr_adjust));
    /*    songraise:='\'+s+'setsongraise'+toString(instrument(voice))+'{' */
    return Result;
  }
}


char *lyricsReport(char *Result, short voice)
{
  char l[256];
  lyrtagtype *WITH;

  WITH = &tag[voice-1];
  if (WITH->has_lyrics == nolyr ||
      WITH->lyrsource == none_given && *WITH->tags == '\0')
    return strcpy(Result, " but has no own lyrics");
  else {
    strcpy(l, " with ");
    if (WITH->auxiliary == aux)
      strcat(l, "auxiliary ");
    strcat(l, "lyrics ");
    if (WITH->lyrsource == local_lyrics)
      strcat(l, "locally defined as \"");
    else
      strcat(l, "labelled \"");
    sprintf(Result, "%s%s\"", l, WITH->tags);
    return Result;
  }
}


void initLyrics(void)
{
  /* at the start only */
  short stave, voice, FORLIM;
  lyrinfotype *WITH;
  lyrtagtype *WITH1;

  FORLIM = nvoices;
  for (voice = 0; voice <= FORLIM - 1; voice++) {
    WITH = &lyrinfo[voice];
    WITH1 = &tag[voice];
    WITH1->has_lyrics = nolyr;
    WITH->lyr_adjust = lyr_adjust_undef;
    *WITH->melisma = '\0';
    WITH1->auxiliary = aux;
    WITH1->lyrsource = none_given;
    WITH1->new_assign = asbefore;
    WITH1->initialized = virgin;
  }
  FORLIM = nstaves;
  for (stave = 0; stave <= FORLIM - 1; stave++)
    oldlyrmodealter[stave] = false;
}


static void registerLyrics(short voice, char *w)
{
  lyrtagtype *WITH;

  WITH = &tag[voice-1];
  strcpy(oldtag[voice-1].tags, WITH->tags);
  oldtag[voice-1].lyrsource = WITH->lyrsource;
  WITH->lyrsource = global_lyrics;
  switch (strlen(w)) {

  case 0:
    *WITH->tags = '\0';
    break;

  case 1:
    fatalerror("M-Tx system error in registerLyrics");
    break;

  default:
    strcpy(WITH->tags, w);
    break;
  }
}


void extractLyrtag(short voice, char *note)
{
  /* inline lyrics change */
  lyrtagtype *WITH;
  char STR1[256], STR3[256];

  WITH = &tag[voice-1];
  if (WITH->has_lyrics == nolyr) {
    error3(voice, "Inline lyrics change on no-lyrics line");
    return;
  }
  registerLyrics(voice, note);   /* was: ''); */
  sprintf(note, "\\assignlyrics%s%s",
	  toString(STR1, PMXinstr(voiceStave(voice))), strcpy(STR3, note));
  if (WITH->auxiliary == aux)
    sprintf(note, "\\auxlyr{%s}\\", strcpy(STR3, note));
  else
    strcat(note, "\\");
}


void clearTags(void)
{
  /* at start of paragraph analyis */
  short voice, FORLIM;
  lyrtagtype *WITH;

  memcpy(oldtag, tag, maxvoices * sizeof(lyrtagtype));
  FORLIM = nvoices;
  for (voice = 0; voice <= FORLIM - 1; voice++) {
    WITH = &tag[voice];
    WITH->lyrsource = none_given;
    *WITH->tags = '\0';
    WITH->linecount = 0;
  }
}


#define maxlyrlen       (PMXlinelength - 15)


static void convertlyrics(char *lyn, short voice, auxtype mx)
{
  static char setlyr[256] = "%%\\\\\\setlyrics";
  char btag[256], thistag[256], w[256];
  char STR1[256];
  lyrtagtype *WITH;
  char STR2[256];

  NextWord(w, lyn, blank, dummy);
  WITH = &tag[voice-1];
  if (*w == '\0') {
    *WITH->tags = '\0';
    return;
  }
  WITH->has_lyrics = haslyr;
  WITH->auxiliary = mx;
  if (w[0] == '{') {
    registerLyrics(voice, w);
    return;
  }
  WITH->lyrsource = local_lyrics;
  WITH->linecount++;
  toString(thistag, voice * 10 + WITH->linecount);
  sprintf(btag, "{%s}", thistag);
  if (*WITH->tags == '\0')
    strcpy(WITH->tags, btag);
  else {
    WITH->tags[strlen(WITH->tags) - 1] = ',';
    sprintf(WITH->tags + strlen(WITH->tags), "%s}", thistag);
  }
  trim(lyn);
  lyrTranslate(lyn);
  if (strlen(lyn) + strlen(btag) > maxlyrlen)
    sprintf(lyn, "%s%s{\\\n\\\\\\:%s}\\", setlyr, btag, strcpy(STR2, lyn));
  else
    sprintf(lyn, "%s%s{%s}\\", setlyr, btag, strcpy(STR1, lyn));
}

#undef maxlyrlen


void maybeLyrics(short voice, short parline, char *w_)
{
  /* during paragraph analysis, parline had L:, already stripped */
  char w[256];
  short k;

  /**  Labelled lyrics line -- */
  strcpy(w, w_);
  if (!dolyrics)
    return;
  if (strlen(w) == 1 && voice == 0)
    warning("Lyrics line above top voice should be labelled", print);
  if (strlen(w) == 1) {   /**  Standard lyrics line -------- */
    k = voice;
    if (k == 0)
      k = 1;
    convertlyrics(P[parline-1], k, normal);
    return;
  }
  predelete(w, 1);
  k = findVoice(w);
  if (k == 0)
    error("Lyrics line belongs to unknown voice", print);
  else
    convertlyrics(P[parline-1], k, aux);
}


void reviseLyrics(void)
{
  /* after paragraph analysis */
  short voice, stave, FORLIM;
  lyrtagtype *WITH;

  FORLIM = nvoices;
  for (voice = 0; voice <= FORLIM - 1; voice++) {
    WITH = &tag[voice];
    if (oldtag[voice].lyrsource == global_lyrics &&
	WITH->lyrsource == none_given) {
      strcpy(WITH->tags, oldtag[voice].tags);
      WITH->lyrsource = global_lyrics;
    }
    WITH->new_assign = (assigntype)(WITH->has_lyrics == haslyr &&
				    strcmp(WITH->tags, oldtag[voice].tags));
    if (*WITH->tags == '\0')
      WITH->has_lyrics = nolyr;
    strcpy(oldtag[voice].tags, WITH->tags);
    oldtag[voice].lyrsource = WITH->lyrsource;
  }
  FORLIM = nstaves;
  for (stave = 0; stave <= FORLIM - 1; stave++) {
    WITH = &tag[first_on_stave[stave] - 1];
    lyrmodealter[stave] = (number_on_stave[stave] > 1 &&
			   WITH->has_lyrics == haslyr &&
			   WITH->auxiliary == normal);
  }
}


void assignLyrics(short stave, char *lyrassign)
{
  /* at start of new block */
  char atag[256], instr[256], l[256];
  short v1, v2, voice;
  char STR1[256];
  lyrtagtype *WITH;
  lyrinfotype *WITH1;

  *lyrassign = '\0';
  toString(instr, PMXinstr(stave));
  v1 = first_on_stave[stave-1];
  v2 = v1 + number_on_stave[stave-1] - 1;
  /* don't reassign if other voice takes over */
  if (tag[v1-1].auxiliary == tag[v2-1].auxiliary &&
      tag[v1-1].has_lyrics != tag[v2-1].has_lyrics) {
    for (voice = v1 - 1; voice <= v2 - 1; voice++) {
      WITH = &tag[voice];
      if (WITH->new_assign == newassign)
	WITH->new_assign = (assigntype)WITH->has_lyrics;
    }
  }
  for (voice = v1; voice <= v2; voice++) {
    WITH = &tag[voice-1];
    if (WITH->new_assign == newassign) {
      strcpy(atag, WITH->tags);
      if (*atag == '\0')
	strcpy(atag, "{}");
      sprintf(l, "\\assignlyrics%s%s", instr, atag);
      if (WITH->auxiliary == aux)
	sprintf(l, "\\auxlyr{%s}", strcpy(STR1, l));
      strcat(lyrassign, l);
      if (*WITH->tags == '\0')
	WITH->has_lyrics = nolyr;
      if (WITH->has_lyrics == haslyr && WITH->initialized == virgin) {
	WITH1 = &lyrinfo[voice-1];
	if (WITH->auxiliary == aux && upper(voice))
	  WITH1->lyr_adjust = interstave;
	else
	  WITH1->lyr_adjust = 0;
	strcat(lyrassign, songraise(STR1, voice));
	WITH->initialized = active;
      }
    }
  }
  if (lyrmodealter[stave-1] == oldlyrmodealter[stave-1])
    return;
  if (lyrmodealter[stave-1])
    sprintf(lyrassign + strlen(lyrassign), "\\lyrmodealter%s", instr);
  else
    sprintf(lyrassign + strlen(lyrassign), "\\lyrmodenormal%s", instr);
  oldlyrmodealter[stave-1] = lyrmodealter[stave-1];
}


void lyricsAdjust(short voice, char *note)
{
  /* inline at-word */
  short adj;
  boolean force, put_above, put_below;
  char s[256];
  lyrinfotype *WITH;
  lyrtagtype *WITH1;
  char STR2[256];

  WITH = &lyrinfo[voice-1];
  WITH1 = &tag[voice-1];
  predelete(note, 1);
  force = (note[0] == '=');
  if (force)
    predelete(note, 1);
  put_above = (note[0] == '^');
  if (put_above)
    predelete(note, 1);
  put_below = (note[0] == 'v');
  if (put_below)
    predelete(note, 1);
  if (*note != '\0')
    getNum(note, &adj);
  else
    adj = 0;
  if (WITH1->has_lyrics == nolyr) {
    *note = '\0';
    return;
  }
  if (put_above)
    WITH->lyr_adjust = interstave;
  else if (put_below)
    WITH->lyr_adjust = 0;
  if (force)
    WITH->lyr_adjust = adj;
  else
    WITH->lyr_adjust += adj;
  if (WITH1->auxiliary == aux)
    strcpy(s, "aux");
  else
    *s = '\0';
  songraise(note, voice);
  if (*note != '\0')
    sprintf(note, "\\\\%s\\", strcpy(STR2, note));
}


/*
%% \def\lyrflushleft{\minlyrspace=-10cm\llyr\lyroffset{-2}}
\lyrflushleft\
*/

void lyrTranslate(char *P)
{   /* Translate starting number */
  short k, l, number;
  char Q[256], w[256];
  boolean numbered = false;
  char STR1[256], STR2[256];

  GetNextWord(w, P, blank, dummy);
  if (endsWith(w, ".")) {
    getNum(w, &number);
    numbered = (number != 0);
  }
  if (numbered)
    sprintf(P, "\\llap{%s}~%s", w, strcpy(STR1, P));
  else
    sprintf(P, "%s %s", w, strcpy(STR2, P));
  /*Translate lyrics link */
  *Q = '\0';
  l = strlen(P);
  for (k = 0; k <= l - 1; k++) {
    if (P[k] != '_')
      sprintf(Q + strlen(Q), "%c", P[k]);
    else if (k + 1 > 1 && P[k-1] == '\\')
      strcat(Q, "lowlyrlink ");
    else
      strcat(Q, "\\lyrlink ");
  }
  strcpy(P, Q);
}


typedef enum {
  beam, slur
} melismaEnd;


static char removeLast(char *s, char *t)
{
  char Result;
  short i, l;

  l = strlen(s);
  for (i = l; i >= 1; i--) {
    if (pos1(s[i-1], t) > 0) {
      Result = s[i-1];
      delete1(s, i);
      return Result;
    }
  }
  return dummy;
}


static boolean OpenMelisma(char *s)
{
  return (pos1(slur_melisma, s) > 0 || pos1(beam_melisma, s) > 0);
}


/* static variables for getSyllable: */
struct LOC_getSyllable {
  short voice;
  char pre[256];
  boolean hanging_slur;
} ;

static void startMelisma(char *t, struct LOC_getSyllable *LINK)
{
  boolean open_before, open_now;
  short i, k;
  lyrinfotype *WITH;
  lyrtagtype *WITH1;

  k = strlen(t);
  WITH = &lyrinfo[LINK->voice-1];
  for (i = 0; i <= k - 1; i++) {
    open_before = OpenMelisma(WITH->melisma);
    sprintf(WITH->melisma + strlen(WITH->melisma), "%c", t[i]);
    open_now = OpenMelisma(WITH->melisma);
    if (open_now && !open_before) {
      WITH1 = &tag[LINK->voice-1];
      if (WITH1->auxiliary == aux)
	strcpy(LINK->pre, "\\auxlyr\\beginmel");
      else
	strcpy(LINK->pre, "\\beginmel");
    }
  }
}

static void endMelisma(melismaEnd t, short n, struct LOC_getSyllable *LINK)
{
  char found;
  short i;
  lyrinfotype *WITH;
  lyrtagtype *WITH1;
  char STR1[4];

  if (t == slur && LINK->hanging_slur)
    n--;
  for (i = 1; i <= n; i++) {
    WITH = &lyrinfo[LINK->voice-1];
    WITH1 = &tag[LINK->voice-1];
    switch (t) {

    case slur:
      sprintf(STR1, "%c%c", slur_melisma, inhibit_slur_melisma);
      found = removeLast(WITH->melisma, STR1);
      break;

    case beam:
      sprintf(STR1, "%c%c", beam_melisma, inhibit_beam_melisma);
      found = removeLast(WITH->melisma, STR1);
      break;
    }
    if (found == dummy)
      error3(LINK->voice, "Ending a melisma that was never started");
    if (!OpenMelisma(WITH->melisma) &&
	pos1(found, (sprintf(STR1, "%c%c", slur_melisma, beam_melisma), STR1)) > 0) {
      if (WITH1->auxiliary == aux)
	strcpy(LINK->pre, "\\auxlyr\\endmel");
      else
	strcpy(LINK->pre, "\\endmel");
    }
  }
}

static char start(boolean no_slur_melisma)
{
  if (no_slur_melisma)
    return inhibit_slur_melisma;
  else
    return slur_melisma;
}

static void startSlurMelisma(short voice, struct LOC_getSyllable *LINK)
{
  char slurs[256];
  char STR1[256];

  sprintf(slurs, "%c", start(noSlurMelisma(voice, 0)));
  if (delaySlur(voice) == 2)
    sprintf(slurs, "%c%s",
	    start(noSlurMelisma(voice, -1)), strcpy(STR1, slurs));
  startMelisma(slurs, LINK);
}

static void startBeamMelisma(short voice, struct LOC_getSyllable *LINK)
{
  char STR1[256];

  if (noBeamMelisma(voice)) {
    sprintf(STR1, "%c", inhibit_beam_melisma);
    startMelisma(STR1, LINK);
  } else {
    sprintf(STR1, "%c", beam_melisma);
    startMelisma(STR1, LINK);
  }
}


void getSyllable(short voice_, char *pretex)
{
  struct LOC_getSyllable V;

  V.voice = voice_;
  if (tag[V.voice-1].has_lyrics != haslyr)
    return;
  *V.pre = '\0';
  V.hanging_slur = (delaySlur(V.voice) > 0 && lastUnderSlur(V.voice) > 0);
  if (V.hanging_slur && pedantic)
    warning3(V.voice, "Hanging slur");
  if (afterSlur(V.voice) == 1)
    startSlurMelisma(V.voice, &V);
  if (afterBeam(V.voice) == 1)
    startBeamMelisma(V.voice, &V);
  endMelisma(slur, lastUnderSlur(V.voice), &V);
  endMelisma(beam, lastUnderBeam(V.voice), &V);
  strcat(pretex, V.pre);
}




/* End. */
