/* Header for module globals, generated by p2c 1.21alpha-07.Dec.93 */
#ifndef GLOBALS_H
#define GLOBALS_H


#ifdef GLOBALS_G
# define vextern
#else
# define vextern extern
#endif


/* 1. All global variables.
   2. String procedures that do not require manual recoding in C.
   3. Miscellaneous other procedures required by several Units.
*/


#define maxstaves       15
#define maxvoices       15
#define maxgroups       3
#define PMXlinelength   128
#define standardPMXvoices  7

#define max_lyrics_line_length  (PMXlinelength - 4)

#define lines_in_paragraph  24
#define max_bars        16
#define max_words       64
#define max_notes       64
#define inf             32000
#define unspec          1000
#define default_size    20

#define start_beam      '['
#define stop_beam       ']'
#define start_slur      '('
#define stop_slur       ')'
#define start_phrase    '{'
#define stop_phrase     '}'

#define pause           "rp"

#define grace_group     'G'
#define multi_group     'x'
#define barsym          '|'
#define comment         '%'
#define blank           ' '
#define colon           ':'
#define tilde           '~'
#define atsign          '@'
#define dummy           '\0'

#define ndurs           8
#define whole           2   /* position of '0' in durations */

#define digits          "123456789"

#define putspace        true
#define nospace         false
#define print           true


typedef char paragraph[lines_in_paragraph][256];
typedef short line_nos[lines_in_paragraph];


extern char durations[ndurs + 1];
extern char terminators[256];

extern char choice;
extern short verbose;
extern boolean ignore, dochords, dotext, dolyrics, split_dots, set_names,
	       pedantic, unbeam_if_vocal, extended_dots, private_pmx,
	       newslurs, tonic_solfa, no_uptext_for_rests, outfile_open;
extern char texdir[256];
extern char old_meter_word[256];
extern short outlen;
extern boolean ignore_input;
vextern char voice_label[maxvoices][256];
vextern char clef[maxstaves];
vextern short instr[maxstaves], stave[maxstaves], first_on_stave[maxstaves],
	      number_on_stave[maxstaves], nspace[maxstaves],
	      stave_size[maxstaves];
vextern short nvoices, bottom, top, one_beat, full_bar, line_no, nstaves,
	      ninstr, short_note, meternum, meterdenom, musicsize, pmnum,
	      pmdenom, first_par_PMX_len;
vextern double xmtrnum0;
vextern paragraph P, first_par_PMX;
vextern line_nos orig_line_no;
vextern FILE *infile, *outfile, *stylefile;
vextern char default_duration;
vextern char fracindent[256], this_version[256], this_version_date[256];
vextern boolean pmx_preamble_done, first_paragraph, final_paragraph,
		must_respace, multi_bar_rest, some_vocal;
vextern short paragraph_no, bar_no, pickup, para_len, nbars, nleft;
vextern char infile_NAME[_FNSIZE];
vextern char outfile_NAME[_FNSIZE];
vextern char stylefile_NAME[_FNSIZE];


extern void error(char *message, boolean printLine);
extern void fatalerror(char *message);
extern void warning(char *message, boolean printLine);
extern boolean equalsIgnoreCase(char *s1, char *s2);
extern boolean startsWithIgnoreCase(char *s1, char *s2);
extern boolean endsWith(char *s1, char *s2);
extern boolean startsWithBracedWord(char *P);
extern char *GetNextWord(char *Result, char *s, char Delim, char Term);
extern char *NextWord(char *Result, char *s, char Delim, char Term);
extern short wordCount(char *s);
extern char *plural(char *Result, short n);
extern short curtail(char *s, char c);
/* Remove last character if it equals c and return its position;
   otherwise return 0 */
extern char *toString(char *Result, short n);
extern void trim(char *s);
extern short digit(char c);
extern short PMXinstr(short stave);
extern void readMeter(char *meter, short *meternum, short *meterdenom,
		      short *pmnum, short *pmdenom);
extern void setMeter(char *line);
extern void setDefaultDuration(short meterdenom);
extern void setSpace(char *line);
extern char *meterChange(char *Result, short n1, short n2, boolean blind);
extern char *meterWord(char *Result, short num, short denom, short pnum,
		       short pdenom);
extern void cancel(short *num, short *denom, short lowest);
extern short whereInParagraph(short l);


#undef vextern

#endif /*GLOBALS_H*/

/* End. */
