#! /usr/bin/make -f
# this is debian.Makefile
# This is a complete rewrite of the Makefile which came with the Debian LaTeX
# package.  This Makefile should be in the base directory and it is copyright
# by Erick Branderhorst and put under the General Public License II or later.
# Copyright (c) 1996 Erick Branderhorst, Debian Association Inc.

# This Makefile has clean, all and install and a special
# install_config.  The install_config needs a config_dir being set.
# The default config_dir is ".", but you can specify another if you
# like: `make config_dir=.. install_config'. This config_dir typically
# contains .cfg and preload. files.

INSTALL_SCRIPT=	install -g root -o root -m 755
INSTALL_DIR=	install -g root -o root -d -m 755
INSTALL_DATA=	install -g root -o root -m 644

config_dir = .
SBIN	=	$(prefix)/sbin
LIB	=	$(prefix)/lib
TEXMF	=	$(LIB)/texmf
LATEX	=	$(TEXMF)/tex/latex

.PHONY: ltxbase clean

JUNK=*.dvi *.log *.aux *.glo *.idx *.ind *.gls *.lof *.lot *.toc

# Make the LaTeX kernel
all:
	yes | initex unpack.ins
	yes | tex cmextra.ins
	yes | (TEXINPUTS=..:.: tex preload.ins)

clean:
	rm -f $(JUNK); \
	   mkdir tmp; \
	   mv minimal.cls ltnews.cls ltxguide.cls ltpatch.ltx tmp; \
	   rm -f *.log *.ltx *.sty *.clo *.cls *.fd *.def *.ist; \
	   rm -f docstrip.tex ltxcheck.tex; \
	   mv tmp/* .; \
	   rmdir tmp; 
	for i in cm dc log min xpt xipt xiipt; do \
	   rm -f preload.$$i                 ; \
	done

install: latex.ltx
	$(INSTALL_DIR) $(LATEX)/base
	for f in *.{ltx,cls,clo,sty,def,fd}; do \
		$(INSTALL_DATA) $$f $(LATEX)/base/`basename $$f`; \
	done
	for f in {idx,lablst,ltxcheck,nfssfont,testpage}.tex; do\
		$(INSTALL_DATA) $$f $(LATEX)/base/`basename $$f`; \
	done
	$(INSTALL_DIR) $(LATEX)/makeindex
	for f in *.ist; do \
		$(INSTALL_DATA) $$f $(LATEX)/makeindex/`basename $$f`; \
	done
	$(INSTALL_DIR) $(TEXMF)/tex/generic/misc
	$(INSTALL_DATA) docstrip.tex $(TEXMF)/tex/generic/misc
	$(INSTALL_DIR) $(prefix)/doc/latex
	for f in {*guide,latexbug,ltnews*,ltx3info,*2e}.tex *.dtx *.ins; do \
		$(INSTALL_DATA) $$f $(prefix)/doc/latex/`basename $$f`; \
	done
	$(INSTALL_DIR) $(prefix)/lib/texmf/doc
	(cd $(prefix)/lib/texmf/doc; ln -s ../../../doc/latex latex)

install_config:
	$(INSTALL_DIR) $(LATEX)/config
	for f in $(config_dir)/{*.cfg,preload.*}; do \
		(INSTALL_DATA) $$f $(LATEX)/config/`basename $$f`; \
	done
	rm -f $(LATEX)/config/preload.ins

install_ini:
	$(INSTALL_DIR) $(TEXMF)/ini
	for f in $(config_dir)/*.initex; do \
		$(INSTALL_DATA) $$f $(TEXMF)/ini/`basename $$f`; \
	done
