#include "config.h"

#include <stdio.h>
#include <stdarg.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <sys/time.h>
#include <fcntl.h>
#include <signal.h>
#include <unistd.h>
#include <malloc.h>
#include <string.h>
#include <signal.h>
#include <sys/stat.h>
#include <stdlib.h>
#include <errno.h>
#include <dirent.h>

#include "McApp.h"
#include "McGadget.h"
#include "McSlider.h"
#include "McText.h"
#include "McBitmap.h"
#include "McString.h"
#include "McSelector.h"
#include "McResource.h"
#include "McUtils.h"
#include "McChoice.h"
#include "McInfoRequest.h"
#include "McMenubar.h"
#include "McViewBitmap.h"
#ifdef DEBUG_CODE
#include "McDebug.h"
#endif

#include "version.h"

#include "xg3.h"
#include "print.h"
#include "filegui.h"
#include "bitmap.h"
#include "files.h"
#include "icons.h"

/*   + [ 100% ] - rot+ rot- print */

/**************************************************************************/

static void make_buttons(McWindow *mcw);
static void mainloop(void);
static struct McGadget *AddMessage(struct McWindow *mcw, int x, int y, int w);
static struct McGadget *AddButton(McWindow *mcw, int x, int y, int pic,
				  void (*callback)(struct McGadget *));

/**************************************************************************/

McApp *app;
McWindow *mainWindow;
void *old_request = NULL;
McGadget *menugad, *viewgad, *zoomgad;

/**************************************************************************/

static XrmOptionDescRec userTable[] = {
  { "-debug",   "*debug",   XrmoptionNoArg,  (caddr_t)"on" },
};

/**************************************************************************/

void cleanup(int r);
static  int event_proc(McWindow *window, XEvent *event);

/**************************************************************************/

void main(int argc, char **argv) {
  XWMHints	 wm_hints;
  XSizeHints	 sizehints;
  unsigned char *filename;
  int i;

  if ((myname = strrchr(argv[0],'/'))) myname++; else myname=argv[0];

  if ((argc==2) && (!strcmp(argv[1], "-v"))) {
    printf("%s\n", XG3_VERSION);
    cleanup(0);
  }

  if ((argc==2) && ((!strcmp(argv[1], "-h")) || (!strcmp(argv[1], "-?")))) {
    printf("Usage: %s [file]\n", myname);
    cleanup(0);
  }

  app=NULL;

  /*
   * Build connection with X server
   */
  app = McCreateApp(&argc, argv, "XG3", "XG3",
		    userTable, sizeof(userTable)/sizeof(userTable[0]));

  if (argc>2) {
    fprintf(stderr, "%s: Too many arguments\n", myname);
    cleanup(1);
  }

  if (argc==2) {
    filename=argv[1];
  } else {
    filename=NULL;
  }

  /*
   * Create the window
   */
  if (!(app->h || app->w)) {
    app->h=400; app->w=320;
  }
  mainWindow=McCreateAppWindow(app,-1,-1,-1,-1, NULL, event_proc);

  memset(&sizehints, 0, sizeof(XSizeHints));
  memset(&wm_hints, 0, sizeof(XWMHints));
#ifndef DEBUG_CODE
  sizehints.flags = PMinSize;
#endif
  sizehints.min_width   = 388; sizehints.min_height  = 554;
  McSetHints(mainWindow, NULL, argc, argv, &sizehints, &wm_hints);

  /*
   * Create all bitmaps
   */
  for (i=NUM_PIXMAPS; --i>=0;) McCreateBitmapFromData(mainWindow, &pmap[i]);

  /*
   * Gadgets
   */
  make_buttons(mainWindow);
  McInitGadgets(mainWindow);
  XMapWindow(app->display, mainWindow->window);

  if (filename) open_file(filename);

  mainloop();

  /* NOTREACHED */
}

/**************************************************************************/

int doBeepAssert(int flag) {
  if (flag) XBell(app->display,0);
  return flag;
}

/**************************************************************************/

static int event_proc(McWindow *mcw, XEvent *event) {

  switch(event->type) {
  case ClientMessage:
    if ((event->xclient.format == 32) &&
	(event->xclient.data.l[0] == app->wmDelWin)) {
      if (mcw==mainWindow) cleanup(0);
      return 1;
    }
  }

  return 0;
}

/**************************************************************************/

static void exit_proc(int nonsense) {
  cleanup(0);
}

static void print_proc1(int nonsense) {
  print_g3();
}

static void print_proc2(McGadget *nonsense) {
  print_g3();
}

/**************************************************************************/

#define ITEMFLAGS (ITEM_ENABLED|ITEM_H3D)

McMenuInit fileItems[] = {
  MENUITEMCB("Load ...",  'O', ITEMFLAGS, 0, open_proc),
  MENUITEMCB("Save as ...", 0, ITEMFLAGS, 0, save_as_proc),
  MENULINE,
  MENUITEMCB("Reload",  'L',   ITEMFLAGS, 0, reopen_proc),
  MENUITEMCB("Save",    'W',   ITEMFLAGS, 0, save_proc),
  MENULINE,
  MENUITEMCB("Print",      'P',ITEMFLAGS, 0, print_proc1),
  MENULINE,
  MENUITEMCB("Exit",    'X',   ITEMFLAGS, 0, exit_proc),
};


McMenuInit zoomItems[] = {
  MENUITEMCB ("Zoom in",      '+',  ITEMFLAGS,  1, inout_proc),
  MENUITEMCB ("Zoom out",     '-',  ITEMFLAGS, -1, inout_proc),
  MENUITEMCB ("Full fit",     '*',  ITEMFLAGS,  -1, zoom_proc),
  MENULINE,
  MENUITEMCB ( "35%",           0,  ITEMFLAGS,  35, zoom_proc),
  MENUITEMCB ( "50%",           0,  ITEMFLAGS,  50, zoom_proc),
  MENUITEMCB ( "72%",           0,  ITEMFLAGS,  72, zoom_proc),
  MENUITEMCB ("100%",           0,  ITEMFLAGS, 100, zoom_proc),
};

McMenubarInit mainMenu[] = {
 { "File",    fileItems,    MENU_ITEMS(fileItems)    },
 { "Zoom",    zoomItems,    MENU_ITEMS(zoomItems)    },
};

#define BARWIDTH 16

static void make_buttons(McWindow *mcw) {
  McGadget *gad1, *gad2;
  int vbw, vbh, x;

  menugad=MakeMenubar(mcw, mainMenu, MENUBARSIZE(mainMenu), NULL, 100);
/*
		      mcw->w-100-BW-BW-BW-BW-BW);
*/

  vbw=app->w; vbh=app->h-(30-BW);

  viewgad=MakeViewBitmap(mcw,
			 BW+BW, BW+30,
			 vbw-(7*BW+BARWIDTH), vbh-(7*BW+BARWIDTH));
  viewgad->bottomRightGravity=SouthEastGravity;

  gad1=McCreateGadget(mcw, GAD_3D | GAD_H3D | GAD_ACTIVE | GAD_SELECTED,
		      SLIDERGADGET,
		      BW+BW, 30+BW+vbh-(4*BW+BARWIDTH),
		      vbw-(7*BW+BARWIDTH), BARWIDTH);
  gad1->specialInfo=McCreateSlider(SLIDER_MONO | SLIDER_HORIZONTAL, 100);
  gad1->topLeftGravity=SouthWestGravity;
  gad1->bottomRightGravity=NorthEastGravity;

  gad2=McCreateGadget(mcw, GAD_3D | GAD_H3D | GAD_ACTIVE | GAD_SELECTED,
		      SLIDERGADGET,
		      BW+BW+vbw-(4*BW+BARWIDTH), 30+BW,
		      BARWIDTH, vbh-(7*BW+BARWIDTH));
  gad2->specialInfo=McCreateSlider(SLIDER_MONO | SLIDER_VERTICAL, 100);
  gad2->topLeftGravity=NorthEastGravity;
  gad2->bottomRightGravity=SouthWestGravity;
  McViewBitmapBindSliders(viewgad, gad1, gad2);

  x=108;

  gad1=AddButton(mcw, x, BW, PIX_ZOOM_IN, zoom_in_proc);
  gad1->topLeftGravity=NorthEastGravity;
  x+=24+BW+BW+BW;

  zoomgad=AddMessage(mcw, x, BW, 60);
  zoomgad->topLeftGravity=NorthEastGravity;
  x+=60+BW+BW+BW;

  gad1=AddButton(mcw, x, BW, PIX_ZOOM_OUT, zoom_out_proc);
  gad1->topLeftGravity=NorthEastGravity;
  x+=24+BW+BW+BW;

  gad1=AddButton(mcw, x, BW, PIX_ROT_LEFT, rot_left_proc);
  gad1->topLeftGravity=NorthEastGravity;
  x+=24+BW+BW+BW;

  gad1=AddButton(mcw, x, BW, PIX_ROT_RIGHT, rot_right_proc);
  gad1->topLeftGravity=NorthEastGravity;
  x+=24+BW+BW+BW;

  gad1=AddButton(mcw, x, BW, PIX_PRINT, print_proc2);
  gad1->topLeftGravity=NorthEastGravity;
  x+=24+BW+BW+BW;

  g3_new_canvas(1000);
}

/**************************************************************************/

static struct McGadget *AddButton(McWindow *mcw, int x, int y, int pic,
				  void (*callback)(struct McGadget *)) {
  McGadget *gadget;
  gadget = McCreateGadget(mcw, GAD_3D | GAD_H3D | GAD_ACTIVE, BOOLGADGET,
			  x, y, 24, 24);
  gadget->normalBitmap = &pmap[pic];
  gadget->callbackUp=callback;
  return gadget;
}

static struct McGadget *AddMessage(struct McWindow *mcw, int x, int y, int w) {
  McGadget *gad;
  gad = McCreateGadget(mcw, GAD_3D | GAD_H3D | GAD_CLIP,
		       BOOLGADGET, x, y, w, 24);
  gad->normalLabel = McCreateText(mcw, "", app->gc[GC_NORMAL],
				  app->defaultFont, 3, 5);
  return gad;
}

/**************************************************************************/

void ChangeMessage(struct McGadget *gad, const char *fmt, ...) {
  va_list args;
  unsigned char msg[1024];
  va_start(args, fmt);
  vsprintf(msg, fmt, args);
  va_end(args);
  McChangeText(gad->mcw, gad->normalLabel, msg, 0);
  gad->normalLabel->x = ((gad->width - gad->normalLabel->width)>>1) + 2;
  McGadgetRedraw(gad);
}

/**************************************************************************/

void UpdateDisplay(void) {
}

/**************************************************************************/

void cleanup(int foo) {
  exit(foo);
}

/**************************************************************************/

static void mainloop(void) {
  while (1) {
    XEvent event;
    XNextEvent(app->display, &event);
    McAppDoEvent(app, &event);
  }
}
