#include <stdio.h>
#include <stdarg.h>
#include <string.h>
#include <errno.h>
#include <unistd.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/stat.h>

#include "McInfoRequest.h"

#include "xg3.h"
#include "files.h"
#include "g3decode.h"

/****************************************************************************/

unsigned char *current_data = NULL;
int current_size = 0;

void free_fax_data(void) {
  if (current_data) {
    free(current_data);
    current_data=NULL;
    current_size=0;
  }
}

void new_fax_data(unsigned char *new, int size) {
  free_fax_data();
  current_data=new;
  current_size=size;

  g3_decode(current_data, current_size);
}

/****************************************************************************/

static FILE *openwrite(unsigned char *file) {
  FILE *fp=fopen(file, "w");
  if (!fp) McError(app, "Cannot open `%s' for writing.\nReason: %s\n",
		   file, strerror(errno));
  return fp;
}

static FILE *openread(unsigned char *file) {
  FILE *fp=fopen(file, "r");
  if (!fp) McError(app, "Cannot open `%s' for reading.\nReason: %s\n",
		   file, strerror(errno));
  return fp;
}

/****************************************************************************/

void open_file(unsigned char *file) {
  FILE *fp;
  struct stat st;
  unsigned char *newdata;

  if (!(fp=openread(file))) goto fail;

  if (fstat(fileno(fp), &st)<0) {
    fclose(fp);
    McError(app, "Can't stat %s.\n", file);
    goto fail;
  }

  if (st.st_size>1024*1024*2) {
    fclose(fp);
    McError(app, "Huh? A G3-file larger than 2MB? Nah!\n");
    goto fail;
  }

  if (!(newdata=malloc(st.st_size))) {
    fclose(fp);
    McError(app, "Can't get memory to load the file.\n");
    goto fail;
  }

  if (fread(newdata, st.st_size, 1, fp)<=0) {
    fclose(fp);
    free(newdata);
    McError(app, "Can't read %s:\n%s\n", file, strerror(errno));
    goto fail;
  }

  fclose(fp);
  new_fax_data(newdata, st.st_size);

fail:
}

/****************************************************************************/

void save_file(unsigned char *file) {
  FILE *fp;

  if (!current_data || !current_size) {
    McError(app, "No data.\n");
    goto fail;
  }

  if (!(fp=openwrite(file))) goto fail;

  if (fwrite(current_data, current_size, 1, fp)<=0) {
    McError(app, "Can't write %s:\n%s\n", file, strerror(errno));
  }

  fclose(fp);

fail:
}

/****************************************************************************/








