/* Copyright (C) 1994 
            Olav Woelfelschneider (wosch@rbg.informatik.th-darmstadt.de)

 This library is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef _McGadget_h_
#define _McGadget_h_

#ifndef _McText_h_
#include "McText.h"
#endif
#ifndef _McBitmap_h_
#include "McBitmap.h"
#endif

/* Gadget flags */
#define GAD_H3D		    0
#define GAD_HCOMP	    1
#define GAD_HBOX	    2
#define GAD_HNONE	    3
#define GAD_HMASK	    3
#define GAD_ACTIVE	    4	/* This gadget wants events */
#define GAD_SELECTED	    8
#define GAD_PRESSED	   16
#define GAD_TOGGLE	   32
#define GAD_INVIS	   64
#define GAD_STATE	  128	/* private */
#define GAD_3D		  256
#define GAD_DISABLE	  512
#define GAD_NOFILL	 1024	/* Don't ClearArea this gadget before redraw,*
				 * since the Bitmap will cover the whole     *
				 * gadget anyway.			     */
#define GAD_CLIP	 2048
#define GAD_CHANGED	 4096	/* This gadget's contents have been changed  */
#define GAD_DOUBLE_CLICK 8192	/* Set if gadget was double clicked          */
#define GAD_NOSTIPPLE	16384	/* Don't stipple the gadget during callback  */
#define GAD_NORELVERIFY	32768	/* ButtonRelease doesn't need 2b gadget      */

/* Gadget types */
enum {
  CUSTOMGADGET,
  BOOLGADGET,
  SLIDERGADGET,
  ORDERGADGET,
  STRINGGADGET,
  SELECTORGADGET,
  MENUGADGET,		/* PRIVATE! */
  SELECTIONGADGET,
  LOADGADGET,
  CHOICEGADGET,
  MENUBARGADGET,
  VIEWTEXTGADGET,
  METERGADGET,
  KNOBGADGET,
  VIEWBITMAPGADGET,
};

/* Extension types */
enum {
  EXT_NONE,
  EXT_DISKOBJECT,
};

typedef struct McSpecialInfo {
  void (*borderProc)(struct McGadget *, int);
  void (*updateProc)(struct McGadget *, int, int);
  int  (*eventProc)(struct McGadget *, XEvent *);
  void (*cleanupProc)(struct McGadget *);
  int  (*releaseProc)(struct McGadget *, int, int);
  struct McGadget *next;
  struct McGadget *prev; /* For keyboard focus */
} McSpecialInfo;

typedef struct McGadgetExtension {
  struct McGadgetExtension *next;
  int type;
  void (*cleanupProc)(struct McGadget *);
} McGadgetExtension;

typedef struct McGadget {
  struct McGadget *next;
  struct McGadget *prev;
  unsigned int type;
  unsigned int flags;
  int topLeftGravity;
  int bottomRightGravity;
  struct McBitmap *normalBitmap;
  struct McBitmap *selectBitmap;
  struct McText *normalLabel;
  struct McText *selectLabel;
  void	(*callbackDown)(struct McGadget *);
  void	(*callbackUp)(struct McGadget *);
  int x, y;
  int width, height;
  int id;
  unsigned long mutualExclude;
  void *customData;
  McGadgetExtension *ext;
  McWindow *mcw;
  Time time; /* To detect double clicks */
  struct McSpecialInfo *specialInfo;
} McGadget;

extern McGadget *McCreateGadget(McWindow *mcw, unsigned int flags,
				unsigned int type, int x, int y, int w, int h);
extern void McInitGadgets(McWindow *mcw);
extern void McFreeGadget(McGadget *gadget);
extern void McWipeGadget(McGadget *gadget);
extern void McMoveGadget(McGadget *gadget, int x, int y);
extern void McResizeGadget(McGadget *gadget, int w, int h);
extern void McGadgetRedraw(McGadget *gadget);
extern void McGadgetBorderRedraw(McGadget *gadget, int busy);
extern void McGadgetBusy(McGadget *gadget);
extern void McGadgetUpdate(McGadget *gadget);
extern int McGadgetEvent(McGadget *gadget, XEvent *event);
extern void McGadgetInfo(McGadget *gadget);
extern void McSetFocus(McGadget *gadget);
extern void McReleaseGadget(McGadget *gadget, int inside);
#endif /* _McGadget_h_ */

