/* Copyright (C) 1994 
            Olav Woelfelschneider (wosch@rbg.informatik.th-darmstadt.de)

 This library is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef _McApp_h_
#define _McApp_h_

#include "McColors.h"

#include <X11/Xlib.h>
#include <X11/Xresource.h>
#include <X11/Xutil.h>
#include "../config.h"

/* For convenience */
#define string_t unsigned char *

/* The various drawing modes for the 3d effect */

enum {
  _3D_OUT,
  _3D_IN,
  _3D_NONE,
};

/* The GC's are stored in an array inside the McApp structure */
enum {
  GC_NORMAL,
  GC_CLEAR,
  GC_BUSY,
  GC_SELECTED,
  GC_SELECTED_BITMAP,
  GC_SET_SELECTED_BITMAP,
  GC_BRIGHT,
  GC_DARK,
  GC_SMALL,
  GC_SET_NORMAL,
  NUM_GC,
};

#ifndef DEFAULT_FONT
#define	DEFAULT_FONT	"-b&h-lucida-medium-r-normal-sans-*-120-*-*-p-*-*-*"
#endif

#ifndef WB_FONT
#define WB_FONT		"-misc-*-medium-r-normal-*-10-*-*-*-*-*-*-*"
/*	 alternative: "-adobe-helvetica-medium-r-normal-*-*-100-*-*-p-*-*-*" */
#endif

#define FIXED_FONT	"fixed"

struct McApp;
struct McBitmap;
struct McText;
struct McGadget;
struct McWindow;
struct WbColorTranslations;
struct McHotkeyHandler;

#define MCAPP_COLOR		1
#define MCAPP_ICONIC		2
#define MCAPP_REVERSE		4
#define MCAPP_SYNCED		8
#define MCAPP_RESDEBUG		16
#define MCAPP_BSTORE		32
#define MCAPP_CLIP		64
#define MCAPP_ALLOW_SENDEVENT	128
#define MCAPP_DOTTY_INFO	256  /* If set, info files begin with a dot */
#define MCAPP_REINIT		512  /* Prefs changed, re-init necessary */

typedef struct McApp {
  XrmDatabase cmdlineDB, resDB;
  char *color_names[MAX_COLORS];
  char *default_font_name;
  char *fixed_font_name;
  char *wb_font_name;
  char *class;
  Display *display;
  int screen;
  Atom wmDelWin, McToolName;
  int ico_x,ico_y,ico_w,ico_h,icon_geometry_flags;
  int x,y,w,h,geometry_flags;
  char *window_title;
  GC gc[NUM_GC];
  XFontStruct *defaultFont;
  XFontStruct *wbFont;
  XFontStruct *fixedFont;
  Pixmap stipple1;
  Pixmap stipple3;
  int flags;
  Colormap colormap;
  unsigned long colors[MAX_COLORS];
  struct WbColorTranslations *wbcolors;
  struct McBitmap *checkmark;
  struct McBitmap *altmark;
  Window mainWindow;
  struct McWindow *firstWindow;
  struct McWindow *lastWindow;
  struct McHotkeyHandler *hotkeyHandler;
} McApp;

typedef struct McHotkeyHandler {
  int	(*callback)(struct McGadget *, XEvent *);
  struct McGadget *gadget;
} McHotkeyHandler;

#define MCW_CLOSEREQUEST	1   /* Mainloop should close the window ASAP */

typedef struct McWindow {
  struct McWindow *prev;
  struct McWindow *next;
  int flags;
  McApp *app;
  int window_visible;
  int window_has_focus;
  int x,y,w,h;
  Window window;
  Region region;
  struct McGadget *firstGadget;
  struct McGadget *lastGadget;
  struct McGadget *keyboardFocus;
  KeySym keysym;
  XComposeStatus compose;
  int	(*eventCallback)(struct McWindow *, XEvent *);
  void	(*configureCallback)(struct McWindow *, int);
  void *customData;
  long event_mask;
  unsigned char *selection;
  struct McGadget *selectionOwner;
} McWindow;

#define	BW	2

McApp *McAllocApp(int *ac, char *av[], char *title, char *class,
		  XrmOptionDescRec *DescTable, int DescSize);
McApp *McInitApp(McApp *app);
extern McApp *McCreateApp(int *ac, char *av[], char *title, char *class,
			  XrmOptionDescRec *DescTable, int DescSize);
extern void McAppDrawbox(McWindow *mcw, Window win,
			 int x,int y,int width,int height,int mode);
extern int McInRectangle(int ex, int ey, int x, int y, int width, int height);
extern McWindow *McCreateAppWindow(McApp *app, int x, int y, int w, int h,
		      void (*configureCallback)(struct McWindow *, int),
		      int (*eventCallback)(struct McWindow *, XEvent *event));
extern XFontStruct *McLoadFont(Display *display, char *name);
extern void McAddInput(McWindow *mcw, long mask);
extern void McRemoveInput(McWindow *mcw, long mask);

extern void McAddGadgetToList(McWindow *mcw, struct McGadget *gadget);
extern void McRemoveGadgetFromList(struct McGadget *gadget);
extern void McMoveGadgetToStart(struct McGadget *gadget);

extern void McAddWindowToList(McApp *app, struct McWindow *window);
extern void McRemoveWindowFromList(McApp *app, struct McWindow *window);
extern void McMoveWindowToStart(McApp *app, struct McWindow *window);

extern int McAppDoEvent(McApp *app, XEvent *event);
extern void McFreeAppPrefs(McApp *app);
extern void McFreeApp(McApp *app);
extern void McFreeWindow(McApp *app, McWindow *mcw);
extern void cleanup(int r);

/* Yeah, it's simple... (: */
extern McWindow *McCreateSimpleWindow(McApp *app, const unsigned char *title,
				      int width, int height,
				      int minwidth, int minheight,
				      int x, int y,
				      void (*configureCallback)
					    (struct McWindow *, int),
				      int (*eventCallback)
					   (struct McWindow *, XEvent *event));

extern unsigned char *McMakePathAbsolute(unsigned char *pa);

extern int McAppDefaultEventHandler(McWindow *mcw, XEvent *event);
extern void McResizeWindow(McWindow *mcw, int w, int h);

extern void McSetClipRectangle(McWindow *mcw, GC gc, XRectangle *rect);
extern void McClearClipRectangle(McWindow *mcw, GC gc);

#define MCAPP_DEFAULT_EVENT_HANDLER McAppDefaultEventHandler

extern char *myname, myclass[64];

#endif /* _McApp_h_ */
