#ifndef _PROGRAM_H_
#define _PROGRAM_H_

#include "../message/message.h"
#include "../storage/storage.h"
#include "../string/string.h" 
#include <stdio.h>

class Program: public Message
{
    public:
	~Program ();
	Program ();
	Program (int argc, char const * const *argv);
	Program (Program const &other);
	Program const &operator= (Program const &other);

	void arglist (int argc, char const * const *argv);

	void banner () const;

	void setlevel () const;

	int isshell () const;
	int redirected () const;
	FILE *inputfile () const;

	int getargc () const;
	String const &getargv (int index) const;
	char const *const *getargv () const;
	String const &getprogname () const;
    
	int runcommand () const;

    private:
	void copy (Program const &other);
	void destroy ();

	Storage *av;
};

#endif
