.\" X-BASED CUBES
.\"
.\" xcubes.man
.\"
.\" ##
.\"
.\" Copyright (c) 1994 - 96	David Albert Bagley
.\"
.\"                   All Rights Reserved
.\"
.\" Permission to use, copy, modify, and distribute this software and
.\" its documentation for any purpose and without fee is hereby granted,
.\" provided that the above copyright notice appear in all copies and
.\" that both that copyright notice and this permission notice appear in
.\" supporting documentation, and that the name of the author not be
.\" used in advertising or publicity pertaining to distribution of the
.\" software without specific, written prior permission.
.\"
.\" This program is distributed in the hope that it will be "playable",
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
.\"
.TH CUBES 6 "8 January 1995" "V5.2"
.SH NAME
xcubes \- Cubes X widget
.SH SYNOPSIS
.B /usr/games/xcubes
[-display <display>] [-geometry <geometry>]
[-{foreground | fg} <color>] [-{background | bg} <color>]
[-brick <color>] [-{border | bd} <color>] [-size{x|y|z} <int>]
.SH DESCRIPTION
.LP
Use "\fBmouse-left\fP" to move a brick.
.LP
"\fBmouse-right\fP", "\fBR\fP", or "\fBr\fP", to randomize.  One must double
click on "\fBmouse-right\fP" if the puzzle is being worked on.
.LP
"\fBS\fP" or "\fBs\fP" keys reserved for the auto-solver (unimplemented).
.LP
"\fBU\fP" or "\fBu\fP" keys to undo move.
.LP
"\fBG\fP" or "\fBg\fP" keys to get a saved puzzle.
.LP
"\fBW\fP" or "\fBw\fP" keys to write or save a puzzle.
.LP
"\fBQ\fP", "\fBq\fP", or "\fBCTRL-C\fP" keys kill program.
.LP
Use the key pad or "R" keys to move without the mouse.
.LP
Use the control key and the keypad or arrow keys to enlarge or reduce the
complexity of the puzzle.
.SH OPTIONS
.TP 8
.B \-display \fIhost\fP:\fIdpy\fP
This option specifies the X server to contact.
.TP 8
.B \-geometry {+|\-}\fIX\fP{+|\-}\fIY\fP
This option sets the initial position of the cubes window (resource
name "\fIgeometry\fP").
.TP 8
.B \-{foreground | fg} \fIcolor\fP
This option specifies the foreground of the cubes window (resource name
"\fIforeground\fP").
.TP 8
.B \-{background | bg} \fIcolor\fP
This option specifies the background of the cubes window (resource name
"\fIbackground\fP").
.TP 8
.B \-brick \fIcolor\fP
This option specifies the brick color of the bricks in the cubes window
(resource name "\fIbrickColor\fP").
.TP 8
.B \-{border | bd} \fIcolor\fP
This option specifies the border color of the bricks in the cubes window
(resource name "\fIborderColor\fP").
.TP 8
.B \-size{x|y|z} <\fIint\fP>
This option allows you to change the number of cubes in a row, column, or
stack (resource name "\fIsizeA\fP").
.SH SEE ALSO
.LP
X(1), xtriangles(6), xhexagons(6), xmlink(6), xrubik(6), xskewb(6),
xdino(6), xpyraminx(6), xoct(6), xmball(6), xabacus(1)
.SH COPYRIGHTS
.LP
\*R Copyright 1994-96, David Albert Bagley
.SH BUG REPORTS AND PROGRAM UPDATES
.LP
Send bugs (or their reports, or fixes) to the author
.RS
David Albert Bagley,	<\fIbagleyd@hertz.njit.edu\fP>
.RE
.LP
The most updated source could be found on \fIftp.x.org\fP under
\fI/contrib/games/puzzles\fP.
