/*
 * Programm XBLAST V1.2.6 or higher
 * (C) by Oliver Vogel (e-mail: vogel@ikp.uni-koeln.de)
 * February 6th 1996
 * started August 1993
 *
 * File: intro.c
 * intros etc for xblast
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public Licences as by published
 * by the Free Software Foundation; either version 2; or (at your option)
 * any later version
 *
 * This program is distributed in the hope that it will entertaining,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILTY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Publis License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#define _INTRO_C

#include <stdio.h>
#include <stdlib.h>


#include "const.h"
#include "include.h"
#include "mytypes.h"
#include "patchlev.h"

#include "block.h"
#include "sprite.h"
#include "graphics.h"
#include "data.h"
#include "info.h"
#include "maze.h"
#include "main.h"
#include "event.h"
#include "status.h"
#include "intro.h"
#include "introdat.h"

#define SCORE_TIME 16





/*
 * local function draw_intro_player
 */
#ifdef __STDC__
static void
draw_intro_player (int player, 
		   char *name,
		   XBConfig *config)
#else
static void
draw_intro_player (player, name, config)
     int player;
     char *name;
     XBConfig *config;
#endif
{
  int disp;
  static char disp_name[]="X\0";

  disp_name[0]='1'+config->pl_at_disp[player];
  add_player_to_sprite_list(player, intro_player_pos[player].x, 
			    intro_player_pos[player].y, 0, TRUE);
  for (disp = 0; disp < config->num_disp; disp ++) {
    draw_textbox(disp, name, FF_White|FF_Boxed|FF_Large, 
		 intro_player_box+player);
    /* Floor */
    draw_block(disp, control_pos[player][0].x, control_pos[player][0].y, 0);
    /* Display */
    draw_block(disp, control_pos[player][1].x, control_pos[player][1].y, 3);
    draw_textbox(disp, disp_name, FF_Large | FF_Black, disp_box+player);
    /* alpha control */
    if (player == disp_player[disp].p2) {
      draw_block(disp, control_pos[player][2].x, control_pos[player][2].y, 2);
    }
    /* num control */
    if (player == disp_player[disp].p1) {
      draw_block(disp, control_pos[player][3].x, control_pos[player][3].y, 1);
    }
  }

  switch(player) {
  case 0:
    mark_maze(5,0,5,1);
    mark_maze(1,0,3,1);
    break;
    
  case 1:
    mark_maze(9,0,9,1);
    mark_maze(11,0,13,1);
    break;
    
  case 2:
    mark_maze(9,5,9,6);
    mark_maze(11,5,13,6);
    break;
    
  case 3:
    mark_maze(5,5,5,6);
    mark_maze(1,5,4,6);
    break;
  }
}

		   

/*
 * public function: do_intro 
 *   intro screen of xblast
 */
#ifdef __STDC__
void 
do_intro (BMPlayer *ps,
	  PlayerStrings *p_string, 
	  XBConfig *config)
#else
void 
do_intro (ps, p_string, config)
     BMPlayer *ps;
     PlayerStrings *p_string;
     XBConfig *config;
#endif
{
  int disp;
  int count;
  int player;
  int i, flags;

  for (disp = 0; disp < config->num_disp; disp ++) {
    init_block(disp, BLIronFloor, BTFree, "Black","Gray75","MidnightBlue");
    init_block(disp, BLControlNum, 1, NULL, NULL, NULL);
    init_block(disp, BLControlAlpha, 2, NULL, NULL, NULL);
    init_block(disp, BLDisplay, 3, NULL, NULL, NULL);

    clear_pixmap(disp);

    if (colorMode[disp]) {
      flags = FF_Large | FF_Black;
    } else {
      flags = FF_Large | FF_White;
    }

    draw_textbox(disp, "On a Workstation", flags, intro_box+0);
    draw_textbox(disp, "not far away", flags, intro_box+1);
    draw_textbox(disp, "Press SPACE to begin", FF_Large | FF_White | FF_Boxed,
		 intro_box+2);
  }
  
  set_fade_max(PIXH+SCOREH);
  fade_in(config->num_disp);
  
  for (disp = 0; disp < config->num_disp; disp ++) {
    flush_pixmap(disp, config->num_disp, FALSE);
  }

  /* wait for space bar */
  init_timer();
  clear_keys(config->num_player);
  do {
    wait2_event(config->num_disp);
  } while(!wait_eval_keys(config->num_player));


  for (disp = 0; disp < config->num_disp; disp ++) {
    clear_pixmap(disp);
    draw_polygon(disp, 5*BLOCK_WIDTH, BLOCK_HEIGHT, 
		 BLOCK_WIDTH*5, BLOCK_HEIGHT*6, pointx, SIZE_OF_X, TRUE);
  }

  /* update status bar */
  init_status_bar(config->num_player, config->num_disp, ps, "Press Space", 
		  FALSE);

  fade_in(config->num_disp);

  for (disp = 0; disp < config->num_disp; disp ++) {
    flush_pixmap(disp, config->num_disp, FALSE);
  }

  /* main intro screen */
  init_timer();
  clear_sprite_list();
  for (count = 0; count < INTRO_LENGTH; count ++) {
    if (count < CHAR_ANIME) {
      copy_expl_block( 0, 8, Block_B[count]);
    } else if (count < (CHAR_ANIME*2)) {
      copy_expl_block( 3, 8, Block_L[count-CHAR_ANIME]);
    } else if (count < (CHAR_ANIME*3)) {
      copy_expl_block( 6, 8, Block_A[count-CHAR_ANIME*2]);
    } else if (count < (CHAR_ANIME*4)) {
      copy_expl_block( 9, 8, Block_S[count-CHAR_ANIME*3]);
    } else {
      copy_expl_block(12, 8, Block_T[count-CHAR_ANIME*4]);
    }
     
    if (count==(INTRO_LENGTH-1)) {
      for (disp = 0; disp < config->num_disp; disp ++) {
	for (i=0; i<NUM_XC; i++) {
	  draw_textbox(disp, xc_string[i], xc_flags[i], &(xc_box[i]) );
	}
      }
      mark_maze(4, 9, 10, 11 ); 
      mark_maze(0,0,14,12);
      for (player = 0; player < config->num_player; player ++) {
	draw_intro_player(player, p_string[player].name, config);
      }
    }
    for (disp = 0; disp < config->num_disp; disp ++) {
      intro_event(config->num_disp);
    } 
  }

  init_timer();
  clear_keys(config->num_player);
  do {
    wait2_event(config->num_disp);
  } while(!wait_eval_keys(config->num_player));

  fade_out(config->num_disp);
  set_fade_max(PIXH);
  
  for (disp = 0; disp < config->num_disp; disp ++) {
    free_block(disp, BTFree);
  }
}


/* 
 * public function level_start  
 */
#ifdef __STDC__
void 
level_start (int num_disp)
#else
void 
level_start(num_disp)
     int num_disp;
#endif
{
  int disp;

  for (disp =0; disp < num_disp; disp ++) {
    flush_score_board(disp, num_disp);
  }
  fade_out(num_disp);
}



/*
 * public function level_intro
 * Level Introduction (Garth Denley)
 * modified by Oliver Vogel
 */
#ifdef __STDC__
void 
level_intro (int lvl, 
	     BMPlayer *player_stat,
	     XBSettings *setup,
	     XBConfig *config)
#else
void 
level_intro (lvl, player_stat, setup, config)
     int lvl;
     BMPlayer *player_stat;
     XBSettings *setup; 
     XBConfig *config;
#endif
{
  int player;
  int disp;
  int i, count;
  int min_range, min_bombs;

  static char **extra_info = NULL;
  static char **level_info = NULL;
  static char **player_info = NULL;
  
  /* alloc info structures if needed */
  if ( (NULL == extra_info) && (NULL == (extra_info = alloc_info()) ) ) {
    fprintf(stderr, "Failed to alloc info structure\n");
    exit(1);
  }
  if ( (NULL == level_info) && (NULL == (level_info = alloc_info()) ) ) {
    fprintf(stderr, "Failed to alloc info structure\n");
    exit(1);
  }
  if ( (NULL == player_info) && (NULL == (player_info = alloc_info()) ) ) {
    fprintf(stderr, "Failed to alloc info structure\n");
    exit(1);
  }

  /* Load maze and display initial positions */
  load_maze(player_stat, lvl, config, setup, &min_range, &min_bombs);

  for (player = 0; player < config->num_disp; player ++) {
    draw_maze(player);
  }
  reset_status_bar(player_stat, "Press Space", FALSE);
  
  /* draw player positions */
  for (player = 0; player < config->num_player; player ++) {
    print_player_lives(player, FALSE);
    player_stat[player].anime = 0;
    add_player_to_sprite_list(player,
			      player_stat[player].x, player_stat[player].y,
			      player_stat[player].anime, TRUE);
  }

  for (player = 0; player < config->num_disp; player ++)
    draw_sprites(player);

  clear_sprite_list();

  /* Display level info */

  get_extra_info(lvl, extra_info);
  get_level_info(lvl, level_info);
  get_player_info(lvl, player_info);

  for (disp = 0; disp < config->num_disp; disp ++) {
    /* draw level title */
    draw_textbox(disp, NULL, FF_White | FF_Boxed , title_box+0);
    draw_textbox(disp, get_level_name(lvl), FF_White |FF_Large, title_box+1);
    draw_textbox(disp, get_level_author(lvl), FF_White |FF_Small, title_box+2);

    /* draw player info */
    draw_textbox(disp, NULL, FF_White | FF_Boxed | FF_Transparent,
		 &player_info_frame);
    draw_textbox(disp, "Player Info", FF_Black | FF_Boxed | FF_Medium,
		 player_info_box+0);
    for (i=0; (i<MAX_INFO) && (player_info[i][0] != '\0'); i++) {
      draw_textbox(disp, player_info[i], FF_White | FF_Boxed | FF_Small, 
		   player_info_box+i+1);
    }
    
    /* draw level info */
    draw_textbox(disp, NULL, FF_White | FF_Boxed | FF_Transparent,
		 &level_info_frame);
    draw_textbox(disp, "Level Info", FF_Black | FF_Boxed | FF_Medium,
		 level_info_box+0);
    for (i=0; (i<MAX_INFO) && (level_info[i][0] != '\0'); i++) {
      draw_textbox(disp, level_info[i], FF_White | FF_Boxed | FF_Small, 
		   level_info_box+i+1);
    }
    
    /* draw extra info */
    draw_textbox(disp, NULL, FF_White | FF_Boxed | FF_Transparent,
		 &extra_info_frame);
    draw_textbox(disp, "Extra Info", FF_Black | FF_Boxed | FF_Medium,
		 extra_info_box+0);
    for (i=0; (i<MAX_INFO) && (extra_info[i][0] != '\0'); i++) {
      draw_textbox(disp, extra_info[i], FF_White | FF_Boxed | FF_Small, 
		   extra_info_box+i+1);
    }

    /* draw general tip */
    draw_textbox(disp, get_level_tip(lvl), FF_White | FF_Boxed | FF_Large,
		 &level_tip_box);
  }

  level_start (config->num_disp);

  for (player = 0; player < config->num_disp; player ++) {
    flush_pixmap(player, config->num_disp, FALSE);
  }

  init_timer();
  clear_keys(config->num_player);
  for (count = 0; count < SCORE_TIME ; count ++) {
    wait2_event(config->num_disp);
  }
  do {
    wait2_event(config->num_disp);
  } while(!wait_eval_keys(config->num_player));

  fade_out(config->num_disp);
}


/* 
 * public function welcome
 */
#ifdef __STDC__
void 
welcome (int num_player, PlayerStrings *st)
#else
void 
welcome (num_player, st)
     int num_player;
     PlayerStrings *st;
#endif
{
  char *tmpl;
  int j;
  int p1,p2;
  char *welcomes[MAX_PLAYER];

  for(p1=0; p1<num_player; p1++) {
    welcomes[p1] = st[p1].welcome;
  }
  for(j=0; j<3; j++) {
    for(p1=0; p1<num_player; p1++) {
      p2 = rand() % num_player;
      tmpl = welcomes[p1];
      welcomes[p1] = welcomes[p2];
      welcomes[p2] = tmpl;
    }
  }
  for(p1=0; p1<num_player; p1++) {
    set_message(welcomes[p1], FALSE);
  }
}



/* 
 * public function status_board 
 */
#ifdef __STDC__
void 
status_board (int last_player,
	      int num_victories,
	      BMPlayer *player_stat,
	      PlayerStrings *p_string,
	      XBSettings *setup,
	      XBConfig *config)
#else
void 
status_board (last_player, num_victories, player_stat, p_string, setup, config)
     int last_player;
     int num_victories;
     BMPlayer *player_stat;
     PlayerStrings *p_string;
     XBSettings *setup;
     XBConfig *config;
#endif
{
  int player,disp , i;
  int count;
  int min_range, min_bombs;

  /* load score board maze */
  load_maze(player_stat, STATUS_BOARD, config, setup, &min_range, &min_bombs);

  /* draw maze in pixmap */
  for (player = 0; player < config->num_disp; player ++) {
    draw_maze(player);
  }
  reset_status_bar(player_stat, get_level_name(STATUS_BOARD), FALSE);

  /* draw audience */
  for (i = 0; i < (3 * PIXW-128); i += 128) {
    add_player_to_sprite_list( (rand()>>4)%MAX_PLAYER, i/3, 32, 0, TRUE);
  }
  for (i = 64; i < (3 * PIXW-128); i += 128) {
    add_player_to_sprite_list( (rand()>>4)%MAX_PLAYER, i/3, -16, 0, TRUE);
  }

  /* draw player positions */
  for (player = 0; player < config->num_player; player ++) {
    print_player_lives(player, FALSE);
    for (disp = 0; disp < config->num_disp; disp ++) {
      draw_textbox(disp, p_string[player].name, FF_Medium |FF_Boxed |FF_White,
		   score_player_box+player);
    }
    
    if (player == last_player) {
      player_stat[player].anime = WINNER_ANIME;
    } else if (player_stat[player].victories == num_victories) {
      player_stat[player].anime = 0;
    } else {
      player_stat[player].anime = 14;
    }
    
    add_player_to_sprite_list(player,
			      player_stat[player].x, player_stat[player].y,
			      player_stat[player].anime, TRUE);
    for (i = 0; i < player_stat[player].victories; i ++) {
      add_trophy_to_sprite_list(i, player);
    }
  }

  for (player = 0; player < config->num_disp; player ++) {
    draw_sprites(player);
  }
  clear_sprite_list();

  level_start(config->num_disp);

  for (player = 0; player < config->num_disp; player ++) {
    flush_pixmap(player, config->num_disp, FALSE);
  }

  init_timer();
  clear_keys(config->num_player);
  for (count = 0; count < SCORE_TIME ; count ++) {
    wait2_event(config->num_disp);
  }
  do {
    wait2_event(config->num_disp);
  } while(!wait_eval_keys(config->num_player));

  fade_out(config->num_disp);
}




/* local function winning the game */
#ifdef __STDC__
void 
winning_the_game (int last_player,
		  BMPlayer *player_stat,
		  PlayerStrings *p_string,
		  XBSettings *setup,
		  XBConfig *config)
#else
void 
winning_the_game (last_player, player_stat, p_string, setup, config)
     int last_player;
     BMPlayer *player_stat;
     PlayerStrings *p_string;
     XBSettings *setup;
     XBConfig *config;
#endif

{
  static char Message[80];
  int disp,player;
  int min_range, min_bombs;
  int i;

  for (disp = 0; disp < config->num_disp; disp++) {
    clear_window(disp);
  }

  /* load score board maze */
  load_maze(player_stat, WINNING_THE_GAME, config, setup, 
	    &min_range, &min_bombs);

  /* draw maze in pixmap */
  for (player = 0; player < config->num_disp; player ++) {
    draw_maze(player);
  }
  game_time = 0;
  reset_status_bar(player_stat, get_level_name(WINNING_THE_GAME), TRUE);

  /* draw audience */
  for (i = 0; i < (3 * PIXW-128); i += 128) {
    player = (rand()>>4)%MAX_PLAYER;
    add_player_to_sprite_list(player, i/3, 32,
			      (player == last_player)? 15 : 14 , TRUE);
  }
  for (i = 64; i < (3 * PIXW-128); i += 128) {
    player = (rand()>>4)%MAX_PLAYER;
    add_player_to_sprite_list(player, i/3, -16,
			      (player == last_player)? 15 : 14 , TRUE);
  }

  /* draw player positions */
  for (player = 0; player < config->num_player; player ++)
    {
      print_player_lives(player, FALSE);
      if (player != last_player) {
	player_stat[player].anime = 14;
	add_player_to_sprite_list(player,
				  player_stat[player].x, 
				  player_stat[player].y,
				  player_stat[player].anime, TRUE);
      }
    }
  
  for (disp = 0; disp < config->num_disp; disp ++) {
    draw_winner(disp, last_player,
		(PIXW-BIG_WIDTH)/2, (PIXH-BIG_HEIGHT)/2-24 ); 
    draw_textbox(disp, p_string[last_player].name,
		 FF_White | FF_Medium | FF_Boxed, &winner_box);
  }
  
  for (player = 0; player < config->num_disp; player ++) {
    draw_sprites(player);
  }
  clear_sprite_list();

  if (setup->print_stat) {
    printf("GameStat {%s} {",p_string[last_player].name);
    for (player =0; player < config->num_player; player ++)
      printf(" {%s} ",p_string[player].name);
    printf("}\n");
  }

  circle_in(config->num_disp);

  for (disp = 0; disp < config->num_disp; disp ++) {
    flush_pixmap(disp, config->num_disp, FALSE);
  }
  
  sprintf(Message, p_string[last_player].wingame,
	  p_string[last_player].name);
  wait2_two_text(config->num_disp, config->num_player, Message,"Press Space");
  
  fade_out(config->num_disp);
}



/*
 * end of file intro.c
 */
