.\" @(#)xabacus.n 1.00 91/11/13; Copyright (c) 1991 Luis Fernandes
.TH XABACUS 1 "13 Nov 1991" "X11R4"
.SH NAME
xabacus \- abacus calculator for X

.SH SYNOPSIS
.B xabacus 
[-display \fIdisplayname\fP ] [ -demo \fIpathtoscriptfiles\fP -demofont |
-fn \fIXfontstring\fP ] [ -script ] [ -beadwidth \fIwidth\fP -beadheight 
\fIheight\fP -framewidth \fIwidth\fP -framecolor \fIcolorname\fP -bg 
\fIcolorname\fP -beadcolor \fIcolorname\fP -railcolor \fIcolorname\fP ] 

.SH DESCRIPTION
This is an implementation of the classic Chinese abacus. 

The device has two decks.
Each deck, separated by a beam, normally has 13 rods on which are mounted beads.
Each rod on the top deck contains 2 beads, and each rod on the bottom deck contains 5 beads.
Each bead on the upper deck has a value of five, while each bead on the lower deck has value of one.
Beads are considered counted, when moved \fItowards\fP the beam separating the decks.

The device has two decks ("new & improved" models have auxilliary decks stacked above the principal decks that enable multiplication, division and square-root (honest!) computations to be performed with equal ease as addition and subtraction).

.SH OPTIONS
.TP 8
-demo \fI path to script files \fP	
Use this option to interactively learn to use the abacus.
Lesson 1 teaches counting, lesson 2 teachs addition & lesson 3 teachs subtraction.
The application will ignore command-line options regarding size (beadwidth, beadheight, framewidth); all other options are acknowledged.

The script for lesson-1 is called Lesson1.cmd, lesson-2 is contained in
Lesson2.cmd and so on.

The script-files should be installed in /usr/lib/X11/xabacus.

For example:
.nf
	\fIxabacus -demo ./\fP
.fi
will instruct \fIxabacus\fP to look for the script-files in the current directory.

Similarily, the \fIXAbacus.demo\fP resource may also be used to specify the demo-path:
.nf
	\fIXAbacus.demo: ./\fP
.fi

Using this method, the \fI-demo\fP option need not be specified on the command-line.

If the script-files have been installed, then run the demo as:
.nf
	\fIxabacus -demo /usr/lib/X11/xabacus\fP
.fi


Refer to the section titled: OPERATION, for details about the demo-mode.

.TP 8
-demofont | -fn \fIXfontstring\fP
Specify an alternate font for the explanatory text that appears in the
secondary window, during the demo. The default font is 18 point Times-Roman (-*-times-*-r-*-*-*-180-*). The alternate font is 8x13. 

.TP 8
-script

Using this option, the application will log (to \fIstdout\fP ) a set of row/column coordinates according to the beads the user clicks. 

This data may be logged to a file as follows:
.nf
	\fIxabacus -script >script.log\fP
.fi

The script may then be edited and then used to generate new demos.

.TP 8
-beadwidth \fI width \fP
The width of a bead, in pixels. The default is 30.
For the sake of authenticity, the bead-width should be about 2/3 greater than the bead-height. If the bead-width is equal to the bead-height then the beads will (vaguely, even then, one has to squint) resemble circles (the screen's aspect ratio is not accounted for).

.TP 8
-beadheight \fI height \fP
The height of a bead, in pixels. The default is 20.

.TP 8
-framewidth \fI width \fP
In pixels, the width of the frame around, and separating the two decks. 
The default is 10.

.TP 8
-ncols \fI columns \fP
An integer representing the number of columns the abacus is to have, up to
a maximum of 100. The default is 13.

.TP 8
-framecolor \fI colorname \fP
A valid color-name for the frame of the abacus. Default is "brown".

.TP 8
-bg \fI colorname \fP
A valid color-name for the background. Default is "white".
Specifying a color other than the default will result in the beads having an unpredictable color. 
(This happens because the bead-image is XOR'd with the background when animating it.)

.TP 8
-bead-color \fI colorname \fP
A valid color-name for the color of the beads. Default is "green4".

.TP 8
-railcolor \fI colorname \fP
A valid color-name for the color of the rails. Default is "green4".

.TP 8
-help
Prints a summary of the command-line options.

.SH OPERATION
\fINormal Operation:\fP
The beads may be moved by clicking on them with the mouse-pointer; the beads will shift themselves to vacate the row and column that was clicked.
The abacus will beep when the mouse is clicked on an invalid location (like the middle-frame).

The abacus may be resized to accomodate more (or less, but no less than the
minimum as specified with \fI-ncols\fP) columns; it resizes in width only.
Columns are added only if the amount resized can accomodate a complete column. 
A maximum of 100 columns is possible, i.e. operations with numbers with up to
100 digits is possible.

Pressing 'q', 'Q' or '^C' will quit.

\fIDemo Mode:\fP
In this mode, the abacus is controlled by the program.
When started with the demo option, a second window is presented that should be placed directly below the abacus-window. Descriptive text, and user prompts are displayed in this window.

Pressing 'q' during the demo will quit it. Clicking the left mouse-button with
the pointer in the window will restart the demo (beginning with lesson-1).

.SH RESOURCES
.nf
The application class name is XAbacus.
Every command-line option has its equivalent X-resource as follows:

XAbacus
	.beadwidth
	.beadheight
	.framewidth
	.ncols
	.framecolor
	.bg
	.beadcolor
	.railcolor
	.demo
	.demofont
.if

.SH SEE ALSO
\fIThe Abacus: The Art of Calculation Using Beads\fP, details all the known techniques for performing additions & subtractions.

xcalc(1), xfontsel(1), xrdb(1), X(1)

.SH SCRIPT-FILE FORMAT
.nf
The format of the lesson script-file (Lesson\fIn\fP.cmd) is as follows:
<number of moves in the script>
<row> <col> <number-of-text-lines-that-follow>
text-line1
    :
    :
text-line4
<row> <col> <number-of-text-lines>
text-line1
    :
    :
text-line4
	:
	:
.fi

The text is displayed in the secondary window that appears during the demo.
\fI<number-of-text-lines-that-follow>\fP cannot exceed 4 text-lines.
Each row/col/text batch represents 1 "move".
A row beginning with a negative number signifies that the move be ignored &
that just the descriptove text be displayed. This is useful for explanatory
pauses in the lesson.
Refer to any of Lesson1.cmd, Lesson2.cmd or Lesson3.cmd.

.SH FEATURES
A cosmetic bug occurs, when certain user-defined frame-widths are specified and a top-deck bead is moved down.

Columns are added only if the amount resized can accomodate a complete column.

When the application is resized, an incremental amount that does not accomodate a full column, it loses track of the correct number of columns. 

.SH ACKNOWLEDGEMENTS
Agustine Lee, instructor at the Ryerson Electrical Engineering  Department provided a real, live abacus in addition to invaluable documentation on its use and
comments on improving it.

Nick Colonello, for alpha-testing the application and providing constructive 
criticism.

Eva Dudova, for beta-testing the application.

And to those, before me, who have written X-applications, from whose code I have learned the art of X.

.SH COPYRIGHT
Copyright 1991, Luis Fernandes.

Permission to use, copy, hack, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation. 

This software is presented as is without any implied or written warranty.

.SH AUTHOR
Luis Fernandes	(lfernand@ryelect.uucp) 
