/* d_vcvs.cc
 *$Header: /al/acs/src/RCS/d_vcvs.cc,v 9.21 95/10/21 18:09:26 al Exp $
 * functions for vcvs
 * temporary kluge: it has resistance
 */
#include "ap.h"
#include "d_vcvs.h"
#include "u_opt.h"
#include "io.h"
#include "util.h"
/*--------------------------------------------------------------------------*/
//	void	DEV_VCVS::parse(CS&);
//	void	DEV_VCVS::print(int,int)const;
//	void	DEV_VCVS::expand();
// 	int	DEV_VCVS::dotr();
// 	void	DEV_VCVS::doac();
/*--------------------------------------------------------------------------*/
void DEV_VCVS::parse(CS& cmd)
{
  parselabel(cmd);
  parsenodes(cmd,NUMNODES);
  parseexpr(cmd);
}
/*--------------------------------------------------------------------------*/
void DEV_VCVS::print(int where, int detail)const
{
  printlabel(where);
  printnodes(where,NUMNODES);
  printexpr(where);
  mputc('\n', where);
}
/*--------------------------------------------------------------------------*/
void DEV_VCVS::expand()
{
  loss = 1./OPT::shortckt;
  y0.f1 = val;
  y0.f0 = LINEAR;
  m0.f1 = -loss * val;
  m0.c0 = 0.;
  ev = val;
  acg = -loss * val;
}
/*--------------------------------------------------------------------------*/
int DEV_VCVS::dotr()
{
  if (trfun){
    trsetup();
    m0.x = volts_limited(n[IN1],n[IN2]);
    y0.x = m0.x;
    (*trfun)(this);
    m0.c0 = -loss * (y0.f0 - y0.x * y0.f1);
    m0.f1 = -loss * y0.f1;
    return converged = conv_check();
  }else if (probes){
    trsetup();
    m0.x = n[IN1].v0() - n[IN2].v0();
    y0.x = m0.x;
    y0.f0 = y0.x * y0.f1;
    assert(conchk(m0.f1, -loss*val, OPT::abstol));
    assert(m0.c0 == 0.);
    return converged = TRUE;
  }else{
    assert(conchk(m0.f1, -loss*val, OPT::abstol));
    assert(m0.c0 == 0.);
    return converged = TRUE;
  }
}
/*--------------------------------------------------------------------------*/
void DEV_VCVS::doac()
{
  acload_loss();
  if (acfun){
    acbias = n[IN1].vdc() - n[IN2].vdc();
    ev = (*acfun)(this);
    acg = -loss * ev;
  }else if (trfun){
    ev = y0.f1;
    acg = -loss * y0.f1;
  }else{
    assert(ev == val);
    //assert(acg == -loss*val);
  }
  acload_active(); 
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
