typedef struct Key Key;

typedef enum Keytype {
	Kfree, 	/* not in use */
	Klisten, 	/* ...for connection requests */
	Kout, 	/* output to stderr or a window */
	Kmsg	/* from external connections */
} Keytype; 

/* Info about a libXg event key */
struct Key {
	Keytype 	t;
	int		fd;		/* file descriptor*/
	ulong	key;		/* libXg event key */
	char		*buf;	/* alloced initially, never freed */
	int		alloced;
	int		n;

	/* info about the program associated with this key */
	int	pid;
	Path	cmd, dir;		/* command, and directory it executes in */

	/* If executing inplace ( |, <, > ) */
	View		*v;
	Bool		first;
};

enum {
	MAXKEYS =32
};

/* exec.c */
void	exec_init(void);

/* key.c */
void		keytab_init	(void);
Key*		key_new		(ulong , int , Keytype );
Key*		key_find		(ulong );
void		key_del		(Key	*);
Key*		key_findcmd	(char*);
Key*		key_nextkey		(Key *);
