#include "wily.h"
#include <dirent.h>

static int
mycmp (const void *a, const void *d)
{
	return strcmp(*(char**)a, *(char**)d);
}

/* 
 * Given 'dirp' current directory open for read, return null-terminated
 * array of strings representing the files in the directory.  Both the
 * strings and the array need to be freed later.  Returns 0 on error.
 */
char **
dirnames (DIR *dirp, char *path)
{
	struct stat		statbuf;
	struct dirent	*direntp;
	char		*name;
	char		**list;
	int		nfiles;
	int		maxnames = MAXNAMES;

	/* Read the directory into a big buffer */

	rewinddir(dirp);	/* Workaround for possible FreeBSD bug. */

	list = (char**) salloc(maxnames * sizeof(char*));

	/* temporarily chdir */
	if(chdir(path)) {
		diag(path, "couldn't chdir");
		return 0;
	}
	nfiles = 0;
	while ((direntp = readdir(dirp))) {
		name = direntp->d_name;
		if( name[0] == '.' &&  (!show_dot_files || name[1]=='\0')) {
			continue;
		}
		if (!(nfiles+2 < maxnames) ) {
			maxnames *= 2;
			list = (char**) srealloc(list, maxnames * sizeof(char*));
		}
#if 1
		if (stat(name, &statbuf)) {
			diag(path, "couldn't stat %s", name);
			statbuf.st_mode = 0;
		}
		if(S_ISDIR(statbuf.st_mode)) {
			Path	buf;

			sprintf(buf, "%s/", name);
			list[nfiles++] = strdup(buf);
		} else {
			list[nfiles++] = strdup(name);
		}
#else
		list[nfiles++] = strdup(name);
#endif
	}
	/* return to wilydir */
	if(chdir(wilydir)) {
		diag(wilydir, "couldn't chdir");
	}
	closedir(dirp);

	qsort(list, nfiles, sizeof(char*), mycmp);

	list[nfiles] = 0;
	return list;
}

/* Keep consistent with dirnames() */
void
dirnames_free(char**names)
{
	char	**s;

	if(!names)
		return;
	for(s=names; *s; s++)
		free(*s);
	free(names);
}


