;;; debian-rundir.el --- run all lisp startup files in a directory.

;; Copyright (C) 1996 Mark Eichin

;; Maintainer: Mark Eichin <eichin@kitten.gen.ma.us>
;; Keywords: debian

;; This file is part of the debian release of GNU Emacs, and will
;; be contributed to the FSF after testing. It is released under the same
;; terms, namely the GPL v2 or later.

;; GNU Emacs is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; GNU Emacs is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs; see the file COPYING.  If not, write to the
;; Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

;;; Commentary:

;; This file provides functions to process a directory full of lisp
;; files in the style of the System V "rc0.d" mechanism, namely the
;; directory contents are sorted alphabetically, and the files are
;; conventionally named 00program.el (default of 50, but allowing
;; order.)

(defun debian-run-directory (&optional dir)
  (let ((directory (if dir dir "/etc/emacs/site-start.d")))
    (mapcar 
     (lambda (f) (load f))
     (directory-files directory t "^[0-9][0-9].*\\.el$" nil))))
