/**
 *
 * $Id: CascadeBG.c,v 1.31 1996/04/22 22:54:24 miers Exp $
 *
 * Copyright (C) 1995 Free Software Foundation, Inc.
 *
 * This file is part of the GNU LessTif Library.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **/

static char rcsid[] = "$Id: CascadeBG.c,v 1.31 1996/04/22 22:54:24 miers Exp $";

/*
 * The macro below should be #undef-fed if you want menu's to work currently.
 * This prevents grabs (evil things :-)) and will make the menu system freeze less.
 *
 * Danny 5/3/96.
 */
#undef	DO_GRABS

#include <LTconfig.h>
#include <Xm/XmP.h>
#include <Xm/CacheP.h>
#include <Xm/CascadeB.h> /* For XmCascadeButtonHighlight */
#include <Xm/CascadeBGP.h>
#include <Xm/DebugUtil.h>
#include <Xm/ManagerP.h>
#include <Xm/MenuShell.h>
#include <Xm/RowColumnP.h>
#include <Xm/ScreenP.h>
#include <Xm/MenuUtilP.h>
#include <X11/Xfuncs.h>

/* Forward Declarations */

static void class_initialize();
static void class_part_initialize(WidgetClass class);
static void initialize(Widget request, Widget new, ArgList args, Cardinal *num_args);
static void destroy(Widget w);
static void expose(Widget w, XEvent *event, Region region);
static Boolean set_values(Widget current, Widget request, Widget new, ArgList args, Cardinal *num_args);
static void get_values_hook(Widget w, ArgList args, Cardinal *num_args);

static void input_dispatch(Widget gadget, XEvent *event, Mask event_mask);

static void secondary_object_create(Widget request, Widget new, ArgList args, Cardinal *num_args);
static void initialize_prehook(Widget request, Widget new, ArgList args, Cardinal *num_args);
static void initialize_posthook(Widget request, Widget new, ArgList args, Cardinal *num_args);
static Boolean set_values_prehook(Widget old, Widget request, Widget new, ArgList args, Cardinal *num_args);
static Boolean set_values_posthook(Widget old, Widget request, Widget new, ArgList args, Cardinal *num_args);
static void get_values_prehook(Widget new, ArgList args, Cardinal *num_args);
static void get_values_posthook(Widget new, ArgList args, Cardinal *num_args);
static Cardinal get_sec_res_data(WidgetClass wc, XmSecondaryResourceData **data);

/*
 * cache resources
 */
#define Offset(field) XtOffsetOf(XmCascadeButtonGCacheObjRec, cascade_button_cache.field)
static XtResource cache_resources[] = {
    {
	XmNcascadePixmap, XmCPixmap, XmRGadgetPixmap,
	sizeof(Pixmap), Offset(cascade_pixmap),
	XmRImmediate, (XtPointer)XmUNSPECIFIED_PIXMAP
    },
    {
	XmNmappingDelay, XmCMappingDelay, XmRInt,
	sizeof(int), Offset(map_delay),
	XmRImmediate, (XtPointer)180
    }
};

XmCascadeButtonGCacheObjClassRec xmCascadeButtonGCacheObjClassRec = {
    /* Object class part */
    {
	/* superclass            */ (WidgetClass) &xmLabelGCacheObjClassRec,
        /* class_name            */ "XmCascadeButtonGCacheObjClass",
	/* widget_size           */ sizeof(XmCascadeButtonGCacheObjRec),
	/* class_initialize      */ NULL,
	/* class_part_initialize */ NULL,
	/* class_inited          */ FALSE,
	/* initialize            */ NULL,
	/* initialize_hook       */ NULL,
	/* realize               */ NULL,
	/* actions               */ NULL,
	/* num_actions           */ 0,
	/* resources             */ cache_resources,
	/* num_resources         */ XtNumber(cache_resources),
	/* xrm_class             */ NULLQUARK,
	/* compress_motion       */ 0,
	/* compress_exposure     */ 0,
	/* compress_enterleave   */ 0,
	/* visible_interest      */ 0,
	/* destroy               */ NULL,
	/* resize                */ NULL,
	/* expose                */ NULL,
	/* set_values            */ NULL,
	/* set_values_hook       */ NULL,
	/* set_values_almost     */ NULL,
	/* get_values_hook       */ NULL,
	/* accept_focus          */ NULL,
	/* version               */ XtVersion,
	/* callback offsets      */ NULL,
	/* tm_table              */ NULL,
	/* query_geometry        */ NULL,
        /* display_accelerator   */ NULL,
	/* extension             */ NULL
    },
    /* XmExtObject part */
    {
        /* syn_resources      */ NULL,
        /* num_syn_resources  */ 0,
        /* extension          */ NULL
    },
    /* LabelGCacheObj part */
    {
	/* foo                */ 0
    },
    /* CascadeButtonGCacheObj part */
    {
	/* foo                */ 0
    }
};

#undef Offset
#define Offset(field) XtOffsetOf(XmCascadeButtonGadgetRec, cascade_button.field)

/* Resources for the cascadebutton class */
static XtResource resources[] = {
    {
	XmNactivateCallback, XmCCallback, XmRCallback,
	sizeof(XtCallbackList), Offset(activate_callback),
	XmRCallback, (XtPointer)NULL
    },
    {
	XmNcascadingCallback, XmCCallback, XmRCallback,
	sizeof(XtCallbackList), Offset(cascade_callback),
	XmRCallback, (XtPointer)NULL
    },
    {
	XmNsubMenuId, XmCMenuWidget, XmRMenuWidget,
	sizeof(Widget), Offset(submenu),
	XmRMenuWidget, (XtPointer)NULL
    },
    /* resources we override from XmGadget */
    {
	XmNshadowThickness, XmCShadowThickness, XmRHorizontalDimension,
	sizeof(Dimension), XtOffsetOf(XmCascadeButtonGadgetRec, gadget.shadow_thickness),
	XmRImmediate, (XtPointer)2
    },
    {
	XmNtraversalOn, XmCTraversalOn, XmRBoolean,
	sizeof(Boolean), XtOffsetOf(XmCascadeButtonGadgetRec, gadget.traversal_on),
	XmRImmediate, (XtPointer)True
    },
    {
	XmNhighlightThickness, XmCHighlightThickness, XmRHorizontalDimension,
	sizeof(Dimension), XtOffsetOf(XmCascadeButtonGadgetRec, gadget.highlight_thickness),
	XmRImmediate, (XtPointer)2
    },
};

static XmBaseClassExtRec _XmCascadeBGRectClassExtRec = {
    /* next_extension            */ NULL,
    /* record_type               */ NULLQUARK,                             
    /* version                   */ XmBaseClassExtVersion,
    /* size                      */ sizeof(XmBaseClassExtRec),
    /* initialize_prehook        */ initialize_prehook,
    /* set_values_prehook        */ set_values_prehook,
    /* initialize_posthook       */ initialize_posthook,
    /* set_values_posthook       */ set_values_posthook,
    /* secondary_object_class    */ (WidgetClass)&xmCascadeButtonGCacheObjClassRec,
    /* secondary_object_create   */ secondary_object_create,
    /* get_secondary_resources   */ get_sec_res_data,
    /* fast_subclass             */ { 0 },
    /* get_values_prehook        */ get_values_prehook,
    /* get_values_posthook       */ get_values_posthook,
    /* class_part_init_prehook   */ NULL,
    /* class_part_init_posthook  */ NULL,
    /* ext_resources             */ NULL,
    /* compiled_ext_resources    */ NULL,
    /* num_ext_resources         */ 0,
    /* use_sub_resources         */ FALSE,
    /* widget_navigable          */ XmInheritWidgetNavigable,
    /* focus_change              */ XmInheritFocusChange,
    /* wrapper_data              */ NULL
};

static XmCacheClassPart cache_part = {
    /* cache head part */
    {
        /* next         */ NULL,
        /* prev         */ NULL,
        /* ref_count    */ 0
    },
    _XmCacheCopy,
    _XmCacheDelete,
    _XmCascadeBCacheCompare
};

static XmGadgetClassExtRec _XmCascadeBGGadgetClassExtRec = {
    /* next_extension            */ NULL,
    /* record_type               */ NULLQUARK,
    /* version                   */ XmGadgetClassExtVersion,
    /* size                      */ sizeof(XmGadgetClassExtRec),
    /* widget_baseline_proc      */ NULL, /* FIXME */
    /* display_rect_proc         */ NULL, /* FIXME */
};

static void DelayedArm(Widget w, XEvent *event, String *params, Cardinal *num_params);
static void CheckDisarm(Widget w, XEvent *event, String *params, Cardinal *num_params);

XmCascadeButtonGadgetClassRec xmCascadeButtonGadgetClassRec = {
    /* RectObj class part */
    {
	/* superclass            */ (WidgetClass) &xmLabelGadgetClassRec,
	/* class_name            */ "XmCascadeButtonGadget",
	/* widget_size           */ sizeof(XmCascadeButtonGadgetRec),
	/* class_initialize      */ class_initialize,
	/* class_part_initialize */ class_part_initialize,
	/* class_inited          */ FALSE,
	/* initialize            */ initialize,
	/* initialize_hook       */ NULL,
	/* realize               */ NULL,
	/* actions               */ NULL,
	/* num_actions           */ 0,
	/* resources             */ resources,
	/* num_resources         */ XtNumber(resources),
	/* xrm_class             */ NULLQUARK,
	/* compress_motion       */ FALSE,
	/* compress_exposure     */ XtExposeCompressMaximal,
	/* compress_enterleave   */ FALSE,
 	/* visible_interest      */ FALSE,
	/* destroy               */ destroy,
	/* resize                */ XtInheritResize,
	/* expose                */ expose,
	/* set_values            */ set_values,
	/* set_values_hook       */ NULL,
	/* set_values_almost     */ XtInheritSetValuesAlmost,
	/* get_values_hook       */ get_values_hook,
	/* accept_focus          */ NULL,
	/* version               */ XtVersion,
	/* callback offsets      */ NULL,
	/* tm_table              */ NULL,
	/* query_geometry        */ XtInheritQueryGeometry,
	/* display_accelerator   */ NULL,
	/* extension             */ (XtPointer)&_XmCascadeBGRectClassExtRec
    },
    /* XmGadget part */
    {
	/* border_highlight   */ XmInheritBorderHighlight, 
	/* border_unhighlight */ XmInheritBorderUnhighlight, /* fix me */
	/* arm_and_activate   */ NULL, /* fix me */
	/* input_dispatch     */ input_dispatch,
	/* visual_change      */ NULL, /* fix me */
	/* syn_resources      */ NULL,
	/* num_syn_resources  */ 0,
	/* cache_part         */ &cache_part,
	/* extension          */ (XtPointer)&_XmCascadeBGGadgetClassExtRec
    },
    /* XmLabelGadget part */
    {
        /* setOverrideCallback */ NULL, /* fix me */
        /* menuProcs           */ NULL, /* fix me */
	/* extension           */ NULL
    },
    /* XmCascadeButtonGadget part */
    {
	/* extension */ NULL
    },
};

WidgetClass xmCascadeButtonGadgetClass = (WidgetClass)&xmCascadeButtonGadgetClassRec;

/********************************* CACHE PART *******************************/
static void
secondary_object_create(Widget request,
	   Widget new,
	   ArgList args,
	   Cardinal *num_args)
{
    XmBaseClassExt *bce;
    XtPointer nsec, rsec;
    XmWidgetExtData ed;
    int size;

    XdbDebug(__FILE__, new, "CascadeButtonGCacheRec %s being initialized.\n",
	     XtName(new));

    bce = _XmGetBaseClassExtPtr(XtClass(new), XmQmotif);

    size = (*bce)->secondaryObjectClass->core_class.widget_size;
    nsec = _XmExtObjAlloc(size);
    rsec = _XmExtObjAlloc(size);

    ((XmExtRec *)nsec)->object.self = (Widget)nsec;
    ((XmExtRec *)nsec)->object.widget_class = (*bce)->secondaryObjectClass;
    ((XmExtRec *)nsec)->object.parent = XtParent(new);
    ((XmExtRec *)nsec)->object.xrm_name = new->core.xrm_name;
    ((XmExtRec *)nsec)->object.being_destroyed = False;
    ((XmExtRec *)nsec)->object.destroy_callbacks = NULL;
    ((XmExtRec *)nsec)->object.constraints = NULL;

    ExtObj_LogicalParent(nsec) = new;
    ExtObj_ExtensionType(nsec) = XmCACHE_EXTENSION;

    XtGetSubresources(new, nsec, NULL, NULL,
                      (*bce)->secondaryObjectClass->core_class.resources,
                      (*bce)->secondaryObjectClass->core_class.num_resources,
                      args, *num_args);

    ed = (XmWidgetExtData)XtMalloc(sizeof(XmWidgetExtDataRec));
    ed->widget = (Widget)nsec;
    ed->reqWidget = (Widget)rsec;

    bcopy(nsec, rsec, size);
    ((XmExtRec *)rsec)->object.self = (Widget)rsec;

    _XmPushWidgetExtData(new, ed, XmCACHE_EXTENSION);

    LabG_Cache(new) = &(((XmLabelGCacheObject)nsec)->label_cache);
    LabG_Cache(request) = &(((XmLabelGCacheObject)rsec)->label_cache);

    CBG_Cache(new) =
	&(((XmCascadeButtonGCacheObject)nsec)->cascade_button_cache);
    CBG_Cache(request) =
	&(((XmCascadeButtonGCacheObject)rsec)->cascade_button_cache);
}

int
_XmCascadeBCacheCompare(XtPointer A, XtPointer B)
{
    return !memcmp(((XmCascadeButtonGCacheObjPart *)A),
		   ((XmCascadeButtonGCacheObjPart *)B),
		   sizeof(XmCascadeButtonGCacheObjPart));
}

int
_XmArrowPixmapCacheCompare(XtPointer A, XtPointer B)
{
    return 0;
}

void
_XmArrowPixmapCacheDelete(XtPointer data)
{
}

void
_XmCreateArrowPixmaps(Widget wid)
{
}

/******************************** GADGET PART *******************************/
static void
class_initialize()
{
    XtResourceList combined, labels;
    int ncom;
    Cardinal nlabels;

    /* don't let the nulls fool you.  look at the header file -- the arg
     * isn't used. */
    ClassCacheHead(CBG_ClassCachePart(NULL)).prev =
	&ClassCacheHead(CBG_ClassCachePart(NULL));
    ClassCacheHead(CBG_ClassCachePart(NULL)).next =
	&ClassCacheHead(CBG_ClassCachePart(NULL));

    _XmCascadeBGRectClassExtRec.record_type = XmQmotif;

    /*
     * Label subclasses (ToggleBG, PushBG, CascadeBG) have a problem.  Since
     * we do all the subpart manipulation in the pre- and post- hooks, and
     * since those hooks aren't chained, we have to either make multiple
     * calls to XtGetSubresources/Xt[Get|Set]Subvalues, or merge the resource
     * lists.  Since I just wrote _XmTransformSubresources, seems like a
     * waste not to use it.
     */
    ncom = XtNumber(cache_resources) +
           xmLabelGCacheObjClassRec.object_class.num_resources;

    _XmTransformSubResources(xmLabelGCacheObjClassRec.object_class.resources,
                             xmLabelGCacheObjClassRec.object_class.num_resources,
                             &labels, &nlabels);

    combined = (XtResourceList)XtMalloc(sizeof(XtResource) * ncom);
    bcopy(labels, combined, nlabels * sizeof(XtResource));
    bcopy(cache_resources,
          &combined[nlabels],
          XtNumber(cache_resources) * sizeof(XtResource));
    XtFree((char *)labels);

    xmCascadeButtonGCacheObjClassRec.object_class.resources = combined;
    xmCascadeButtonGCacheObjClassRec.object_class.num_resources = ncom;
}

static void
class_part_initialize(WidgetClass widget_class)
{
    _XmFastSubclassInit(widget_class, XmCASCADE_BUTTON_GADGET_BIT);
}

static void
initialize_prehook(Widget request,
           Widget new,
           ArgList args,
           Cardinal *num_args)
{
    XdbDebug(__FILE__, new, "CascadeBG InitializePrehook\n");
}

static void
initialize_posthook(Widget request,
           Widget new,
           ArgList args,
           Cardinal *num_args)
{
    XmWidgetExtData ext;

    XdbDebug(__FILE__, new, "CascadeBG InitializePosthook\n");

    /* don't let the null fool you */
    LabG_Cache(new) = _XmCachePart(LabG_ClassCachePart(NULL),
                                   (XtPointer)LabG_Cache(new),
                                   sizeof(XmLabelGCacheObjPart));
    CBG_Cache(new) = _XmCachePart(CBG_ClassCachePart(NULL),
                                  (XtPointer)CBG_Cache(new),
                                  sizeof(XmCascadeButtonGCacheObjPart));

    _XmPopWidgetExtData(new, &ext, XmCACHE_EXTENSION);
    _XmExtObjFree((XtPointer)ext->widget);
    _XmExtObjFree((XtPointer)ext->reqWidget);
    XtFree((char *)ext);
}

static void
initialize(Widget request,
	   Widget new,
	   ArgList args,
	   Cardinal *num_args)
{
    Widget rc;

    if (! XmIsManager(XtParent(new)))
	_XmError(new, "parent should be manager.");

    CBG_SetArmed(new, False);

    rc = XtParent(new);

    if (!XmIsRowColumn(rc))
	_XmError(new, "Cascade gadget parent must be a RowColumn.");

    if (RC_Type(rc) != XmMENU_BAR      && RC_Type(rc) != XmMENU_POPUP &&
	RC_Type(rc) != XmMENU_PULLDOWN && RC_Type(rc) != XmMENU_OPTION)
	_XmError(new, "Cascade gadget parent is incorrect type.");

    LabG_Highlight(new) = 0;

    CBG_Timer(new) = 0;

    G_EventMask(new) = XmARM_EVENT | XmACTIVATE_EVENT |
			XmENTER_EVENT | XmLEAVE_EVENT |
			XmFOCUS_IN_EVENT | XmFOCUS_OUT_EVENT;

}

static void
destroy(Widget w)
{
    _XmCacheDelete(CBG_Cache(w));
}

static Boolean
set_values_prehook(Widget old,
                   Widget request,
                   Widget new,
                   ArgList args,
                   Cardinal *num_args)
{
    XmBaseClassExt *bce;
    XmWidgetExtData ed;
    int size;
    XtPointer nsec, rsec;

    bce = _XmGetBaseClassExtPtr(XtClass(new), XmQmotif);
    size = (*bce)->secondaryObjectClass->core_class.widget_size;

    nsec = _XmExtObjAlloc(size);
    rsec = _XmExtObjAlloc(size);

    ((XmExtRec *)nsec)->object.self = (Widget)nsec;
    ((XmExtRec *)nsec)->object.widget_class = (*bce)->secondaryObjectClass;
    ((XmExtRec *)nsec)->object.parent = XtParent(new);
    ((XmExtRec *)nsec)->object.xrm_name = new->core.xrm_name;
    ((XmExtRec *)nsec)->object.being_destroyed = False;
    ((XmExtRec *)nsec)->object.destroy_callbacks = NULL;
    ((XmExtRec *)nsec)->object.constraints = NULL;

    ExtObj_LogicalParent(nsec) = new;
    ExtObj_ExtensionType(nsec) = XmCACHE_EXTENSION;

    bcopy(LabG_Cache(new),
          &((XmLabelGCacheObject)nsec)->label_cache,
          sizeof(XmLabelGCacheObjPart));
    bcopy(CBG_Cache(new),
          &((XmCascadeButtonGCacheObject)nsec)->cascade_button_cache,
          sizeof(XmCascadeButtonGCacheObjPart));

    ed = (XmWidgetExtData)XtMalloc(sizeof(XmWidgetExtDataRec));
    ed->widget = (Widget)nsec;
    ed->reqWidget = (Widget)rsec;

    _XmPushWidgetExtData(new, ed, XmCACHE_EXTENSION);

    _XmGadgetImportSecondaryArgs(new, args, num_args);

    XtSetSubvalues((XtPointer)nsec,
                    (*bce)->secondaryObjectClass->core_class.resources,
                    (*bce)->secondaryObjectClass->core_class.num_resources,
                    args, *num_args);

    bcopy(nsec, rsec, size);

    LabG_Cache(new) = &(((XmCascadeButtonGCacheObject)nsec)->label_cache);
    LabG_Cache(request) = &(((XmCascadeButtonGCacheObject)rsec)->label_cache);
    CBG_Cache(new) =
	&(((XmCascadeButtonGCacheObject)nsec)->cascade_button_cache);
    CBG_Cache(request) =
	&(((XmCascadeButtonGCacheObject)rsec)->cascade_button_cache);

    _XmExtImportArgs((Widget)nsec, args, num_args);

    return FALSE;
}

static Boolean
set_values_posthook(Widget old,
                   Widget request,
                   Widget new,
                   ArgList args,
                   Cardinal *num_args)
{
    XmWidgetExtData ext;

    if (!_XmLabelCacheCompare(LabG_Cache(new), LabG_Cache(old))) {

	_XmCacheDelete((XtPointer)LabG_Cache(old));

	LabG_Cache(new) = _XmCachePart(LabG_ClassCachePart(NULL),
				       (XtPointer)LabG_Cache(new),
				       sizeof(XmLabelGCacheObjPart));
    }
    else
	LabG_Cache(new) = LabG_Cache(old);

    if (!_XmCascadeBCacheCompare(CBG_Cache(new), CBG_Cache(old))) {

	_XmCacheDelete((XtPointer)CBG_Cache(old));

	CBG_Cache(new) = _XmCachePart(CBG_ClassCachePart(NULL),
				      (XtPointer)CBG_Cache(new),
				      sizeof(XmCascadeButtonGCacheObjPart));
    }
    else
	CBG_Cache(new) = CBG_Cache(old);

    _XmPopWidgetExtData(new, &ext, XmCACHE_EXTENSION);

    _XmExtObjFree((XtPointer)ext->widget);
    _XmExtObjFree((XtPointer)ext->reqWidget);

    XtFree( (char *) ext);

    return FALSE;
}

static Boolean
set_values(Widget old,
	   Widget request,
	   Widget new,
	   ArgList args,
	   Cardinal *num_args)
{
    Boolean refresh_needed = False;

    XdbDebug(__FILE__, new, "set_values()\n");

    if (CBG_CascadePixmap(old) != CBG_CascadePixmap(new))
    {
        _XmFreeScratchPixmap((XmScreen)XmGetXmScreen(XtScreenOfObject(old)), CBG_CascadePixmap(old));
        _XmFreeScratchPixmap((XmScreen)XmGetXmScreen(XtScreenOfObject(old)), CBG_ArmedPixmap(old));
#if 0
        _XmCascadeButtonCreateCascadePixmap(new);
        _XmCascadeButtonCreateArmedPixmap(new);
#endif
	refresh_needed = True;
    }

    return refresh_needed;
}

static void
get_values_prehook(Widget new, ArgList args, Cardinal *num_args)
{
    XmBaseClassExt *bce;
    XmWidgetExtData ed;
    int size;
    XtPointer nsec;

    bce = _XmGetBaseClassExtPtr(XtClass(new), XmQmotif);
    size = (*bce)->secondaryObjectClass->core_class.widget_size;

    nsec = _XmExtObjAlloc(size);

    bcopy(LabG_Cache(new),
          &((XmLabelGCacheObject)nsec)->label_cache,
          sizeof(XmLabelGCacheObjPart));
    bcopy(CBG_Cache(new),
          &((XmCascadeButtonGCacheObject)nsec)->cascade_button_cache,
          sizeof(XmCascadeButtonGCacheObjPart));

    /*
     * don't do this and ResInd will blow up.
     */
    ((XmExtRec *)nsec)->object.self = (Widget)nsec;
    ((XmExtRec *)nsec)->object.widget_class = (*bce)->secondaryObjectClass;
    ((XmExtRec *)nsec)->object.parent = XtParent(new);
    ((XmExtRec *)nsec)->object.xrm_name = new->core.xrm_name;
    ((XmExtRec *)nsec)->object.being_destroyed = False;
    ((XmExtRec *)nsec)->object.destroy_callbacks = NULL;
    ((XmExtRec *)nsec)->object.constraints = NULL;

    ExtObj_LogicalParent(nsec) = new;
    ExtObj_ExtensionType(nsec) = XmCACHE_EXTENSION;

    ed = (XmWidgetExtData)XtMalloc(sizeof(XmWidgetExtDataRec));
    ed->widget = (Widget)nsec;

    _XmPushWidgetExtData(new, ed, XmCACHE_EXTENSION);

    XtGetSubvalues((XtPointer)nsec,
                    (*bce)->secondaryObjectClass->core_class.resources,
                    (*bce)->secondaryObjectClass->core_class.num_resources,
                    args, *num_args);

    _XmExtGetValuesHook((Widget)nsec, args, num_args);
}

static void
get_values_posthook(Widget new, ArgList args, Cardinal *num_args)
{
     XmWidgetExtData ext;

     _XmPopWidgetExtData(new, &ext, XmCACHE_EXTENSION);

     _XmExtObjFree((XtPointer)ext->widget);

     XtFree( (char *) ext);
}


static void
get_values_hook(Widget w, ArgList args, Cardinal *num_args)
{
    XdbDebug(__FILE__, w, "get_values_hook()\n");
}

static void
expose(Widget w,
       XEvent *event,
       Region region)
{
#define superclass (&xmLabelGadgetClassRec)
    (*superclass->rect_class.expose)(w, event, region);
#undef superclass

    XdbDebug(__FILE__, w, "expose() Armed(%d)\n", CBG_IsArmed(w));

    if (CBG_IsArmed(w) || LabG_MenuType(w) == XmMENU_OPTION)
	XmCascadeButtonHighlight(w, True);
    else
	XmCascadeButtonHighlight(w, False);
}

static Cardinal
get_sec_res_data(WidgetClass wc, XmSecondaryResourceData **data)
{
    /* FIXME */

    return _XmSecondaryResourceData(&_XmCascadeBGRectClassExtRec,
                                    data, NULL, NULL, NULL, NULL);
}

static void
MenuBarSelect(Widget w,
	      XEvent *event,
	      String *params,
	      Cardinal *num_params)
{    
    Window window_return;
    int revert_to_return;

    XdbDebug(__FILE__, w, "MenuBarSelect()\n");

    /* first off, pop down any menus that are already up */

#ifdef	DO_GRABS
    XdbDebug(__FILE__, w, "Doing XAllowEvents\n");
    XAllowEvents(XtDisplay(w), SyncPointer, CurrentTime);

    /* grab everything to freeze things so we can find out some stuff from
       the server. */
    _XmGrabKeyboard(XtParent(w), True,
		    GrabModeSync,
		    GrabModeSync,
		    CurrentTime);
#endif

    /* get the window that previously had the focus
       before popping up the menu so we can revert 
       to it after we're done. */
    XdbDebug(__FILE__, w, "Doing XGetInputFocus\n");
    XGetInputFocus(XtDisplay(w),
		   &window_return,
		   &revert_to_return);
    
    /* Now we set the focus to us, so that we'll arm ourselves and
       drop down our menu immediately. FIX ME -- this may take place
       in the RowColumn so that it can handle it for gadgets. */
    XdbDebug(__FILE__, w, "Doing XSetInputFocus\n");
    XSetInputFocus(XtDisplay(w),
		   XtWindow(w),
		   RevertToParent,
		   CurrentTime);

#ifdef	DO_GRABS
    /* Now we ungrab everything (well almost everything) */
    XdbDebug(__FILE__, w, "Doing XAllowEvents\n");
    XAllowEvents(XtDisplay(w), 
		 AsyncKeyboard,
		 CurrentTime);
#endif

    XmCascadeButtonHighlight(w, True);

    CBG_SetArmed(w, True);

    if (CBG_Submenu(w) && XmIsMenuShell(XtParent(CBG_Submenu(w))))
    {
	Position my_x, my_y;

	/* Register inside the RC that this cascadebutton is the one that triggered the menu */
	XmRowColumnWidget	rc = (XmRowColumnWidget)CBG_Submenu(w);
	rc->row_column.cascadeBtn = w;

	/* make sure the menu is popped down */
	XtUnmapWidget(XtParent(CBG_Submenu(w)));

	/* position the row column inside the menushell*/
	XtMoveWidget(CBG_Submenu(w),
		     0,0);

	/* now move the menushell */
	XtTranslateCoords(w, 0, 0, &my_x, &my_y);

	XtMoveWidget(XtParent(CBG_Submenu(w)),
		     my_x,
		     my_y + XtHeight(w));

	XtCallCallbackList(w,
			   CBG_CascadeCall(w),
			   NULL);

	RC_CascadeBtn(CBG_Submenu(w)) = w;
	RC_PopupPosted(XtParent(w)) = XtParent(CBG_Submenu(w));

	XtPopup(XtParent(CBG_Submenu(w)), XtGrabNonexclusive);

#ifdef	DO_GRABS
/* This was in CascadeB.c but not here ... Danny 19/3/1996 */
	XdbDebug(__FILE__, w, "Doing XtAddGrab(menu-bar)\n");
	XtAddGrab(XtParent(w), True, False);
/* End copy */
#endif

	XtMapWidget(CBG_Submenu(w));

#ifdef	DO_GRABS
	_XmGrabPointer(w, True,
		       ButtonPressMask | ButtonReleaseMask | EnterWindowMask | LeaveWindowMask,
		       GrabModeSync,
		       GrabModeAsync,
		       None,
		       None,
		       CurrentTime);
#endif

	_XmSetInDragMode(w, True);

	XSetInputFocus(XtDisplay(CBG_Submenu(w)),
		       XtWindow(CBG_Submenu(w)),
		       RevertToParent,
		       CurrentTime);

#ifdef	DO_GRABS
	XAllowEvents(XtDisplay(w), SyncPointer, CurrentTime);
#endif
    }
    else
    {
	XdbDebug(__FILE__, w, "Ungrabbing keyboard\n");
	_XmUngrabKeyboard(XtParent(w), CurrentTime);
	_XmWarning(w,
                   "CascadeButton's popup must be a subclass of XmMenuShell\n");
        return;
    }
}

static void
StartDrag(Widget w,
	  XEvent *event,
	  String *params,
	  Cardinal *num_params)
{
    XmCascadeButtonGadget cw = (XmCascadeButtonGadget) w;

    XdbDebug(__FILE__, w, "StartDrag()\n");

    /* Arm the cascade button, post the submenu, and enable mouse
       traversal on it. */

    /* If the submenu is already active, disable keyboard traversal
       and set it to mouse traversal */

    if (XmIsMenuShell(XtParent(CBG_Submenu(cw))))
    {
	Position my_x, my_y;

	XtTranslateCoords(w, 0, 0, &my_x, &my_y);

	XtMoveWidget(XtParent(CBG_Submenu(cw)),
                     my_x + XtWidth(w) - LabG_Shadow(cw),
                     my_y);

	XtCallCallbackList(w,
			   CBG_CascadeCall(w),
			   NULL);

	XtPopup(XtParent(CBG_Submenu(cw)), XtGrabNonexclusive);
    }
    else
    {
	_XmWarning(w, 
                   "CascadeButton's popup must be a subclass of XmMenuShell\n");
        return;
    }

    CBG_SetArmed(cw, True);

    expose(w, NULL, (Region)NULL);
}

static void 
CascadePopupHandler(XtPointer clientData, XtIntervalId *id)
{
    Widget w = (Widget)clientData;

    CBG_Timer(w) = 0;

    if (CBG_Submenu(w) && XmIsMenuShell(XtParent(CBG_Submenu(w))))
    {
	Position my_x, my_y;
	
	/* make sure the menu is popped down */

/* This seems to have problems */	
/*	XtUnmapWidget(CBG_Submenu(w));*/
	
	/* position the row column inside the menushell*/
	XtMoveWidget(CBG_Submenu(w),
		     0,0);

	/* now move the menushell */
	XtTranslateCoords(w, 0, 0, &my_x, &my_y);
	XtMoveWidget(XtParent(CBG_Submenu(w)),
                     my_x + XtWidth(w) - LabG_Shadow(w),
                     my_y);

	XtCallCallbackList(w,
			   CBG_CascadeCall(w),
			   NULL);

	RC_CascadeBtn(CBG_Submenu(w)) = w;
	RC_PopupPosted(XtParent(w)) = XtParent(CBG_Submenu(w));

	XtPopup(XtParent(CBG_Submenu(w)), XtGrabNonexclusive);

	XtMapWidget(CBG_Submenu(w));
    }
    else if (CBG_Submenu(w))
    {
	_XmWarning(w,
                   "CascadeButton's popup must be a subclass of XmMenuShell\n");
        return;
    }
}

static void 
DelayedArm(Widget w, 
           XEvent *event, 
           String *params, 
           Cardinal *num_params)
{
    XdbDebug(__FILE__, w, "DelayedArm()\n");

    XAllowEvents(XtDisplay(w), SyncPointer, CurrentTime);

    if (_XmGetInDragMode(w)) 
    {
	CBG_Timer(w) = XtAppAddTimeOut(XtWidgetToApplicationContext(w),
				       CBG_MapDelay(w),
				       CascadePopupHandler,
				       (XtPointer)w);

	XmCascadeButtonHighlight(w, True);
	
	CBG_SetArmed(w, True);

	MGR_SelectedGadget(XtParent(w)) = (XmGadget)w;
    }
}

static void 
CheckDisarm(Widget w, 
	    XEvent *event, 
	    String *params, 
	    Cardinal *num_params)
{
    XdbDebug(__FILE__, w, "CheckDisarm()\n");

    if (_XmGetInDragMode(w)) 
    {
	if (CBG_Timer(w))
	{
	    XtRemoveTimeOut(CBG_Timer(w));
	    CBG_Timer(w) = 0;
	}

	XmCascadeButtonHighlight(w, False);
	
	CBG_SetArmed(w, False);
    }
}

static void 
input_dispatch(Widget gadget, 
	       XEvent *event, 
	       Mask event_mask)
{
    switch (event_mask)
    {
    case XmARM_EVENT:
	if (LabG_MenuType(gadget) == XmMENU_BAR)
	    MenuBarSelect(gadget, event, NULL, NULL);
	else
	    StartDrag(gadget, event, NULL, NULL);
	break;
    case XmACTIVATE_EVENT:
	if (LabG_MenuType(gadget) == XmMENU_BAR)
	    MenuBarSelect(gadget, event, NULL, NULL);
	else
	    StartDrag(gadget, event, NULL, NULL);
	break;
    case XmENTER_EVENT:
	if (LabG_MenuType(gadget) == XmMENU_PULLDOWN)
	    DelayedArm(gadget, event, NULL, NULL);
	break;
    case XmLEAVE_EVENT:
	if (LabG_MenuType(gadget) == XmMENU_PULLDOWN)
	    CheckDisarm(gadget, event, NULL, NULL);
    case XmFOCUS_IN_EVENT:
	_XmFocusInGadget(gadget, event, NULL, NULL);
	break;
    case XmFOCUS_OUT_EVENT:
	_XmFocusOutGadget(gadget, event, NULL, NULL);
	break;
    }
}

Widget
XmCreateCascadeButtonGadget(Widget parent,
		    char *name,
		    Arg *arglist,
		    Cardinal argcount)
{
    return XtCreateWidget(name,
			  xmCascadeButtonGadgetClass,
			  parent,
			  arglist,
			  argcount);
}
