/*
 * record.c
 *
 * This command records voice data from the voice modem and
 * saves them in the given file.
 *
 */

#include "../include/voice.h"

char *libvoice_record_c = "$Id: record.c,v 1.3 1996/07/25 19:23:26 marc Exp $";

int voice_record_file (char *name)
     {
     int fd;
     int result;
     rmd_header header;

     lprintf(L_MESG, "recording voice file %s", name);

     fd = creat(name, 0666);

     if (fd < 0)
          {
          lprintf(L_ERROR, "%s: Could not open voice file", program_name);
          return(FAIL);
          };

     if (!cvd.raw_data.d.i)
          {
          memset(&header, 0x00, sizeof(rmd_header));
          sprintf(header.magic, "%s", "RMD1");
          sprintf(header.voice_modem_type, "%s", voice_modem_type);
          header.compression = htons(cvd.rec_compression.d.i);

          if (write(fd, &header, sizeof(rmd_header)) != sizeof(rmd_header))
               {
               lprintf(L_ERROR, "%s: Could not write header", program_name);
               return(FAIL);
               };

          };

     if (voice_modem_handle_event(VOICE_SET_COMPRESSION,
      (event_data) cvd.rec_compression.d.i) != OK)
          {
          lprintf(L_ERROR, "%s: Illeagal compression type %d", program_name,
           cvd.rec_compression.d.i);
          result = FAIL;
          }
     else
          {
          alarm(cvd.rec_max_len.d.i);
          result = voice_modem_handle_event(VOICE_RECORD_FILE,
           (event_data) fd);
          alarm(0);
          };

     close(fd);
     return(result);
     };
