/* The code should compile with either ANSI C or K&R compilers. */

/*
 *      Copyright (c) 1995 by William Deich.
 *      Written by William Deich.  Not derived from licensed software.

 *    You may distribute under the terms of either the GNU General Public
 *    License or the Artistic License, as specified in the README file.
 */

/* Use __P() to have prototypes in STD C code, and not use
 * prototypes in K&R C: declare functions as:
 *	func_type  funcname __P((arglist));
 */
#ifdef __STDC__
#define __P(x) x
#else
#define __P(x) ()
#endif

#ifdef __STDC__
#ifndef HAVE_LOCALE
#define HAVE_LOCALE
#endif
#ifndef HAVE_LOCALTIME
#define HAVE_LOCALTIME
#endif
#endif

#ifdef SUNOS5_4
#ifndef SUNOS5
#define SUNOS5
#endif
#endif

#ifdef SUNOS5
#ifndef SVR4
#define SVR4
#endif
#endif


/* Don't define _XOPEN_SOURCE for SCO: although it uses this for compliance
 * reasons, this define causes some problems with password file negotiation.
 *
 * Also don't define it for Solaris 2.4 (SunOS 5.4) and higher: it causes
 * problems for things like struct timespec, which doesn't get defined if
 * _XOPEN_SOURCE is set (instead struct _timespec is defined), but stat.h
 * uses struct timespec in its definition of itimerval.  It's a mess...
 */
#ifndef _SVR4_SOURCE
#ifndef SCO
#ifndef SUNOS5_4
#define  _XOPEN_SOURCE
#endif
#endif
#endif

#ifdef Digital_UNIX
#define _OSF_SOURCE
#include <standards.h>
#include <signal.h>
#endif

#include <stdio.h>
#include <ctype.h>
#include <errno.h>
#include <fcntl.h>
#include <string.h>
#include <sys/types.h>

#ifdef __STDC__
#include <locale.h>
#else
#ifdef HAVE_LOCALE
#include <locale.h>
#endif
#endif

#ifdef __clix__
#include <sys/signal.h>
#ifdef _NSIG
#define NSIG _NSIG
#endif
#else
#include <signal.h>
#endif

#include <sys/wait.h>
#include <sys/param.h>

#include <sys/stat.h>
#ifndef S_IWGRP
#define S_IWGRP 0000020
#endif
#ifndef S_IWOTH
#define S_IWOTH 0000002
#endif

#include <pwd.h>
#include <grp.h>
#include <unistd.h>

#ifdef SCO
#include <limits.h>
#include <sys/signal.h>
#include <shadow.h>
#include <malloc.h>
#endif

#ifdef _SVR4_SOURCE
#undef NSIG
#define NSIG _sys_nsig
#endif

#ifdef __STDC__
#include <stdlib.h>
#else
#include <malloc.h>
#endif

#ifdef SVR4
#include <shadow.h>
#include <sys/time.h>
#include <sys/systeminfo.h>
extern int sysinfo();
#define gethostname(buf, lbuf) (sysinfo(SI_HOSTNAME, (buf), (lbuf)))
#undef NSIG
#define NSIG _sys_nsig
#else
#ifndef Digital_UNIX
extern int gethostname __P((char *, size_t size));
#endif
#include <time.h>
#endif

#ifdef USE_GETHOSTBYNAME
#include <netdb.h>
#endif

#ifdef USE_SYSLOG
#include <syslog.h>
#endif


#ifdef _POSIX_PATH_MAX
#undef MAXPATHLEN
#define MAXPATHLEN _POSIX_PATH_MAX
#else
#ifndef MAXPATHLEN
#define MAXPATHLEN 255
#endif
#endif

#ifdef __STDC__
    typedef pid_t PID_T;
    typedef uid_t UID_T;
    typedef gid_t GID_T;
#else
    typedef int PID_T;
    typedef int UID_T;
    typedef int GID_T;
#endif

/* type returned by setgrent() */
#ifdef Digital_UNIX
typedef int SETGRENT_T;
#else
typedef void SETGRENT_T;
#endif

/* ==================================================================== */

#include "hsearch.h"
#include "version.h"

/* ==================================================================== */

#define SEP	" \t\v\n"		/* How to split fields on input lines */
#define QM	"\"'"			/* Quotemarks in fields */
#define CM	"#"			/* Comments in input file */
#define SAFE_IFS "IFS= \t\n"
#define OPTION_SEP '='			/* option separator */
#define CONDITION_SEP '~'		/* condition separator */

#define CLEAR_SETTINGS NULL

#ifndef SAFE_PATH
#define SAFE_PATH "PATH=/bin:/usr/bin:/usr/ucb"
#endif

/* The name under this program assumes it is installed.  If argv[0] isn't
 * [/.../]ONETRUENAME, we assume we're running via symlink.
 */
#ifndef ONETRUENAME
#define ONETRUENAME "super"
#endif

/* Kind of help we give */
#define HELP_BASIC	0	/* Basic help shows what you can execute */
#define HELP_FULL	1	/* Full help on each command */
#define HELP_FACTS	2	/* Just-the-facts-ma'm mode */

#ifndef SUPERFILE
#define SUPERFILE "/usr/local/lib/super.tab"
#endif

#ifndef TIMESTAMP_DIR
#define TIMESTAMP_DIR "/usr/local/lib/superstamps"
#endif

#ifndef MAXFD
int getdtablesize __P(( void ));
#define MAXFD (getdtablesize()-1)
#endif

#ifndef MAXHOSTNAMELEN
#define MAXHOSTNAMELEN 256
#endif

/* MAXSETENV is maximum number of variables that can be setenv'd on a
 * super control line.  This isn't the maximum that can be passed; it's
 * only the number of environment variables definitions that can be
 * made on one control line.
 */
#define MAXSETENV 40

/* If defined, then user patterns are allowed to match the uid as well as
 * the actual username.  We DISABLE this by default because users are
 * almost always identified by username.
 */
/* #define MATCH_DECIMAL_UID */

/* If defined, then group patterns are allowed to match the
 * gid as well as the group name, if any.  We ENABLE this by default
 * because it's not unusual for users to be put into unnamed groups
 * in the password file.
 */
#define MATCH_DECIMAL_GID

/* maximum number of tries at entering the password */
#define MAXTRY 3


#ifdef USE_NETGROUP
extern int innetgr();
#endif

#ifdef NEED_MEMSET
void *memset __P(( void *s, int c, size_t n ));
#endif

extern char *prog;			/* this program */
extern int debug;
extern int check_syntax;		/* just check syntax of superfile */

extern char *superfile;			/* The actual superfile to be opened. */

struct simpleList {
    char *pat;
    struct simpleList *next;
};
typedef struct simpleList SimpleList;

struct simple2List {
    char *pat;
    struct simpleList *other;
    struct simple2List *next;
};
typedef struct simple2List Simple2List;

struct timeEnt {
    short begin;	/* Start time, in minutes */
    short end;		/* End time, in minutes */
    char day;		/* day of week to match (0..6); 7 means any day */
    char invert;	/* match is to be inverted */
};
typedef struct timeEnt TimeEnt;

struct timeList {
    TimeEnt te;
    struct timeList *next;
};
typedef struct timeList TimeList;

/* Linked open files */
struct fileList {
    char *givenname;	/* filename, as given in the parent file */
    char *fullname;	/* filename, fully expanded */
    FILE *fp;
    int line;		/* current line */
    int nl;		/* number of lines in this block */
    struct fileList *prev;
};
typedef struct fileList FileList;

struct countedString {
    char *s;		/* malloc'd string */
    int n;		/* number of characters in s */
    unsigned char used;	/* !0 means this string is in use */
};
typedef struct countedString CountedString;

struct strArray {
    CountedString *str;	/* Pts to malloc'd array of CountedString's */
    int n;		/* number strings allocated */
};
typedef struct strArray StrArray;

struct ourTime {
    time_t start;	/* when program started */
    short min;		/* local time of day, in minutes */
    char day;		/* local day, with 0=sunday */
};	
typedef struct ourTime OurTime;

struct conditions {
    int user;		/* !0 -> Last match to a user pattern */
    int time;		/* !0 -> Matched a time pattern */
    int allinverted;	/* !0 -> all time patterns scanned were inverted */
};
typedef struct conditions Conditions;

/* Password information */
struct passInfo {
    int required;	/* -1 means not in use */
    int timeout;	/* Time before password must be re-entered */
    int renewtime;	/* update the timestamp file with each use of cmd? */
    int perhost;	/* create timestamp files separately for each host? */
    char user[1024];	/* value of timestampuid=xxx, if entered */
};
typedef struct passInfo PassInfo;

/* Information for logging use */
struct logInfo {
    FILE *fp;			/* logfile pointer */
    char filename[1024];	/* logfile name */
    char user[1024];		/* value of loguid=xxx, if entered */
    UID_T uid;			/* UID under which we open logfile */
};
typedef struct logInfo LogInfo;

/* The progList struct is for listing all Cmd::File pairs on a control line. */
struct progList {
    char *Cmd;
    char *File;
};
typedef struct progList ProgList;

/* progMatch is for keeping track of matches in a ProgList */
struct progMatch {
    ProgList *cmd_file;
    int match;	/* index in proglist of matched command; -1 if no match */
    int evermatched;	/* 0 if no cmd in file matched pat */
    char *commandfound;	/* If match >= 0, commandfound points to actual
			 * command matched.  This can differ from
			 * proglist.Cmd[match], because that Cmd can be
			 * a pattern.
			 */
    int n;
    int nalloc;
};
typedef struct progMatch ProgMatch;

/* Global information from the :global lines */
struct globalInfo {
    char owner[32];	/* File owner must be this person; overridden
			 * by local owner=xxx option, if present.
			 */
    int relative_path;	/* Allow filenames to be relative.  This is
			 * in general a stupid idea.  Don't do it!
			 */
    int group_slash;	/* Allow group names to have slashes.  If you
			 * allow this, you make it harder to catch certain
			 * command-line typos.  Don't do it!
			 */
    int nice_incr;	/* value of the nice=nnn increment value */

    int mask;		/* umask setting */

    PassInfo passinfo;	/* password information */

    Simple2List userbefore;	/* list of u/g/h pats before per-cmd pats */
    Simple2List userafter;	/* list of u/g/h pats after per-cmd pats */
    SimpleList b_a_text;	/* list of original text for above */
    int user_clear;		/* clear userbefore list if new val seen */

    TimeList timebefore;	/* A list of the actual time ranges used */
    TimeList timeafter;		/* A list of the actual time ranges used */
    int time_clear;		/* clear timebefore list if new val seen */

    int use_after;		/* !set to !0 when we see <> */

    LogInfo log;		/* Information for logging to file */

    char mailcmd[500];		/* Information for logging via mail */
    int mail_success;	/* bool: mail on successful tries? (-1 = unknown) */
};
typedef struct globalInfo GlobalInfo;

/* A structure that holds information describing the caller */
struct userInfo {
    char caller[128];			/* who's invoking prog */
    char hostname[MAXHOSTNAMELEN];	/* whence came the user */
    char lc_hostname[MAXHOSTNAMELEN];	/* hostname in lower case */
    UID_T orig_uid;			/* caller's original uid */
    GID_T orig_gid;			/* caller's original gid */
    int orig_mask;			/* umask setting at startup */

    UID_T new_uid;			/* new uid, from uid=xxx or u+g=xxx */
    GID_T new_gid;			/* new gid, from gid=xxx or u+g=xxx */

    OurTime ourtime;			/* when we started, etc */

    char encr[20];			/* encrypted password */
    char salt[4];			/* salt from password */
};
typedef struct userInfo UserInfo;

/* A structure that holds the per-cmd information */
struct localInfo {
    ProgMatch progs;	/* Records prog::file sets, and is updated w/ matches */

    char *info;		/* value of info=xxx option */
    char *die;		/* Gets msg from die=msg ; null if none */
    char *print;	/* Gets msg from print=msg ; null if none */

    char user[32];	/* value of uid=xxx option */
    char group[32];	/* value of gid=xxx option */
    char u_g[32];	/* value of u+g=xxx option */
    char owner[32];	/* value of owner=xxx option */
    char *env;		/* value of env=var[,...] option */
    char *setenv[MAXSETENV+1];	/* values of setenv=var[,...] option */
    char *fdlist;	/* value of fd=nnn[,...] option */
    int mask;		/* value of umask=xxx option */
    int nice_incr;	/* value of the nice=nnn increment value */
    Simple2List userpats;	/* list of PermittedUser patterns */
    SimpleList origtext;	/* list of PermittedUser patterns */
    TimeList time;	/* A list of the actual time ranges used */
    int usr_args[2];	/* number of user-entered args allowed */
    StrArray argpats;	/* argNNN=xxx arguments */

    LogInfo log;	/* Information for logging to file */

    char mailcmd[500];	/* Information for logging via mail */
    int mail_success;	/* bool: mail on successful tries? (-1 = unknown) */

    int *fd;		/* descriptors from fdlist string */
    PassInfo passinfo;	/* password requirements on this command */
};
typedef struct localInfo LocalInfo;

extern FileList *currfile;		/* list of currently-open files */

extern GlobalInfo gi;			/* :global info */

extern UserInfo ui;			/* User's info */

extern LocalInfo li;			/* per-cmd info */

extern Conditions matches;		/* To keep track of what matched */

extern int error_stderr;		/* stderr() bool, used by Error() */
extern int error_syslog;		/* syslog() bool, used by Error() */
extern char *error_command;		/* command used by Error() */
extern char *error_user;		/* username printed by Error() */

extern int error_line;			/* line number, used by Error() */
extern int error_nl;			/* number of lines, used by Error() */
extern char *error_srcfile;		/* filename, used by Error() */

/* For use with strqtokS */
extern unsigned char *strqS_qm;		/* For fast access by strqtokS */
extern unsigned char my_qm[256];
extern unsigned char *strqS_cc;		/* For fast access by strqtokS */
extern unsigned char my_cc[256];
 
char	*strqtokS __P(( char *s, char *delim,
		char *quotemarks, char *commentchars, unsigned int flags));
void	init_strqtokS __P(( void ));

int	do_options(int argc, char **argv, int *help, int *vers, int *verbose);
int	get_canonical_hostname __P((char *buf, int len));
int	basic_userinfo __P( (void) );
char	*approve __P((char *usrcmd, int help, int version, int verbose));
int	check_owner __P(( char *file ));
char	**newargs __P((char *path_plus, char **argv, int *n_builtin));
char	**buttonup __P((char *));
int	set_u_g __P(( void ));
int	check_pass __P(( char *cmd ));
int	checkenv __P(( char *name,  char *value,  char *pat ));

int	parseline __P((int givehelp, int checksyntax, char *buf, char *usrcmd));
void	match_ugh_user __P((Simple2List *sl, int isglobal));

char	*str_val __P(( char *left, int sep, char *str ));
void	strtolower __P(( char *string ));
char	*ends __P(( char *s1, char *s2 ));
char	*clean_buf __P(( char *buf, char *outbuf ));
char	*fillbuffer __P(( FILE *fp, int *indentok, int *nl ));

int	Error __P(( int show_perror, int die, char * fmt, ... ));

int	get_password __P(( char *cmd, char *user,  char *salt,  char *encr ));
int	get_encrypted_pw __P(( void ));
char	*Getenv __P(( char *s ));
int	getlogdir __P((char *user, char *buf));
int	ingroup __P(( char * user, GID_T gid, char * gp_pat ));
void	logmsg __P(( char * cmd, char ** args ));

int	makedir __P(( char *directories ));
char	*makedirname __P(( char *prefix, char *hostname, char *path ));

FILE	*open_writer __P(( char *user, char *filename ));
void	close_writer __P(( void ));
void	opensuperlog __P(( void ));
void	printhelp __P(( int verbose ));
void	printhelp_hello __P(( int verbose, char *usrcmd ));

void	re_anchor __P(( char *in, char *out));
int	re_exec __P(( char *));
char	*re_comp __P(( char *));
void	anchor __P(( char *in, char *out ));
int	shell_compare __P(( char *));
char	*shell_compile __P(( char *));
int	match_pattern __P((int match, char *str, char *pattern));

void	StrInit __P(( StrArray *a ));
int	StrNelts __P(( StrArray *a ));
int	StrLastInUse __P(( StrArray *a ));
char	*StrEltGetPtr __P(( StrArray *a, int ielt ));
int	StrEltCpy __P(( StrArray *a, int ielt, char *str));
void	StrEltsUnused __P(( StrArray *a ));
int	StrNalloc __P(( StrArray *a, int nelt));

int	stringcopy __P(( char *to, char *from, int n));

char	*dayname __P(( int daynum ));
int	daynum __P(( int unixtime ));

int	InsertCondition __P(( char *condition, char *s, int isglobal ));
int	InsertTimeList __P(( char *str, TimeList *tl, char *type, int invert));
void	matchtime __P(( OurTime *our, TimeList *tl ));
void	readtime_init __P(( void ));
int	readtime __P(( char *str, short *t1, short *t2, char *d ));

FileList *file_open __P(( FileList *list, char *name ));
FileList *file_close __P(( FileList *list ));

void	debug_print __P((char *path, char **arglist, int n_builtin));
void	debug_hello __P((void));

void	init_umask __P((int is_global));
void	store_umask __P((int mask, int is_global));
void	set_umask __P((void));
int	rcl_umask __P((void));

void	init_nice_incr __P((int is_global));
void	store_nice_incr __P((int nice_incr, int is_global));
int	set_nice_incr __P((void));
int	rcl_nice_incr __P((void));

int	InsertUserList __P((char *, Simple2List *, SimpleList *, int ));
void	free_SimpleList __P(( SimpleList *));
void	free_Simple2List __P(( Simple2List *));
void	free_TimeList __P(( TimeList *));

char	*do_variables __P(( char *str));

int	process_colon_cmds __P(( char *command ));
int	colon_global __P(( char *command ));
int	global_arg __P((char *word));
int	colon_define __P(( char *command ));
int	add_variable __P(( char *varname, char *vardefn ));
int	colon_include __P(( char *command ));

int	build_cmd_file __P((char *usrcmd, int givehelp_or_checksyntax,
					char *word1, char **cond_or_opt_wd));
int	fixup_fullpath __P((int indx, char *usrcmd, char *path,
					char *FullPath, int l_FullPath));
int	conditions_and_options __P((char *cond_or_opt_wd));
int	handle_option __P((char *word, char *s, int isglobal));
int	option_clear_settings __P((char *word, char *s, int isglobal));
int	option_global_reset_settings __P((void));
int	option_local_clear_settings __P((void));


/* Routines used to compile/match user/group/host patterns */
extern char *(*pat_compile) __P(( char *));
extern int (*pat_compare) __P(( char *));
extern int need_re_anchor;

/* Number of elements in an array */
#define NELEM(x) (sizeof(x)/(sizeof(*x)))

/* n rounded up to a multiple of m -- both should be positive */
#define ROUNDUP(n, m) ( ((n) % (m) == 0) ? (n) : ((n)/(m) + 1)*(m) )

/* STRBEG evaluates to !0 if s1 begins with substring s2 */
#define STRBEG(s1, s2) (strncmp((s1), (s2), strlen(s2)) == 0)
 
/* STRMATCH3 expects 'end' to be a pointer into s2, and evaluates to !0
 * if characters s2..(end-1) fully match s1 (that is, the next character in
 * s1 is null.
 */
#define STRMATCH3(s1, s2, end) \
	       (strncmp(s1, s2, end-s2) == 0 && s1[end-s2]=='\0')
		    

#define UNTIL(e) while(!(e))
