/****************************************************************************
** $Id: qpdevmet.cpp,v 2.0 1996/09/24 10:15:55 agulbra Exp $
**
** Implementation of QPaintDeviceMetrics class
**
** Created : 941109
**
** Copyright (C) 1992-1996 Troll Tech AS.  All rights reserved.
**
** This file is part of the non-commercial distribution of Qt 1.0
** see the file LICENSE included in the distribution for the usage
** and distribution terms, or http://www.troll.no/qt/license.html.
**
** (This file differs from the commercial version of Qt only by this comment.)
**
*****************************************************************************/

#include "qpdevmet.h"

RCSTAG("$Id: qpdevmet.cpp,v 2.0 1996/09/24 10:15:55 agulbra Exp $");


/*!
  \class QPaintDeviceMetrics qpdevmet.h
  \brief The QPaintDeviceMetrics class provides information about a
  paint device.

  \ingroup paintdevice

  Sometimes it is necessary to obtain information about the
  physical size of a paint device when drawing graphics.

  Example:
  \code
    QPaintDeviceMetrics pdm( myWidget );
    float aspect = (float)pdm.widthMM / (float)pdm.heightMM();
  \endcode
*/

/*!
  Constructs a metric for the paint device \e pd.
*/
QPaintDeviceMetrics::QPaintDeviceMetrics( const QPaintDevice *pd )
{
    pdev = (QPaintDevice *)pd;
}


/*!
  \fn int QPaintDeviceMetrics::width() const

  Returns the width of the paint device, in default coordinate system
  units (e.g. pixels for QPixmap and QWidget).
*/

/*!
  \fn int QPaintDeviceMetrics::height() const

  Returns the height of the paint device, in default coordinate system
  units (e.g. pixels for QPixmap and QWidget).
*/

/*!
  \fn int QPaintDeviceMetrics::widthMM() const
  Returns the width of the paint device, measured in millimeters.
*/

/*!
  \fn int QPaintDeviceMetrics::heightMM() const
  Returns the height of the paint device, measured in millimeters.
*/

/*!
  \fn int QPaintDeviceMetrics::numColors() const
  Returns the number of different colors available for the paint device.
*/

/*!
  \fn int QPaintDeviceMetrics::depth() const
  Returns the bit depth (number of bit planes) of the paint device.
*/
