/****************************************************************************
** $Id: qconnect.h,v 2.0 1996/09/24 10:15:48 agulbra Exp $
**
** Definition of QConnection class
**
** Created : 930417
**
** Copyright (C) 1992-1996 Troll Tech AS.  All rights reserved.
**
** This file is part of the non-commercial distribution of Qt 1.0
** see the file LICENSE included in the distribution for the usage
** and distribution terms, or http://www.troll.no/qt/license.html.
**
** (This file differs from the commercial version of Qt only by this comment.)
**
*****************************************************************************/

#ifndef QCONNECT_H
#define QCONNECT_H

#include "qobject.h"


typedef void (QObject::*QMember)();		// pointer to member function


class QConnection				// signal coupling
{
public:
    QConnection( const QObject *, QMember, const char *memberName );
   ~QConnection() {}

    bool     isConnected() const { return obj != 0; }

    QObject *object() const { return obj; }	// get object/member pointer
    QMember *member() const;
    const char *memberName() const { return mbr_name; }

private:
    QObject *obj;				// object connected to
    QMember  mbr;				// member connected to
    const char *mbr_name;

private:	// Disabled copy constructor and operator=
    QConnection( const QConnection & ) {}
    QConnection &operator=( const QConnection & ) { return *this; }
};

inline QMember *QConnection::member() const
{ return (QMember*)&mbr; }


#endif // QCONNECT_H
