#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "interface.h"

#include "treedata.h"

#include "pics/treetool_icon"

static tframe mainframe=NULL;
static tpanel menubar;
static tpbutton nodeb, treeb, branchb;
static tpic icon;

int destroy_main_frame(f)
tframe f;
{
	return(quit(NULL));
}

int resize_main_frame(f, e)
tframe f;
tevent e;
{
	int w, h;

	if(tevent_type(e)==te_resize)
	{
		tevent_size(e, &w, &h);
		tpanel_set_width_to_frame(menubar, mainframe);
		resize_main_canvas(0, 0, w, h-tpanel_height(menubar), NULL, menubar);
		return(0);
	}
	else if(tevent_type(e)==te_create)
	{
		tframe_show(f);
	}
	else
		return(0);
}

int create_main_frame(args)
targs args;
{
    mainframe=tframe_new(NULL, 0, 0, 500, 500, 1, 0, 1, "TreeTool", args);
	if(mainframe==NULL)
		return(0);
	globals->frame=mainframe;
	tframe_set_event_procedure(mainframe, resize_main_frame);
	tframe_set_destroy_procedure(mainframe, destroy_main_frame);

	icon=(tpic)tpic_new(treetool_icon_bits,
		treetool_icon_width, treetool_icon_height);
	tframe_set_icon(mainframe, icon, NULL);

	globals->b=tcolor_new(mainframe, (char *)NULL, 0, 0, 0);
	globals->w=tcolor_new(mainframe, (char *)NULL, 65535, 65535, 65535);
	globals->fg=globals->b;
	globals->bg=globals->w;
	globals->ewin=(void *)tframe_notice_window(mainframe);
	globals->ex=-50;
	globals->ey=20;

    menubar=tpanel_new(mainframe, 0, 0, 200, 200, NULL, NULL, args);
	create_menu_items();
	create_tools(mainframe, args);
	create_menus(menubar);
    tpanel_fit(menubar);

	create_main_canvas(mainframe, menubar, args);

	if(globals->depth>1)
	{
		globals->handle_color=tcolor_new(mainframe, "red3", 0, 0, 0);
		globals->root_color=tcolor_new(mainframe, "green4", 0, 0, 0);
	}
	else
	{
		globals->handle_color=globals->b;
		globals->root_color=globals->b;
	}
	globals->handle_gc=tcontext_new(mainframe, args);
	globals->root_gc=tcontext_new(mainframe, args);
	if(globals->depth>1)
	{
		tcontext_set_function(globals->handle_gc, tc_copy);
		tcontext_set_function(globals->root_gc, tc_copy);
	}
	else
	{
		tcontext_set_function(globals->handle_gc, tc_xor);
		tcontext_set_function(globals->root_gc, tc_xor);
	}
	tcontext_set_foreground(globals->handle_gc, globals->handle_color);
	tcontext_set_foreground(globals->root_gc, globals->root_color);

	{
		static tpic grey;
#include "pics/grey"

		grey=(tpic)tpic_new(grey_bits, grey_width, grey_height);
		globals->handle_gc_grey=tcontext_new(mainframe, args);
		if(globals->depth>1)
			tcontext_set_function(globals->handle_gc_grey, tc_copy);
		else
			tcontext_set_function(globals->handle_gc_grey, tc_xor);
		tcontext_set_foreground(globals->handle_gc_grey,
			globals->handle_color);
		tcontext_set_fillstyle(globals->handle_gc_grey,
			tfill_opaquestippled);
		tcontext_set_stipple(globals->handle_gc_grey, grey);
	}


#ifdef DEBUG
	globals->testgc1=tcontext_new(mainframe, args);
	if(globals->depth>1)
	{
		tcontext_set_function(globals->testgc1, tc_copy);
		tcontext_set_foreground(globals->testgc1,
			tcolor_new(mainframe, "blue3", 0, 0, 0));
	}
	else
		tcontext_set_function(globals->testgc1, tc_xor);
	globals->testgc2=tcontext_new(mainframe, args);
	if(globals->depth>1)
	{
		tcontext_set_function(globals->testgc2, tc_copy);
		tcontext_set_foreground(globals->testgc2,
			tcolor_new(mainframe, "green3", 0, 0, 0));
	}
	else
		tcontext_set_function(globals->testgc2, tc_xor);
#endif


    tframe_fit(mainframe);
    tframe_set_min_size(mainframe, tpanel_width(menubar),
		tpanel_height(menubar)+250);
    tpanel_set_width_to_frame(menubar, mainframe);

    tfont_list(mainframe, &globals->name, &globals->style, &globals->size);
	globals->cfont=(tfont)tfont_get_font_by_names(globals->c,
		"Times", "Normal", 14);
	if(globals->cfont==NULL)
		globals->cfont=(tfont)tfont_get_first_font(globals->c);

	globals->listfont=(tfont)tfont_create_from_fontname(globals->c,
		"lucidasans-12");
	if(globals->listfont==NULL)
		globals->listfont=(tfont)tfont_create_from_fontname(globals->c,
			"fixed");

	create_save_dialog(mainframe);
    create_node_info_frame(mainframe, args);
    create_tree_info_frame(mainframe, args);
    create_branch_info_frame(mainframe, args);
    create_scale_info_frame(mainframe, args);
	create_load_dialog(mainframe);
	create_printer_frame(mainframe, args);
	create_find_frame(mainframe, args);
	create_about_frame(mainframe, args);
	create_help_frame(mainframe, args);
	create_globals_setup_frame(mainframe, args);
	return(1);
}

int off_and_running()
{
    /*tframe_show(mainframe);*/
    tframe_loop(mainframe);
}

set_main_message(s)
char *s;
{
	tframe_set_footer(mainframe, s);
}

hide_main_frame()
{
	tframe_hide(mainframe);
}

set_main_frame_name(s)
char *s;
{
	tframe_set_name(mainframe, s);
}

main_busy()
{
	if(mainframe!=NULL)
		tframe_set_busy(mainframe);
}

main_notbusy()
{
	if(mainframe!=NULL)
		tframe_set_notbusy(mainframe);
}
