/********************************************************************************
* Copyright (c) Erik Kunze 1995 - 1998
*
* Permission to use, distribute, and sell this software and its documentation
* for any purpose is hereby granted without fee, provided that the above
* copyright notice appear in all copies and that both that copyright notice and
* this permission notice appear in supporting documentation, and that the name
* of the copyright holder not be used in advertising or publicity pertaining to
* distribution of the software without specific, written prior permission.  The
* copyright holder makes no representations about the suitability of this
* software for any purpose.  It is provided "as is" without express or implied
* warranty. THE CODE MAY NOT BE MODIFIED OR REUSED WITHOUT PERMISSION!
*
* THE COPYRIGHT HOLDER DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
* EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE FOR ANY SPECIAL, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
* PERFORMANCE OF THIS SOFTWARE.
*
* Author: Erik Kunze
*******************************************************************************/
#ifdef HAVE_CONFIG_H
# include "config.h"
#endif
#ifndef lint
static char rcsid[] = "$Id: io.c,v 4.32 1999/03/30 20:08:03 erik Rel $";
#endif
#include <stdio.h>
#include <string.h>
#ifdef HAVE_MEMORY_H
# include <memory.h>
#endif
#include "z80.h"
#include "debug.h"
#include "resource.h"
#include "mem.h"
#include "machine.h"
#include "util.h"
#ifdef AUDIO
#include "audio.h"
#endif
#ifdef XZX_PLUS3
#include "fdc.h"
#endif
#include "emul.h"
#ifdef XZX_IF1
#include "if1.h"
#endif
#ifdef JOY
#include "joystick.h"
#endif
#include "keyboard.h"
#include "loadsave.h"
#ifdef XZX_MGT
#include "mgt.h"
#endif
#ifdef PRINTER
#include "printer.h"
#endif
#include "screen.h"
#include "tables.h"
#ifdef XZX_TRDOS
#include "trdos.h"
#endif
#include "io.h"
#define NELEM(a)		(sizeof(a) / sizeof(a[0]))
#ifdef DEBUG
#define DEB(x)			{ if (GETCFG(debug) & D_IO) { x } }
#else
#define DEB(x)
#endif
static inline void outBankm128(uns8);
#ifdef XZX_PLUS3
static inline void outBankmPl3(uns8);
#ifdef REGISTERED
static inline void outBank678(uns8);
#endif
#endif
uns8 Last0x7FFD;
#if defined(XZX_PLUS3) || defined(XZX_SCORPION)
uns8 Last0x1FFD;
#endif
uns8 Last0xFFFD;
int ScreenSelect;
uns8 InPorts[256];
uns8 LastBorderColor = 255;
uns8 Psg[16];
uns8 PsgMask[16] = {
0xff, 0x0f, 0xff, 0x0f, 0xff, 0x0f, 0x1f, 0xff,
0x1f, 0x1f, 0x1f, 0xff, 0xff, 0x0f, 0xff, 0xff
};
static uns8 outPorts[256];
#if defined(XZX_MF) && defined(XZX_PLUS3)
static int mf3Paged;
#endif
void
IoReset(void)
{
Machine->initPages();
#if defined(XZX_MF) && defined(XZX_PLUS3)
mf3Paged = 0;
#endif
Last0x7FFD = 0;
#ifdef XZX_PLUS3
Last0x1FFD = 0;
#endif
Last0xFFFD = 0;
ScreenSelect = RAM5;
KbdReset();
(void)memset(InPorts, 0x00, sizeof(InPorts));
(void)memset(outPorts, 0x00, sizeof(outPorts));
(void)memset(Psg, 0x00, sizeof(Psg));
#ifdef AYCHIP_AUDIO
AyReset();
#endif
#if defined(XZX_PLUS3) && defined(REGISTERED)
FdcReset();
#endif
#ifdef XZX_TRDOS
TrdosReset();
#endif
#ifdef XZX_MGT
MgtReset();
#endif
}
void
IoNMI(void)
{
#ifdef XZX_MF
if (GETCFG(mfActive))
{
(void)Machine->inPort(GETCFG(machine) <= SP_128 ? P_MF128IN : P_MF3IN);
}
#endif
}
static inline void
outBankm128(uns8 val)
{
DEB(Msg(M_DEBUG,
"bankm: RAM select %d, ROM select %d, screen %d, paging %sabled",
val & B_SELRAM, (val & B_SELROM) >> 4, (val & B_SELSCREEN) >> 3,
PAGING_DISABLED(Last0x7FFD) ? "dis" : "en"););
if (Last0x7FFD == val || PAGING_DISABLED(Last0x7FFD))
{
return;
}
ScreenSelect = val & B_SELSCREEN ? RAM7 : RAM5;
if ((val & B_SELSCREEN) != (Last0x7FFD & B_SELSCREEN))
{
ForceScreenRefresh();
}
Last0x7FFD = val;
Machine->pageIn(3, RAM0 + (val & B_SELRAM));
#ifdef XZX_MF
if (RPAGE(0) != MF128ROM)
#endif
{
Machine->pageIn(0, SP128ROM0 + ((val & B_SELROM) >> 4));
}
}
#ifdef XZX_PLUS3
static inline void
outBankmPl3(uns8 val)
{
DEB(Msg(M_DEBUG,
"bankm: RAM select %d, ROM select %d, screen %d, paging %sabled",
val & B_SELRAM, (val & B_SELROM) >> 4, (val & B_SELSCREEN) >> 3,
PAGING_DISABLED(Last0x7FFD) ? "dis" : "en"););
if (Last0x7FFD == val || PAGING_DISABLED(Last0x7FFD))
{
return;
}
ScreenSelect = val & B_SELSCREEN ? RAM7 : RAM5;
if ((val & B_SELSCREEN) != (Last0x7FFD & B_SELSCREEN))
{
ForceScreenRefresh();
}
Last0x7FFD = val;
if (!EXTENDED_RAM(Last0x1FFD))
{
Machine->pageIn(1, RAM5);
Machine->pageIn(2, RAM2);
Machine->pageIn(3, RAM0 + (val & B_SELRAM));
#ifdef XZX_MF
if (!mf3Paged)
#endif
{
Machine->pageIn(0, SP3ROM0 +
(((val & B_SELROM) >> 4) |
((Last0x1FFD & B_SELROM3) >> 1)));
}
DEB(Msg(M_DEBUG, "bankm: horizontal ROM switch"););
}
}
#endif
#ifdef XZX_PLUS3
#ifdef REGISTERED
static inline void
outBank678(uns8 val)
#else
void
OutBank678(uns8 val)
#endif
{
DEB(Msg(M_DEBUG, "bank678: %s", EXTENDED_RAM(Last0x1FFD) ?
"extended RAM enabled" : "vertical ROM switch"););
if (Last0x1FFD == val || PAGING_DISABLED(Last0x7FFD))
{
return;
}
if (!EXTENDED_RAM(val))
{
#ifdef XZX_MF
if (mf3Paged)
{
if (RPAGE(0) != MF3ROM)
{
Machine->pageIn(0, MF3ROM);
}
}
else
#endif
{
Machine->pageIn(0, SP3ROM0 +
(((Last0x7FFD & B_SELROM) >> 4) |
((val & B_SELROM3) >> 1)));
}
}
else
{
switch ((val & B_SELRAM3) >> 1)
{
case 0:
Machine->pageIn(0, RAM0);
Machine->pageIn(1, RAM1);
Machine->pageIn(2, RAM2);
Machine->pageIn(3, RAM3);
DEB(Msg(M_DEBUG, "bank678: 0,1,2,3"););
break;
case 1:
Machine->pageIn(0, RAM4);
Machine->pageIn(1, RAM5);
Machine->pageIn(2, RAM6);
Machine->pageIn(3, RAM7);
DEB(Msg(M_DEBUG, "bank678: 4,5,6,7"););
break;
case 2:
Machine->pageIn(0, RAM4);
Machine->pageIn(1, RAM5);
Machine->pageIn(2, RAM6);
Machine->pageIn(3, RAM3);
DEB(Msg(M_DEBUG, "bank678: 4,5,6,3"););
break;
case 3:
Machine->pageIn(0, RAM4);
Machine->pageIn(1, RAM7);
Machine->pageIn(2, RAM6);
Machine->pageIn(3, RAM3);
DEB(Msg(M_DEBUG, "bank678: 4,7,6,3"););
break;
}
}
#ifdef PLUS3_PRINTER
if ((val ^ Last0x1FFD) & B_STROBE)
{
Plus3PrinterStrobe(val);
}
#endif
Last0x1FFD = val;
}
#endif
void
OutPort48(uns16 port, uns8 val)
{
DEB(if (LOWBYTE(port) != P_ULA)
{
Msg(M_DEBUG, "writing <%02x> to port <%04x>", val, port);
});
#ifdef XZX_TRDOS
OUTBYTE_TRDOS(port, val);
#endif
#ifdef XZX_MGT
OUTBYTE_MGT(port, val);
#endif
if (!(port & B_ULA))
{
if (LastBorderColor != (val & B_BORDER))
{
LastBorderColor = val & B_BORDER;
SetBorderColor(LastBorderColor);
}
#ifdef SPEAKER_AUDIO
SpeakerOutByte(val);
#endif
#ifdef EMULATE_ULA_DELAY
TSTATES += UlaDelay[TSTATES] & 0x7f;
#endif
}
if (LOWBYTE(port) == P_128)
{
if ((port & B_SNDCHIP) == (P_SNDCONTROL & B_SNDCHIP))
{
if (port & B_SNDCONTROL)
{
Last0xFFFD = val;
}
else
{
if (Last0xFFFD < NELEM(Psg))
{
Psg[Last0xFFFD] = val;
}
else
{
DEB(Msg(M_DEBUG, "writing AY register %d", Last0xFFFD););
}
if (Last0xFFFD == 14)
{
DEB(Msg(M_DEBUG, "writing AY register 14"););
}
#ifdef AYCHIP_AUDIO
else if (Last0xFFFD < 14)
{
AyOutByte(Last0xFFFD, val);
}
#endif
}
}
#ifdef PEDANTIC
else
{
Msg(M_WARN, "output to 128K/+3 port <%04x> in 48K mode", port);
}
#endif
}
#ifdef ZX_PRINTER
if (!(port & B_PRINTER))
{
ZxPrinterOutByte(val);
}
#endif
#ifdef XZX_IF1
OUTBYTE_IF1(port, val);
#endif
#ifdef PSEUDO_IO
if (port == PSEUDO_STDOUT)
{
(void)putc((int)val, stdout);
}
else if (port == PSEUDO_STDERR)
{
(void)putc((int)val, stderr);
}
#endif
outPorts[LOWBYTE(port)] = val;
}
void
OutPort128(uns16 port, uns8 val)
{
DEB(if (LOWBYTE(port) != P_ULA)
{
Msg(M_DEBUG, "writing <%02x> to port <%04x>", val, port);
});
#ifdef XZX_TRDOS
OUTBYTE_TRDOS(port, val);
#endif
#ifdef XZX_MGT
OUTBYTE_MGT(port, val);
#endif
if (!(port & B_ULA))
{
if (LastBorderColor != (val & B_BORDER))
{
LastBorderColor = val & B_BORDER;
SetBorderColor(LastBorderColor);
}
#ifdef SPEAKER_AUDIO
SpeakerOutByte(val);
#endif
}
if (LOWBYTE(port) == P_128)
{
if ((port & B_SNDCHIP) == (P_SNDCONTROL & B_SNDCHIP))
{
if (port & B_SNDCONTROL)
{
Last0xFFFD = val;
}
else
{
if (Last0xFFFD < NELEM(Psg))
{
Psg[Last0xFFFD] = val;
}
else
{
DEB(Msg(M_DEBUG, "writing AY register %d", Last0xFFFD););
}
if (Last0xFFFD == 14)
{
DEB(Msg(M_DEBUG, "writing AY register 14"););
}
#ifdef AYCHIP_AUDIO
else if (Last0xFFFD < 14)
{
AyOutByte(Last0xFFFD, val);
}
#endif
}
}
else
{
if ((port & B_BANK128) == (P_BANK128 & B_BANK128))
{
outBankm128(val);
}
}
}
#ifdef XZX_IF1
OUTBYTE_IF1(port, val);
#endif
#ifdef PSEUDO_IO
if (port == PSEUDO_STDOUT)
{
(void)putc((int)val, stdout);
}
else if (port == PSEUDO_STDERR)
{
(void)putc((int)val, stderr);
}
#endif
outPorts[LOWBYTE(port)] = val;
}
#ifdef XZX_PLUS3
void
OutPort3(uns16 port, uns8 val)
{
DEB(if (LOWBYTE(port) != P_ULA)
{
Msg(M_DEBUG, "writing <%02x> to port <%04x>", val, port);
});
if (!(port & B_ULA))
{
if (LastBorderColor != (val & B_BORDER))
{
LastBorderColor = val & B_BORDER;
SetBorderColor(LastBorderColor);
}
#ifdef SPEAKER_AUDIO
SpeakerOutByte(val);
#endif
}
if (LOWBYTE(port) == P_128)
{
if ((port & B_SNDCHIP) == (P_SNDCONTROL & B_SNDCHIP))
{
if (port & B_SNDCONTROL)
{
Last0xFFFD = val;
}
else
{
if (Last0xFFFD < NELEM(Psg))
{
Psg[Last0xFFFD] = val;
}
else
{
DEB(Msg(M_DEBUG, "writing AY register %d", Last0xFFFD););
}
if (Last0xFFFD == 14)
{
DEB(Msg(M_DEBUG, "writing AY register 14"););
}
#ifdef AYCHIP_AUDIO
else if (Last0xFFFD < 14)
{
AyOutByte(Last0xFFFD, val);
}
#endif
}
}
else
{
switch(port)
{
case P_BANK128:
outBankmPl3(val);
break;
case P_BANK3:
#ifdef REGISTERED
outBank678(val);
#else
OutBank678(val);
#endif
break;
#ifdef PLUS3_PRINTER
case P_CENTRONICS:
Plus3PrinterOutByte(val);
break;
#endif
#ifdef REGISTERED
case P_FDCDATA:
FdcDataOutByte(val);
break;
#endif
}
}
}
outPorts[LOWBYTE(port)] = val;
}
#endif
uns8
InPort48(uns16 port)
{
DEB(if (LOWBYTE(port) != P_ULA)
{
Msg(M_DEBUG, "reading from port <%04x>", port);
});
#ifdef XZX_TRDOS
INBYTE_TRDOS(port);
#endif
#ifdef XZX_MGT
INBYTE_MGT(port);
#endif
if (!(port & B_KEMPSTON))
{
#ifdef JOY
if (GETCFG(joyActive) > 0)
{
InPorts[P_KEMPSTON] = (uns8)JoyRead();
}
#endif
return (InPorts[P_KEMPSTON] &
(B_RIGHT | B_LEFT | B_DOWN | B_UP | B_FIRE));
}
if (!(port & B_ULA))
{
uns8 res = GETCFG(machine) == SP_48_2
? outPorts[P_ULA] & (B_SPEAKER | B_MIC) ? 0xff : 0xbf
: outPorts[P_ULA] & B_SPEAKER ? 0xff : 0xbf;
if (!(port & 0x8000))
{
res &= KeyPorts[7];
}
if (!(port & 0x4000))
{
res &= KeyPorts[6];
}
if (!(port & 0x2000))
{
res &= KeyPorts[5];
}
if (!(port & 0x1000))
{
res &= KeyPorts[4];
}
if (!(port & 0x0800))
{
res &= KeyPorts[3];
}
if (!(port & 0x0400))
{
res &= KeyPorts[2];
}
if (!(port & 0x0200))
{
res &= KeyPorts[1];
}
if (!(port & 0x0100))
{
res &= KeyPorts[0];
}
res ^= TpGetNextBit();
#ifdef EMULATE_ULA_DELAY
TSTATES += 1;
#endif
return res;
}
if (LOWBYTE(port) == P_128)
{
if ((port & (B_SNDCHIP | B_SNDDATA)) ==
(P_SNDCONTROL & (B_SNDCHIP | B_SNDCONTROL)))
{
if (Last0xFFFD == 14)
{
DEB(Msg(M_DEBUG, "reading AY register 14"););
return (Psg[7] & 0x40 ? 0x3f & Psg[14] : 0x3f);
}
else if (Last0xFFFD < 14)
{
return (Psg[Last0xFFFD] & PsgMask[Last0xFFFD]);
}
else if (Last0xFFFD == 15)
{
return (Psg[7] & 0x80 ? Psg[15] : 0xff);
}
else
{
return 0x00;
}
}
#ifdef PEDANTIC
else
{
Msg(M_WARN, "input from 128K/+3 port <%04x> in 48K mode", port);
}
#endif
}
#ifdef ZX_PRINTER
if (!(port & B_PRINTER))
{
return (ZxPrinterInByte());
}
#endif
#ifdef XZX_IF1
INBYTE_IF1(port);
#endif
#ifdef XZX_MF
if (GETCFG(mfActive))
{
if (LOWBYTE(port) == P_MF128OUT && RPAGE(0) == MF128ROM)
{
Machine->pageIn(0, SP48ROM);
return 0xff;
}
else if (LOWBYTE(port) == P_MF128IN)
{
Machine->pageIn(0, MF128ROM);
return (Last0x7FFD & B_SELSCREEN ? 0xff : 0x7f);
}
}
#endif
#ifdef PSEUDO_IO
if (port == PSEUDO_STDIN)
{
return ((uns8)getchar());
}
#endif
if (ULA_DRAWS_SCREEN)
{
unsigned int tstatesInLine = TSTATES % Machine->tstatesPerLine;
unsigned int line = Vline - Machine->topBorder;
return (RealMemory[ScreenSelect][(tstatesInLine & 0x02 ?
Line2Attr[line] : Line2Pix[line]) +
(tstatesInLine >> 2)]);
}
return 0xff;
}
uns8
InPort128(uns16 port)
{
DEB(if (LOWBYTE(port) != P_ULA)
{
Msg(M_DEBUG, "reading from port <%04x>", port);
});
#ifdef XZX_TRDOS
INBYTE_TRDOS(port);
#endif
#ifdef XZX_MGT
INBYTE_MGT(port);
#endif
if (!(port & B_KEMPSTON))
{
#ifdef JOY
if (GETCFG(joyActive) > 0)
{
InPorts[P_KEMPSTON] = (uns8)JoyRead();
}
#endif
return (InPorts[P_KEMPSTON] &
(B_RIGHT | B_LEFT | B_DOWN | B_UP | B_FIRE));
}
if (!(port & B_ULA))
{
uns8 res = outPorts[P_ULA] & B_SPEAKER ? 0xff : 0xbf;
if (!(port & 0x8000))
{
res &= KeyPorts[7];
}
if (!(port & 0x4000))
{
res &= KeyPorts[6];
}
if (!(port & 0x2000))
{
res &= KeyPorts[5];
}
if (!(port & 0x1000))
{
res &= KeyPorts[4];
}
if (!(port & 0x0800))
{
res &= KeyPorts[3];
}
if (!(port & 0x0400))
{
res &= KeyPorts[2];
}
if (!(port & 0x0200))
{
res &= KeyPorts[1];
}
if (!(port & 0x0100))
{
res &= KeyPorts[0];
}
res ^= TpGetNextBit();
return res;
}
if (LOWBYTE(port) == P_128)
{
if ((port & (B_SNDCHIP | B_SNDDATA)) ==
(P_SNDCONTROL & (B_SNDCHIP | B_SNDCONTROL)))
{
if (Last0xFFFD == 14)
{
DEB(Msg(M_DEBUG, "reading AY register 14"););
return (Psg[7] & 0x40 ? 0x3f & Psg[14] : 0x3f);
}
else if (Last0xFFFD < 14)
{
return (Psg[Last0xFFFD] & PsgMask[Last0xFFFD]);
}
else if (Last0xFFFD == 15)
{
return (Psg[7] & 0x80 ? Psg[15] : 0xff);
}
else
{
return 0x00;
}
}
}
#ifdef XZX_IF1
INBYTE_IF1(port);
#endif
#ifdef XZX_MF
if (GETCFG(mfActive))
{
if (LOWBYTE(port) == P_MF128OUT && RPAGE(0) == MF128ROM)
{
Machine->pageIn(0, SP128ROM0 + ((Last0x7FFD & B_SELROM) >> 4));
return 0xff;
}
else if (LOWBYTE(port) == P_MF128IN)
{
Machine->pageIn(0, MF128ROM);
return (Last0x7FFD & B_SELSCREEN ? 0xff : 0x7f);
}
}
#endif
#ifdef PSEUDO_IO
if (port == PSEUDO_STDIN)
{
return ((uns8)getchar());
}
#endif
if (ULA_DRAWS_SCREEN)
{
unsigned int tstatesInLine = TSTATES % Machine->tstatesPerLine;
unsigned int line = Vline - Machine->topBorder;
return (RealMemory[ScreenSelect][(tstatesInLine & 0x02 ?
Line2Attr[line] : Line2Pix[line]) +
(tstatesInLine >> 2)]);
}
return 0xff;
}
#ifdef XZX_PLUS3
uns8
InPort3(uns16 port)
{
DEB(if (LOWBYTE(port) != P_ULA)
{
Msg(M_DEBUG, "reading from port <%04x>", port);
});
if (!(port & B_KEMPSTON))
{
#ifdef JOY
if (GETCFG(joyActive) > 0)
{
InPorts[P_KEMPSTON] = (uns8)JoyRead();
}
#endif
return (InPorts[P_KEMPSTON] &
(B_RIGHT | B_LEFT | B_DOWN | B_UP | B_FIRE));
}
if (!(port & B_ULA))
{
uns8 res = 0xbf;
if (!(port & 0x8000))
{
res &= KeyPorts[7];
}
if (!(port & 0x4000))
{
res &= KeyPorts[6];
}
if (!(port & 0x2000))
{
res &= KeyPorts[5];
}
if (!(port & 0x1000))
{
res &= KeyPorts[4];
}
if (!(port & 0x0800))
{
res &= KeyPorts[3];
}
if (!(port & 0x0400))
{
res &= KeyPorts[2];
}
if (!(port & 0x0200))
{
res &= KeyPorts[1];
}
if (!(port & 0x0100))
{
res &= KeyPorts[0];
}
res ^= TpGetNextBit();
return res;
}
if (LOWBYTE(port) == P_128)
{
if ((port & (B_SNDCHIP | B_SNDDATA)) ==
(P_SNDCONTROL & (B_SNDCHIP | B_SNDCONTROL)))
{
if (Last0xFFFD == 14)
{
DEB(Msg(M_DEBUG, "reading AY register 14"););
return (Psg[7] & 0x40 ? 0x3f & Psg[14] : 0x3f);
}
else if (Last0xFFFD < 14)
{
return (Psg[Last0xFFFD] & PsgMask[Last0xFFFD]);
}
else if (Last0xFFFD == 15)
{
return (Psg[7] & 0x80 ? Psg[15] : 0xff);
}
else
{
return 0x00;
}
}
switch(port)
{
#ifdef PLUS3_PRINTER
case P_CENTRONICS:
return (Plus3PrinterInByte());
#endif
#ifdef REGISTERED
case P_FDCCONTROL:
return (FdcControlInByte());
case P_FDCDATA:
return (FdcDataInByte());
#endif
}
}
#ifdef XZX_MF
if (GETCFG(mfActive))
{
if (LOWBYTE(port) == P_MF3OUT && mf3Paged)
{
if (!EXTENDED_RAM(Last0x1FFD))
{
Machine->pageIn(0, SP3ROM0 +
(((Last0x7FFD & B_SELROM) >> 4) |
((Last0x1FFD & B_SELROM3) >> 1)));
}
mf3Paged = 0;
}
else if (LOWBYTE(port) == P_MF3IN)
{
if (!mf3Paged)
{
if (!EXTENDED_RAM(Last0x1FFD))
{
Machine->pageIn(0, MF3ROM);
}
mf3Paged = 1;
}
if (port == P_MF3P7FFD)
{
return Last0x7FFD;
}
else if (port == P_MF3P1FFD)
{
return Last0x1FFD;
}
}
}
#endif
return 0xff;
}
#endif
