/*  -*- c -*-  */
/* -------------------------------------------------------------------- *
**  copyright (c) 1995 ipvr stuttgart and thomas harrer
** -------------------------------------------------------------------- *
**
**  libhelp
**
**  a comprehensive hypertext help system for OSF/Motif(tm) applications. 
**  based on libhtmlw from NCSA Mosaic(tm) version 2.4
**
**  written by thomas harrer
**  e-mail: Thomas.Harrer@rus.uni-stuttgart.de
**  
** -------------------------------------------------------------------- *
*h  $Id: bcache.h,v 1.3 1995/06/28 12:59:30 thomas Exp $
** -------------------------------------------------------------------- *
**
*h  module:		bcache.h
**
**  contents:		header file for buffer cache (bcache)
**
**  interface:		#include "bcache.h"
**
** -------------------------------------------------------------------- *
**  license and copying issues:
**
**  this software is free; you can redistribute it and/or modify it 
**  under terms similar to the gnu general public license (version 1 
**  or any later version published by the free software foundation). 
**  see the file Licence for more details.
**
**  this program is distributed in the hope that it will be useful,
**  but without any warranty; without even the implied warranty of
**  merchantability or fitness for a particular purpose.  
** -------------------------------------------------------------------- */
#ifndef _BCACHE_H_
#define _BACHE_H_ 1

/* -------------------------------------------------------------------- *
*g  includes
** -------------------------------------------------------------------- */
#include "buffer.h"

/* -------------------------------------------------------------------- *
*g  prototypes
** -------------------------------------------------------------------- */
/* -------------------------------------------------------------------- *
*p  procedure-name:	bcache_current
**
**  purpose:		returns the current path and filename or NULL.
**			the returned buffer must be freed by the caller.
** -------------------------------------------------------------------- *
**  returns:	        if we have a file and a pathname, we concatenate
**			them. if we have either a file or a path, we return 
**			it. else we return NULL.
** -------------------------------------------------------------------- */
char*
bcache_current (void);

/* -------------------------------------------------------------------- *
*p  procedure-name:	bcache_find
**
**  purpose:		returns a cached buffer or NULL
** -------------------------------------------------------------------- *
**  args:		filename
**  return type:	buffer_t*	
**  side effect:	the current path is added to the help path.
**  error handling.:	returns NULL.
** -------------------------------------------------------------------- */
buffer_t*	
bcache_find (/* i  */ char* ref);

/* -------------------------------------------------------------------- *
*p  procedure-name:	bcache_insert
**
**  purpose:		inserts a buffer into the cache.
** -------------------------------------------------------------------- *
**  args:		current_path is a pointer to an allocated string.
**			bcache_free is responsible to free it.
**  side effect:	the current path is added to the help path.
** -------------------------------------------------------------------- */
void
bcache_insert (/* i  */ char* 		ref,
	       /* i  */ char*		current_path,
	       /* i  */ buffer_t* 	buf);


/* -------------------------------------------------------------------- *
*p  procedure-name:	bcache_flush
**
**  purpose:		releases all cached memory.
** -------------------------------------------------------------------- */
void
bcache_flush (void);

#endif /* !_BCACHE_H_ */
/* -------------------------------------------------------------------- *
*l  emacs:
**  local variables:
**  mode:		c
**  outline-regexp:	"\*[HGPLT]"
**  comment-column:	32
**  eval:		(outline-minor-mode t)
**  end:
** -------------------------------------------------------------------- */
