.TH FFT G "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an
.SH NAME
fft - fast Fourier transform.
.SH CALLING SEQUENCE
.nf
[x]=fft(a,-1)
[x]=fft(a,1)
x=fft(a,-1,dim,incr)
x=fft(a,1,dim,incr)
.fi
.SH PARAMETERS
.TP 10
x
: real or complex vector. Real or complex matrix (2-dim fft)
.TP
a
: real or complex vector.
.TP
dim
: integer
.TP
incr
: integer
.SH DESCRIPTION
Short syntax (one or two dimensional fft):
.LP
.Vb x=fft(a,-1)
gives a direct transform (the \fV-1\fR refers to
the sign of the exponent..., NOT to "inverse"), that is
.IG
x(k)=sum over m from 1 to n  of a(m)*exp(-2i*pi*(m-1)*(k-1)/n)
.FI
.LA $$ x(k)=\sum_{m=1}^n { a(m) exp(-2i \pi (m-1)(k-1)/n)} $$
for k varying from 1 to n (n=size of vector \fVa\fR).
.LP
.Vb a=fft(x,1)
performs the inverse transform normalized by \fV1/n\fR.
.LP
(\fVfft(fft(.,-1),1)\fR is identity).
.LP
When the first argument given to \fVfft\fR is a matrix
a two-dimensional FFT is performed.
.LP
Long syntax (multidimensional FFT):
.Vb x=fft(a,-1,dim,incr)
allows to perform an multidimensional fft.
.LP
If a is a real or complex vector implicitly indexed by
\fVx1,x2,..,xp\fR i.e. \fVa(x1,x2,..,xp)\fR where \fVx\fR1 lies in 
\fV1..dim1,\fR \fVx2\fR in \fV1.. dim2,...\fR one gets 
a p-dimensional FFT p by calling p times \fVfft\fR as follows
.nf
 a1=fft(a ,-1,dim1,incr1)
 a2=fft(a1,-1,dim2,incr2) ...
.fi
where \fVdimi\fR is the dimension of the current variable w.r.t which
one is integrating and incri is the increment which separates
two successive \fVxi\fR elements in \fVa\fR.
.LP
In particular,if \fVa\fR is an nxm matrix,
\fVx=fft(a,-1)\fR is equivalent to the two instructions:
.LP
\fVa1=fft(a,-1,m,1)\fR and \fVx=fft(a1,-1,n,m)\fR.
.SH EXAMPLE 
.nf
a=[1;2;3];n=size(a,'*');
norm(1/n*exp(2*%i*%pi*(0:n-1)'.*.(0:n-1)/n)*a -fft(a,1))
norm(exp(-2*%i*%pi*(0:n-1)'.*.(0:n-1)/n)*a -fft(a,-1))  
.fi 
.SH SEE ALSO
corr
