.TH scicos_main  "Janvier 1997" "Scilab Group" "Scicos data structure"
.so ../sci.an
.SH NAME
scicos_main - Scicos editor main  data structure
.SH DEFINITION
.nf
scs_m=list(params,o_1,....,o_n)


.fi
.SH PARAMETERS
.TP
params
: Scilab list, \fVparams=list(wpar,title,tol,tf,context,void,options,void,void,doc))\fR
.RS
.TP
wpar
: viewing parameters:\fV [w,h,Xshift,Yshift]\fR
.RS
.TP
w 
: real scalar,Scicos editor window width
.TP
h 
: real scalar,Scicos editor window height
.TP
Xshift 
: real scalar, diagram drawing x offset within Scicos editor window
.TP
Yshift 
: real scalar, diagram drawing y offset within Scicos editor window
.RE
.TP
title 
: character string, diagram title and default name of save file name
.TP
tol
: 1 x 4 vector \fV[atol,rtol,ttol,maxt]\fR, where  \fVatol\fR, \fVrtol\fR are
respectively absolute and relative tolerances for the ode solver,
\fVttol\fR is the  minimal distance between to different events time
and \fVmaxt\fR is maximum integration time interval for a single call to the
ode solver.
.TP
tf
: real scalar, final time for simulation.
.TP
context
: vector of character strings, Scilab instructions used to define
Scilab variables  used in block definitions as symbolic parameters.
.TP
void 
: unused fields
.TP
options
: \fV list(With3D,Color3D)\fR
.RS
.TP
With3D
: boolean, true for 3D shape blocks
.TP
Color3D
: vector with three entries \fV [R,G,B]\fR. defines the color of 3D shape
.RE
.TP
doc
: user defined diagram documentation structure, default value is \fV list()\fR
.RE
.TP
o_i
: block or link  or deleted object data structure. 

See \fVscicos_block\fR and \fVscicos_link\fR). 

Deleted object data structure is marked \fVlist('Deleted')\fR.
.TP
scs_m
: main Scicos structure
.SH DESCRIPTION
Scicos editor uses and modifies the  Scicos editor main  data
structure to keep all information relative to the edited
diagram. Scicos compiler uses it as a input.

.SH SEE ALSO
scicos,  scicos_block, scicos_link 







