/*-------------- Telecommunications & Signal Processing Lab ---------------
                             McGill University

Routine:
  int FNiLog2 (int a)

Purpose:
  Find the integer greater or equal to log (base 2)

Description:
  This function returns the number of bits needed to represent an integer.  The
  input value must be positive.

Parameters:
  <-  int FNiLog2
      Returned integer value
   -> int a
      Input value

Author / revision:
  P. Kabal  Copyright (C) 1997
  $Revision: 1.3 $  $Date: 1997/10/10 18:41:09 $

-------------------------------------------------------------------------*/

static char rcsid[] = "$Id: FNiLog2.c 1.3 1997/10/10 libtsp-v3r0 $";

#include <libtsp.h>
#include <libtsp/FNmsg.h>


int
FNiLog2 (a)

     int a;

{
  int log2;
  int m;

  if (a <= 0)
    UThalt ("FNiLog2: %s", FNM_NonPosValue);

/* This routine successively divides the input value to determine the number
   of bits needed to represent it (actually a-1).  This requires log_2(a)
   iterations.  A more efficient routine would result if we used a table of
   powers of two and used a binary search in the table.  However, the size
   of the table is machine dependent.  That approach would require
   log_2 (log_2 (Max_Value)) probes, say 5 for 32 bit integers, but each
   probe is more compicated that the test in this loop.
*/
  log2 = 0;
  m = a - 1;
  while (m > 0) {
    ++log2;
    m = m / 2;
  }
  return log2;

}
