/****************************************************************************/
/*                                                                          */
/* IMG* Image Processing Tools Library                                      */
/* Program:   imgSplit.c                                                    */
/* Author:    Simon A.J. Winder                                             */
/* Date:      Thu Oct 20 20:45:57 1994                                      */
/* Copyright (C) 1994 Simon A.J. Winder                                     */
/*                                                                          */
/****************************************************************************/

#include "tools.h"

#define PRGNAME "Split"
#define ERROR(e) imgError(e,PRGNAME)
#define ARG_ERROR(e,arg) imgArgError(e,arg,PRGNAME)

int main(int argc,char **argv)
{
  it_image *image;
  int file;

  IFHELP
    {
      fprintf(stderr,"img%s - Write images from the input stream to files\n",
	      PRGNAME);
      fprintf(stderr,"img%s file1 [file2 [...]]\n",PRGNAME);
      fprintf(stderr,"  stdin: Any\n");
      fprintf(stderr,"  stdout: None\n");
      fprintf(stderr,"  file: Any\n");
      exit(0);
    }

  if(argc<2)
    ERROR("filename arguments required");
  imgStart(PRGNAME);
  for(file=1;file<argc;file++)
    {
      if((image=i_read_image_file(stdin,IT_ANY,IM_FRAGMENT))==NULL)
	ERROR("can't import image file");
      if(i_save_image(argv[file],-1,image,IF_BINARY))
	ARG_ERROR("can't write %s",argv[file]);
      i_destroy_image(image);
    }
  /* Junk further input */
  while(fgetc(stdin)!=EOF);
  imgFinish(PRGNAME);
  return(0);
}
/* Version 1.0 (Oct 1994) */
/* Version 1.1 (Nov 1994) */
